/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct;

import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.query.distinct.DistinctExecutor;
import org.apache.pinot.core.query.distinct.table.DistinctTable;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;

public abstract class BaseSingleColumnDistinctExecutor<T extends DistinctTable, S, M>
implements DistinctExecutor {
    protected final ExpressionContext _expression;
    protected final T _distinctTable;

    public BaseSingleColumnDistinctExecutor(ExpressionContext expression, T distinctTable) {
        this._expression = expression;
        this._distinctTable = distinctTable;
    }

    @Override
    public boolean process(ValueBlock valueBlock) {
        BlockValSet blockValueSet = valueBlock.getBlockValueSet(this._expression);
        int numDocs = valueBlock.getNumDocs();
        if (((DistinctTable)this._distinctTable).isNullHandlingEnabled() && blockValueSet.isSingleValue()) {
            RoaringBitmap nullBitmap = blockValueSet.getNullBitmap();
            if (nullBitmap != null && !nullBitmap.isEmpty()) {
                return this.processWithNull(blockValueSet, numDocs, nullBitmap);
            }
            return this.processWithoutNull(blockValueSet, numDocs);
        }
        return this.processWithoutNull(blockValueSet, numDocs);
    }

    private boolean processWithNull(BlockValSet blockValueSet, int numDocs, RoaringBitmap nullBitmap) {
        ((DistinctTable)this._distinctTable).addNull();
        S values = this.getValuesSV(blockValueSet);
        PeekableIntIterator nullIterator = nullBitmap.getIntIterator();
        int prev = 0;
        while (nullIterator.hasNext()) {
            int nextNull = nullIterator.next();
            if (nextNull > prev && this.processSV(values, prev, nextNull)) {
                return true;
            }
            prev = nextNull + 1;
        }
        if (prev < numDocs) {
            return this.processSV(values, prev, numDocs);
        }
        return false;
    }

    private boolean processWithoutNull(BlockValSet blockValueSet, int numDocs) {
        if (blockValueSet.isSingleValue()) {
            return this.processSV(this.getValuesSV(blockValueSet), 0, numDocs);
        }
        return this.processMV(this.getValuesMV(blockValueSet), 0, numDocs);
    }

    protected abstract S getValuesSV(BlockValSet var1);

    protected abstract M getValuesMV(BlockValSet var1);

    protected abstract boolean processSV(S var1, int var2, int var3);

    protected abstract boolean processMV(M var1, int var2, int var3);

    @Override
    public DistinctTable getResult() {
        return this._distinctTable;
    }
}

