/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.query.distinct.DistinctExecutor;
import org.apache.pinot.core.query.distinct.dictionary.DictionaryBasedMultiColumnDistinctExecutor;
import org.apache.pinot.core.query.distinct.dictionary.DictionaryBasedSingleColumnDistinctExecutor;
import org.apache.pinot.core.query.distinct.raw.BigDecimalDistinctExecutor;
import org.apache.pinot.core.query.distinct.raw.BytesDistinctExecutor;
import org.apache.pinot.core.query.distinct.raw.DoubleDistinctExecutor;
import org.apache.pinot.core.query.distinct.raw.FloatDistinctExecutor;
import org.apache.pinot.core.query.distinct.raw.IntDistinctExecutor;
import org.apache.pinot.core.query.distinct.raw.LongDistinctExecutor;
import org.apache.pinot.core.query.distinct.raw.RawMultiColumnDistinctExecutor;
import org.apache.pinot.core.query.distinct.raw.StringDistinctExecutor;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class DistinctExecutorFactory {
    private DistinctExecutorFactory() {
    }

    public static DistinctExecutor getDistinctExecutor(BaseProjectOperator<?> projectOperator, QueryContext queryContext) {
        List<ExpressionContext> expressions = queryContext.getSelectExpressions();
        int limit = queryContext.getLimit();
        boolean nullHandlingEnabled = queryContext.isNullHandlingEnabled();
        List<OrderByExpressionContext> orderByExpressions = queryContext.getOrderByExpressions();
        int numExpressions = expressions.size();
        if (numExpressions == 1) {
            Dictionary dictionary;
            OrderByExpressionContext orderByExpression;
            ExpressionContext expression = expressions.get(0);
            ColumnContext columnContext = projectOperator.getResultColumnContext(expression);
            FieldSpec.DataType dataType = columnContext.getDataType();
            if (orderByExpressions != null) {
                assert (orderByExpressions.size() == 1);
                orderByExpression = orderByExpressions.get(0);
                assert (orderByExpression.getExpression().equals((Object)expression));
            } else {
                orderByExpression = null;
            }
            if ((dictionary = columnContext.getDictionary()) != null && (orderByExpression == null || dictionary.isSorted())) {
                return new DictionaryBasedSingleColumnDistinctExecutor(expression, dictionary, dataType, limit, nullHandlingEnabled, orderByExpression);
            }
            switch (dataType.getStoredType()) {
                case INT: {
                    return new IntDistinctExecutor(expression, dataType, limit, nullHandlingEnabled, orderByExpression);
                }
                case LONG: {
                    return new LongDistinctExecutor(expression, dataType, limit, nullHandlingEnabled, orderByExpression);
                }
                case FLOAT: {
                    return new FloatDistinctExecutor(expression, dataType, limit, nullHandlingEnabled, orderByExpression);
                }
                case DOUBLE: {
                    return new DoubleDistinctExecutor(expression, dataType, limit, nullHandlingEnabled, orderByExpression);
                }
                case BIG_DECIMAL: {
                    return new BigDecimalDistinctExecutor(expression, dataType, limit, nullHandlingEnabled, orderByExpression);
                }
                case STRING: {
                    return new StringDistinctExecutor(expression, dataType, limit, nullHandlingEnabled, orderByExpression);
                }
                case BYTES: {
                    return new BytesDistinctExecutor(expression, dataType, limit, nullHandlingEnabled, orderByExpression);
                }
            }
            throw new IllegalStateException("Unsupported data type: " + dataType);
        }
        boolean hasMVExpression = false;
        Object[] columnNames = new String[numExpressions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numExpressions];
        ArrayList<Dictionary> dictionaries = new ArrayList<Dictionary>(numExpressions);
        boolean dictionaryBased = true;
        for (int i = 0; i < numExpressions; ++i) {
            ExpressionContext expression = expressions.get(i);
            ColumnContext columnContext = projectOperator.getResultColumnContext(expression);
            if (!columnContext.isSingleValue()) {
                hasMVExpression = true;
            }
            columnNames[i] = expression.toString();
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)columnContext.getDataType());
            if (!dictionaryBased) continue;
            Dictionary dictionary = columnContext.getDictionary();
            if (dictionary != null) {
                dictionaries.add(dictionary);
                continue;
            }
            dictionaryBased = false;
        }
        DataSchema dataSchema = new DataSchema((String[])columnNames, columnDataTypes);
        if (dictionaryBased && orderByExpressions != null) {
            for (OrderByExpressionContext orderByExpression : orderByExpressions) {
                int index = ArrayUtils.indexOf((Object[])columnNames, (Object)orderByExpression.getExpression().toString());
                assert (index >= 0);
                if (((Dictionary)dictionaries.get(index)).isSorted()) continue;
                dictionaryBased = false;
                break;
            }
        }
        if (dictionaryBased) {
            return new DictionaryBasedMultiColumnDistinctExecutor(expressions, hasMVExpression, dataSchema, dictionaries, limit, nullHandlingEnabled, orderByExpressions);
        }
        return new RawMultiColumnDistinctExecutor(expressions, hasMVExpression, dataSchema, limit, nullHandlingEnabled, orderByExpressions);
    }
}

