/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.dictionary;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.query.distinct.DistinctExecutor;
import org.apache.pinot.core.query.distinct.DistinctExecutorUtils;
import org.apache.pinot.core.query.distinct.table.DistinctTable;
import org.apache.pinot.core.query.distinct.table.MultiColumnDistinctTable;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.roaringbitmap.RoaringBitmap;

public class DictionaryBasedMultiColumnDistinctExecutor
implements DistinctExecutor {
    private final List<ExpressionContext> _expressions;
    private final boolean _hasMVExpression;
    private final DataSchema _dataSchema;
    private final List<Dictionary> _dictionaries;
    private final int _limit;
    private final boolean _nullHandlingEnabled;
    private final int[] _nullDictIds;
    private final List<OrderByExpressionContext> _orderByExpressions;
    private final int[] _orderByExpressionIndices;
    private final int[] _comparisonFactors;
    private final HashSet<DictIds> _dictIdsSet;
    private ObjectHeapPriorityQueue<DictIds> _priorityQueue;

    public DictionaryBasedMultiColumnDistinctExecutor(List<ExpressionContext> expressions, boolean hasMVExpression, DataSchema dataSchema, List<Dictionary> dictionaries, int limit, boolean nullHandlingEnabled, @Nullable List<OrderByExpressionContext> orderByExpressions) {
        this._expressions = expressions;
        this._hasMVExpression = hasMVExpression;
        this._dataSchema = dataSchema;
        this._dictionaries = dictionaries;
        this._limit = limit;
        this._nullHandlingEnabled = nullHandlingEnabled;
        if (nullHandlingEnabled) {
            this._nullDictIds = new int[this._expressions.size()];
            Arrays.fill(this._nullDictIds, -1);
        } else {
            this._nullDictIds = null;
        }
        this._orderByExpressions = orderByExpressions;
        if (orderByExpressions != null) {
            int numOrderByExpressions = orderByExpressions.size();
            this._orderByExpressionIndices = new int[numOrderByExpressions];
            this._comparisonFactors = new int[numOrderByExpressions];
            for (int i = 0; i < numOrderByExpressions; ++i) {
                int index;
                OrderByExpressionContext orderByExpression = orderByExpressions.get(i);
                this._orderByExpressionIndices[i] = index = expressions.indexOf(orderByExpression.getExpression());
                int n = this._comparisonFactors[i] = orderByExpression.isAsc() ? -1 : 1;
                if (!nullHandlingEnabled || orderByExpression.isAsc() != orderByExpression.isNullsLast()) continue;
                this._nullDictIds[index] = Integer.MAX_VALUE;
            }
        } else {
            this._orderByExpressionIndices = null;
            this._comparisonFactors = null;
        }
        this._dictIdsSet = Sets.newHashSetWithExpectedSize((int)Math.min(limit, 10000));
    }

    @Override
    public boolean process(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        int numExpressions = this._expressions.size();
        if (!this._hasMVExpression) {
            int i;
            int[][] dictIdsArray = new int[numDocs][numExpressions];
            for (i = 0; i < numExpressions; ++i) {
                BlockValSet blockValueSet = valueBlock.getBlockValueSet(this._expressions.get(i));
                int[] dictIdsForExpression = this.getDictIdsSV(blockValueSet, i);
                for (int j = 0; j < numDocs; ++j) {
                    dictIdsArray[j][i] = dictIdsForExpression[j];
                }
            }
            if (this._limit == Integer.MAX_VALUE) {
                for (i = 0; i < numDocs; ++i) {
                    this.addUnbounded(new DictIds(dictIdsArray[i]));
                }
            } else if (this._orderByExpressions == null) {
                for (i = 0; i < numDocs; ++i) {
                    if (!this.addWithoutOrderBy(new DictIds(dictIdsArray[i]))) continue;
                    return true;
                }
            } else {
                for (i = 0; i < numDocs; ++i) {
                    this.addWithOrderBy(new DictIds(dictIdsArray[i]));
                }
            }
        } else {
            int[][] dictIdsArray;
            int i;
            int[][] svDictIds = new int[numExpressions][];
            int[][][] mvDictIds = new int[numExpressions][][];
            for (i = 0; i < numExpressions; ++i) {
                BlockValSet blockValueSet = valueBlock.getBlockValueSet(this._expressions.get(i));
                if (blockValueSet.isSingleValue()) {
                    svDictIds[i] = this.getDictIdsSV(blockValueSet, i);
                    continue;
                }
                mvDictIds[i] = blockValueSet.getDictionaryIdsMV();
            }
            if (this._limit == Integer.MAX_VALUE) {
                for (i = 0; i < numDocs; ++i) {
                    for (int[] dictIds : dictIdsArray = DistinctExecutorUtils.getDictIds(svDictIds, mvDictIds, i)) {
                        this.addUnbounded(new DictIds(dictIds));
                    }
                }
            } else if (this._orderByExpressions == null) {
                for (i = 0; i < numDocs; ++i) {
                    for (int[] dictIds : dictIdsArray = DistinctExecutorUtils.getDictIds(svDictIds, mvDictIds, i)) {
                        if (!this.addWithoutOrderBy(new DictIds(dictIds))) continue;
                        return true;
                    }
                }
            } else {
                for (i = 0; i < numDocs; ++i) {
                    for (int[] dictIds : dictIdsArray = DistinctExecutorUtils.getDictIds(svDictIds, mvDictIds, i)) {
                        this.addWithOrderBy(new DictIds(dictIds));
                    }
                }
            }
        }
        return false;
    }

    private int[] getDictIdsSV(BlockValSet blockValueSet, int expressionIndex) {
        RoaringBitmap nullBitmap;
        int[] dictIds = blockValueSet.getDictionaryIdsSV();
        if (this._nullHandlingEnabled && (nullBitmap = blockValueSet.getNullBitmap()) != null && !nullBitmap.isEmpty()) {
            int nullDictId = this._nullDictIds[expressionIndex];
            nullBitmap.forEach(docId -> {
                dictIds[docId] = nullDictId;
            });
        }
        return dictIds;
    }

    private void addUnbounded(DictIds dictIds) {
        this._dictIdsSet.add(dictIds);
    }

    private boolean addWithoutOrderBy(DictIds dictIds) {
        assert (this._dictIdsSet.size() < this._limit);
        this._dictIdsSet.add(dictIds);
        return this._dictIdsSet.size() == this._limit;
    }

    private void addWithOrderBy(DictIds dictIds) {
        assert (this._dictIdsSet.size() <= this._limit);
        if (this._dictIdsSet.size() < this._limit) {
            this._dictIdsSet.add(dictIds);
            return;
        }
        if (this._dictIdsSet.contains(dictIds)) {
            return;
        }
        if (this._priorityQueue == null) {
            this._priorityQueue = new ObjectHeapPriorityQueue(this._dictIdsSet, this.getComparator());
        }
        DictIds firstDictIds = (DictIds)this._priorityQueue.first();
        if (this._priorityQueue.comparator().compare(dictIds, firstDictIds) > 0) {
            this._dictIdsSet.remove(firstDictIds);
            this._dictIdsSet.add(dictIds);
            this._priorityQueue.dequeue();
            this._priorityQueue.enqueue((Object)dictIds);
        }
    }

    private Comparator<DictIds> getComparator() {
        assert (this._orderByExpressionIndices != null && this._comparisonFactors != null);
        int numOrderByExpressions = this._orderByExpressionIndices.length;
        return (d1, d2) -> {
            int[] dictIds1 = d1._dictIds;
            int[] dictIds2 = d2._dictIds;
            for (int i = 0; i < numOrderByExpressions; ++i) {
                int index = this._orderByExpressionIndices[i];
                int result = dictIds1[index] - dictIds2[index];
                if (result == 0) continue;
                return result * this._comparisonFactors[i];
            }
            return 0;
        };
    }

    @Override
    public DistinctTable getResult() {
        MultiColumnDistinctTable distinctTable = new MultiColumnDistinctTable(this._dataSchema, this._limit, this._nullHandlingEnabled, this._orderByExpressions, this._dictIdsSet.size());
        int numExpressions = this._expressions.size();
        if (this._nullHandlingEnabled) {
            for (DictIds dictIds : this._dictIdsSet) {
                Object[] values = new Object[numExpressions];
                for (int i = 0; i < numExpressions; ++i) {
                    int dictId = dictIds._dictIds[i];
                    if (dictId == -1 || dictId == Integer.MAX_VALUE) continue;
                    values[i] = this._dictionaries.get(i).getInternal(dictId);
                }
                distinctTable.addUnbounded(new Record(values));
            }
        } else {
            for (DictIds dictIds : this._dictIdsSet) {
                Object[] values = new Object[numExpressions];
                for (int i = 0; i < numExpressions; ++i) {
                    values[i] = this._dictionaries.get(i).getInternal(dictIds._dictIds[i]);
                }
                distinctTable.addUnbounded(new Record(values));
            }
        }
        return distinctTable;
    }

    private static class DictIds {
        final int[] _dictIds;

        DictIds(int[] dictIds) {
            this._dictIds = dictIds;
        }

        public boolean equals(Object o) {
            return Arrays.equals(this._dictIds, ((DictIds)o)._dictIds);
        }

        public int hashCode() {
            return Arrays.hashCode(this._dictIds);
        }
    }
}

