/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.dictionary;

import it.unimi.dsi.fastutil.ints.IntIterator;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.distinct.BaseSingleColumnDistinctExecutor;
import org.apache.pinot.core.query.distinct.table.BigDecimalDistinctTable;
import org.apache.pinot.core.query.distinct.table.BytesDistinctTable;
import org.apache.pinot.core.query.distinct.table.DictIdDistinctTable;
import org.apache.pinot.core.query.distinct.table.DistinctTable;
import org.apache.pinot.core.query.distinct.table.DoubleDistinctTable;
import org.apache.pinot.core.query.distinct.table.FloatDistinctTable;
import org.apache.pinot.core.query.distinct.table.IntDistinctTable;
import org.apache.pinot.core.query.distinct.table.LongDistinctTable;
import org.apache.pinot.core.query.distinct.table.StringDistinctTable;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;

public class DictionaryBasedSingleColumnDistinctExecutor
extends BaseSingleColumnDistinctExecutor<DictIdDistinctTable, int[], int[][]> {
    private final Dictionary _dictionary;
    private final FieldSpec.DataType _dataType;

    public DictionaryBasedSingleColumnDistinctExecutor(ExpressionContext expression, Dictionary dictionary, FieldSpec.DataType dataType, int limit, boolean nullHandlingEnabled, @Nullable OrderByExpressionContext orderByExpression) {
        super(expression, new DictIdDistinctTable(new DataSchema(new String[]{expression.toString()}, new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)dataType)}), limit, nullHandlingEnabled, orderByExpression));
        this._dictionary = dictionary;
        this._dataType = dataType;
    }

    @Override
    protected int[] getValuesSV(BlockValSet blockValSet) {
        return blockValSet.getDictionaryIdsSV();
    }

    @Override
    protected int[][] getValuesMV(BlockValSet blockValSet) {
        return blockValSet.getDictionaryIdsMV();
    }

    @Override
    protected boolean processSV(int[] dictIds, int from, int to) {
        if (((DictIdDistinctTable)this._distinctTable).hasLimit()) {
            if (((DictIdDistinctTable)this._distinctTable).hasOrderBy()) {
                for (int i = from; i < to; ++i) {
                    ((DictIdDistinctTable)this._distinctTable).addWithOrderBy(dictIds[i]);
                }
            } else {
                for (int i = from; i < to; ++i) {
                    if (!((DictIdDistinctTable)this._distinctTable).addWithoutOrderBy(dictIds[i])) continue;
                    return true;
                }
            }
        } else {
            for (int i = from; i < to; ++i) {
                ((DictIdDistinctTable)this._distinctTable).addUnbounded(dictIds[i]);
            }
        }
        return false;
    }

    @Override
    protected boolean processMV(int[][] dictIds, int from, int to) {
        if (((DictIdDistinctTable)this._distinctTable).hasLimit()) {
            if (((DictIdDistinctTable)this._distinctTable).hasOrderBy()) {
                for (int i = from; i < to; ++i) {
                    for (int dictId : dictIds[i]) {
                        ((DictIdDistinctTable)this._distinctTable).addWithOrderBy(dictId);
                    }
                }
            } else {
                for (int i = from; i < to; ++i) {
                    for (int dictId : dictIds[i]) {
                        if (!((DictIdDistinctTable)this._distinctTable).addWithoutOrderBy(dictId)) continue;
                        return true;
                    }
                }
            }
        } else {
            for (int i = from; i < to; ++i) {
                for (int dictId : dictIds[i]) {
                    ((DictIdDistinctTable)this._distinctTable).addUnbounded(dictId);
                }
            }
        }
        return false;
    }

    @Override
    public DistinctTable getResult() {
        DataSchema dataSchema = ((DictIdDistinctTable)this._distinctTable).getDataSchema();
        int limit = ((DictIdDistinctTable)this._distinctTable).getLimit();
        boolean nullHandlingEnabled = ((DictIdDistinctTable)this._distinctTable).isNullHandlingEnabled();
        OrderByExpressionContext orderByExpression = ((DictIdDistinctTable)this._distinctTable).getOrderByExpression();
        IntIterator dictIdIterator = ((DictIdDistinctTable)this._distinctTable).getValueSet().iterator();
        boolean hasNull = ((DictIdDistinctTable)this._distinctTable).hasNull();
        switch (this._dictionary.getValueType()) {
            case INT: {
                IntDistinctTable distinctTable = new IntDistinctTable(dataSchema, limit, nullHandlingEnabled, orderByExpression);
                while (dictIdIterator.hasNext()) {
                    distinctTable.addUnbounded(this._dictionary.getIntValue(dictIdIterator.nextInt()));
                }
                if (hasNull) {
                    distinctTable.addNull();
                }
                return distinctTable;
            }
            case LONG: {
                LongDistinctTable distinctTable = new LongDistinctTable(dataSchema, limit, nullHandlingEnabled, orderByExpression);
                while (dictIdIterator.hasNext()) {
                    distinctTable.addUnbounded(this._dictionary.getLongValue(dictIdIterator.nextInt()));
                }
                if (hasNull) {
                    distinctTable.addNull();
                }
                return distinctTable;
            }
            case FLOAT: {
                FloatDistinctTable distinctTable = new FloatDistinctTable(dataSchema, limit, nullHandlingEnabled, orderByExpression);
                while (dictIdIterator.hasNext()) {
                    distinctTable.addUnbounded(this._dictionary.getFloatValue(dictIdIterator.nextInt()));
                }
                if (hasNull) {
                    distinctTable.addNull();
                }
                return distinctTable;
            }
            case DOUBLE: {
                DoubleDistinctTable distinctTable = new DoubleDistinctTable(dataSchema, limit, nullHandlingEnabled, orderByExpression);
                while (dictIdIterator.hasNext()) {
                    distinctTable.addUnbounded(this._dictionary.getDoubleValue(dictIdIterator.nextInt()));
                }
                if (hasNull) {
                    distinctTable.addNull();
                }
                return distinctTable;
            }
            case BIG_DECIMAL: {
                BigDecimalDistinctTable distinctTable = new BigDecimalDistinctTable(dataSchema, limit, nullHandlingEnabled, orderByExpression);
                while (dictIdIterator.hasNext()) {
                    distinctTable.addUnbounded(this._dictionary.getBigDecimalValue(dictIdIterator.nextInt()));
                }
                if (hasNull) {
                    distinctTable.addNull();
                }
                return distinctTable;
            }
            case STRING: {
                StringDistinctTable distinctTable = new StringDistinctTable(dataSchema, limit, nullHandlingEnabled, orderByExpression);
                while (dictIdIterator.hasNext()) {
                    distinctTable.addUnbounded(this._dictionary.getStringValue(dictIdIterator.nextInt()));
                }
                if (hasNull) {
                    distinctTable.addNull();
                }
                return distinctTable;
            }
            case BYTES: {
                BytesDistinctTable distinctTable = new BytesDistinctTable(dataSchema, limit, nullHandlingEnabled, orderByExpression);
                while (dictIdIterator.hasNext()) {
                    distinctTable.addUnbounded(new ByteArray(this._dictionary.getBytesValue(dictIdIterator.nextInt())));
                }
                if (hasNull) {
                    distinctTable.addNull();
                }
                return distinctTable;
            }
        }
        throw new IllegalStateException("Unsupported data type: " + this._dataType);
    }
}

