/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import java.math.BigDecimal;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.distinct.BaseSingleColumnDistinctExecutor;
import org.apache.pinot.core.query.distinct.table.BigDecimalDistinctTable;
import org.apache.pinot.spi.data.FieldSpec;

public class BigDecimalDistinctExecutor
extends BaseSingleColumnDistinctExecutor<BigDecimalDistinctTable, BigDecimal[], BigDecimal[][]> {
    public BigDecimalDistinctExecutor(ExpressionContext expression, FieldSpec.DataType dataType, int limit, boolean nullHandlingEnabled, @Nullable OrderByExpressionContext orderByExpression) {
        super(expression, new BigDecimalDistinctTable(new DataSchema(new String[]{expression.toString()}, new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)dataType)}), limit, nullHandlingEnabled, orderByExpression));
    }

    @Override
    protected BigDecimal[] getValuesSV(BlockValSet blockValSet) {
        return blockValSet.getBigDecimalValuesSV();
    }

    @Override
    protected BigDecimal[][] getValuesMV(BlockValSet blockValSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean processSV(BigDecimal[] values, int from, int to) {
        if (((BigDecimalDistinctTable)this._distinctTable).hasLimit()) {
            if (((BigDecimalDistinctTable)this._distinctTable).hasOrderBy()) {
                for (int i = from; i < to; ++i) {
                    ((BigDecimalDistinctTable)this._distinctTable).addWithOrderBy(values[i]);
                }
            } else {
                for (int i = from; i < to; ++i) {
                    if (!((BigDecimalDistinctTable)this._distinctTable).addWithoutOrderBy(values[i])) continue;
                    return true;
                }
            }
        } else {
            for (int i = from; i < to; ++i) {
                ((BigDecimalDistinctTable)this._distinctTable).addUnbounded(values[i]);
            }
        }
        return false;
    }

    @Override
    protected boolean processMV(BigDecimal[][] values, int from, int to) {
        throw new UnsupportedOperationException();
    }
}

