/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.distinct.BaseSingleColumnDistinctExecutor;
import org.apache.pinot.core.query.distinct.table.BytesDistinctTable;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;

public class BytesDistinctExecutor
extends BaseSingleColumnDistinctExecutor<BytesDistinctTable, byte[][], byte[][][]> {
    public BytesDistinctExecutor(ExpressionContext expression, FieldSpec.DataType dataType, int limit, boolean nullHandlingEnabled, @Nullable OrderByExpressionContext orderByExpression) {
        super(expression, new BytesDistinctTable(new DataSchema(new String[]{expression.toString()}, new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)dataType)}), limit, nullHandlingEnabled, orderByExpression));
    }

    @Override
    protected byte[][] getValuesSV(BlockValSet blockValSet) {
        return blockValSet.getBytesValuesSV();
    }

    @Override
    protected byte[][][] getValuesMV(BlockValSet blockValSet) {
        return blockValSet.getBytesValuesMV();
    }

    @Override
    protected boolean processSV(byte[][] values, int from, int to) {
        if (((BytesDistinctTable)this._distinctTable).hasLimit()) {
            if (((BytesDistinctTable)this._distinctTable).hasOrderBy()) {
                for (int i = from; i < to; ++i) {
                    ((BytesDistinctTable)this._distinctTable).addWithOrderBy(new ByteArray(values[i]));
                }
            } else {
                for (int i = from; i < to; ++i) {
                    if (!((BytesDistinctTable)this._distinctTable).addWithoutOrderBy(new ByteArray(values[i]))) continue;
                    return true;
                }
            }
        } else {
            for (int i = from; i < to; ++i) {
                ((BytesDistinctTable)this._distinctTable).addUnbounded(new ByteArray(values[i]));
            }
        }
        return false;
    }

    @Override
    protected boolean processMV(byte[][][] values, int from, int to) {
        if (((BytesDistinctTable)this._distinctTable).hasLimit()) {
            if (((BytesDistinctTable)this._distinctTable).hasOrderBy()) {
                for (int i = from; i < to; ++i) {
                    for (byte[] value : values[i]) {
                        ((BytesDistinctTable)this._distinctTable).addWithOrderBy(new ByteArray(value));
                    }
                }
            } else {
                for (int i = from; i < to; ++i) {
                    for (byte[] value : values[i]) {
                        if (!((BytesDistinctTable)this._distinctTable).addWithoutOrderBy(new ByteArray(value))) continue;
                        return true;
                    }
                }
            }
        } else {
            for (int i = from; i < to; ++i) {
                for (byte[] value : values[i]) {
                    ((BytesDistinctTable)this._distinctTable).addUnbounded(new ByteArray(value));
                }
            }
        }
        return false;
    }
}

