/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.distinct.BaseSingleColumnDistinctExecutor;
import org.apache.pinot.core.query.distinct.table.DoubleDistinctTable;
import org.apache.pinot.spi.data.FieldSpec;

public class DoubleDistinctExecutor
extends BaseSingleColumnDistinctExecutor<DoubleDistinctTable, double[], double[][]> {
    public DoubleDistinctExecutor(ExpressionContext expression, FieldSpec.DataType dataType, int limit, boolean nullHandlingEnabled, @Nullable OrderByExpressionContext orderByExpression) {
        super(expression, new DoubleDistinctTable(new DataSchema(new String[]{expression.toString()}, new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)dataType)}), limit, nullHandlingEnabled, orderByExpression));
    }

    @Override
    protected double[] getValuesSV(BlockValSet blockValSet) {
        return blockValSet.getDoubleValuesSV();
    }

    @Override
    protected double[][] getValuesMV(BlockValSet blockValSet) {
        return blockValSet.getDoubleValuesMV();
    }

    @Override
    protected boolean processSV(double[] values, int from, int to) {
        if (((DoubleDistinctTable)this._distinctTable).hasLimit()) {
            if (((DoubleDistinctTable)this._distinctTable).hasOrderBy()) {
                for (int i = from; i < to; ++i) {
                    ((DoubleDistinctTable)this._distinctTable).addWithOrderBy(values[i]);
                }
            } else {
                for (int i = from; i < to; ++i) {
                    if (!((DoubleDistinctTable)this._distinctTable).addWithoutOrderBy(values[i])) continue;
                    return true;
                }
            }
        } else {
            for (int i = from; i < to; ++i) {
                ((DoubleDistinctTable)this._distinctTable).addUnbounded(values[i]);
            }
        }
        return false;
    }

    @Override
    protected boolean processMV(double[][] values, int from, int to) {
        if (((DoubleDistinctTable)this._distinctTable).hasLimit()) {
            if (((DoubleDistinctTable)this._distinctTable).hasOrderBy()) {
                for (int i = from; i < to; ++i) {
                    for (double value : values[i]) {
                        ((DoubleDistinctTable)this._distinctTable).addWithOrderBy(value);
                    }
                }
            } else {
                for (int i = from; i < to; ++i) {
                    for (double value : values[i]) {
                        if (!((DoubleDistinctTable)this._distinctTable).addWithoutOrderBy(value)) continue;
                        return true;
                    }
                }
            }
        } else {
            for (int i = from; i < to; ++i) {
                for (double value : values[i]) {
                    ((DoubleDistinctTable)this._distinctTable).addUnbounded(value);
                }
            }
        }
        return false;
    }
}

