/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.distinct.BaseSingleColumnDistinctExecutor;
import org.apache.pinot.core.query.distinct.table.FloatDistinctTable;
import org.apache.pinot.spi.data.FieldSpec;

public class FloatDistinctExecutor
extends BaseSingleColumnDistinctExecutor<FloatDistinctTable, float[], float[][]> {
    public FloatDistinctExecutor(ExpressionContext expression, FieldSpec.DataType dataType, int limit, boolean nullHandlingEnabled, @Nullable OrderByExpressionContext orderByExpression) {
        super(expression, new FloatDistinctTable(new DataSchema(new String[]{expression.toString()}, new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)dataType)}), limit, nullHandlingEnabled, orderByExpression));
    }

    @Override
    protected float[] getValuesSV(BlockValSet blockValSet) {
        return blockValSet.getFloatValuesSV();
    }

    @Override
    protected float[][] getValuesMV(BlockValSet blockValSet) {
        return blockValSet.getFloatValuesMV();
    }

    @Override
    protected boolean processSV(float[] values, int from, int to) {
        if (((FloatDistinctTable)this._distinctTable).hasLimit()) {
            if (((FloatDistinctTable)this._distinctTable).hasOrderBy()) {
                for (int i = from; i < to; ++i) {
                    ((FloatDistinctTable)this._distinctTable).addWithOrderBy(values[i]);
                }
            } else {
                for (int i = from; i < to; ++i) {
                    if (!((FloatDistinctTable)this._distinctTable).addWithoutOrderBy(values[i])) continue;
                    return true;
                }
            }
        } else {
            for (int i = from; i < to; ++i) {
                ((FloatDistinctTable)this._distinctTable).addUnbounded(values[i]);
            }
        }
        return false;
    }

    @Override
    protected boolean processMV(float[][] values, int from, int to) {
        if (((FloatDistinctTable)this._distinctTable).hasLimit()) {
            if (((FloatDistinctTable)this._distinctTable).hasOrderBy()) {
                for (int i = from; i < to; ++i) {
                    for (float value : values[i]) {
                        ((FloatDistinctTable)this._distinctTable).addWithOrderBy(value);
                    }
                }
            } else {
                for (int i = from; i < to; ++i) {
                    for (float value : values[i]) {
                        if (!((FloatDistinctTable)this._distinctTable).addWithoutOrderBy(value)) continue;
                        return true;
                    }
                }
            }
        } else {
            for (int i = from; i < to; ++i) {
                for (float value : values[i]) {
                    ((FloatDistinctTable)this._distinctTable).addUnbounded(value);
                }
            }
        }
        return false;
    }
}

