/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.distinct.BaseSingleColumnDistinctExecutor;
import org.apache.pinot.core.query.distinct.table.IntDistinctTable;
import org.apache.pinot.spi.data.FieldSpec;

public class IntDistinctExecutor
extends BaseSingleColumnDistinctExecutor<IntDistinctTable, int[], int[][]> {
    public IntDistinctExecutor(ExpressionContext expression, FieldSpec.DataType dataType, int limit, boolean nullHandlingEnabled, @Nullable OrderByExpressionContext orderByExpression) {
        super(expression, new IntDistinctTable(new DataSchema(new String[]{expression.toString()}, new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)dataType)}), limit, nullHandlingEnabled, orderByExpression));
    }

    @Override
    protected int[] getValuesSV(BlockValSet blockValSet) {
        return blockValSet.getIntValuesSV();
    }

    @Override
    protected int[][] getValuesMV(BlockValSet blockValSet) {
        return blockValSet.getIntValuesMV();
    }

    @Override
    protected boolean processSV(int[] values, int from, int to) {
        if (((IntDistinctTable)this._distinctTable).hasLimit()) {
            if (((IntDistinctTable)this._distinctTable).hasOrderBy()) {
                for (int i = from; i < to; ++i) {
                    ((IntDistinctTable)this._distinctTable).addWithOrderBy(values[i]);
                }
            } else {
                for (int i = from; i < to; ++i) {
                    if (!((IntDistinctTable)this._distinctTable).addWithoutOrderBy(values[i])) continue;
                    return true;
                }
            }
        } else {
            for (int i = from; i < to; ++i) {
                ((IntDistinctTable)this._distinctTable).addUnbounded(values[i]);
            }
        }
        return false;
    }

    @Override
    protected boolean processMV(int[][] values, int from, int to) {
        if (((IntDistinctTable)this._distinctTable).hasLimit()) {
            if (((IntDistinctTable)this._distinctTable).hasOrderBy()) {
                for (int i = from; i < to; ++i) {
                    for (int value : values[i]) {
                        ((IntDistinctTable)this._distinctTable).addWithOrderBy(value);
                    }
                }
            } else {
                for (int i = from; i < to; ++i) {
                    for (int value : values[i]) {
                        if (!((IntDistinctTable)this._distinctTable).addWithoutOrderBy(value)) continue;
                        return true;
                    }
                }
            }
        } else {
            for (int i = from; i < to; ++i) {
                for (int value : values[i]) {
                    ((IntDistinctTable)this._distinctTable).addUnbounded(value);
                }
            }
        }
        return false;
    }
}

