/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.distinct.BaseSingleColumnDistinctExecutor;
import org.apache.pinot.core.query.distinct.table.LongDistinctTable;
import org.apache.pinot.spi.data.FieldSpec;

public class LongDistinctExecutor
extends BaseSingleColumnDistinctExecutor<LongDistinctTable, long[], long[][]> {
    public LongDistinctExecutor(ExpressionContext expression, FieldSpec.DataType dataType, int limit, boolean nullHandlingEnabled, @Nullable OrderByExpressionContext orderByExpression) {
        super(expression, new LongDistinctTable(new DataSchema(new String[]{expression.toString()}, new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)dataType)}), limit, nullHandlingEnabled, orderByExpression));
    }

    @Override
    protected long[] getValuesSV(BlockValSet blockValSet) {
        return blockValSet.getLongValuesSV();
    }

    @Override
    protected long[][] getValuesMV(BlockValSet blockValSet) {
        return blockValSet.getLongValuesMV();
    }

    @Override
    protected boolean processSV(long[] values, int from, int to) {
        if (((LongDistinctTable)this._distinctTable).hasLimit()) {
            if (((LongDistinctTable)this._distinctTable).hasOrderBy()) {
                for (int i = from; i < to; ++i) {
                    ((LongDistinctTable)this._distinctTable).addWithOrderBy(values[i]);
                }
            } else {
                for (int i = from; i < to; ++i) {
                    if (!((LongDistinctTable)this._distinctTable).addWithoutOrderBy(values[i])) continue;
                    return true;
                }
            }
        } else {
            for (int i = from; i < to; ++i) {
                ((LongDistinctTable)this._distinctTable).addUnbounded(values[i]);
            }
        }
        return false;
    }

    @Override
    protected boolean processMV(long[][] values, int from, int to) {
        if (((LongDistinctTable)this._distinctTable).hasLimit()) {
            if (((LongDistinctTable)this._distinctTable).hasOrderBy()) {
                for (int i = from; i < to; ++i) {
                    for (long value : values[i]) {
                        ((LongDistinctTable)this._distinctTable).addWithOrderBy(value);
                    }
                }
            } else {
                for (int i = from; i < to; ++i) {
                    for (long value : values[i]) {
                        if (!((LongDistinctTable)this._distinctTable).addWithoutOrderBy(value)) continue;
                        return true;
                    }
                }
            }
        } else {
            for (int i = from; i < to; ++i) {
                for (long value : values[i]) {
                    ((LongDistinctTable)this._distinctTable).addUnbounded(value);
                }
            }
        }
        return false;
    }
}

