/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.RowBasedBlockValueFetcher;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.query.distinct.DistinctExecutor;
import org.apache.pinot.core.query.distinct.DistinctExecutorUtils;
import org.apache.pinot.core.query.distinct.table.DistinctTable;
import org.apache.pinot.core.query.distinct.table.MultiColumnDistinctTable;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.RoaringBitmap;

public class RawMultiColumnDistinctExecutor
implements DistinctExecutor {
    private final List<ExpressionContext> _expressions;
    private final boolean _hasMVExpression;
    private final boolean _nullHandlingEnabled;
    private final MultiColumnDistinctTable _distinctTable;

    public RawMultiColumnDistinctExecutor(List<ExpressionContext> expressions, boolean hasMVExpression, DataSchema dataSchema, int limit, boolean nullHandlingEnabled, @Nullable List<OrderByExpressionContext> orderByExpressions) {
        this._expressions = expressions;
        this._hasMVExpression = hasMVExpression;
        this._nullHandlingEnabled = nullHandlingEnabled;
        this._distinctTable = new MultiColumnDistinctTable(dataSchema, limit, nullHandlingEnabled, orderByExpressions);
    }

    @Override
    public boolean process(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        int numExpressions = this._expressions.size();
        if (!this._hasMVExpression) {
            BlockValSet[] blockValSets = new BlockValSet[numExpressions];
            for (int i = 0; i < numExpressions; ++i) {
                blockValSets[i] = valueBlock.getBlockValueSet(this._expressions.get(i));
            }
            RoaringBitmap[] nullBitmaps = new RoaringBitmap[numExpressions];
            boolean hasNullValue = false;
            if (this._nullHandlingEnabled) {
                for (int i = 0; i < numExpressions; ++i) {
                    RoaringBitmap nullBitmap = blockValSets[i].getNullBitmap();
                    if (nullBitmap == null || nullBitmap.isEmpty()) continue;
                    nullBitmaps[i] = nullBitmap;
                    hasNullValue = true;
                }
            }
            RowBasedBlockValueFetcher valueFetcher = new RowBasedBlockValueFetcher(blockValSets);
            if (hasNullValue) {
                int i;
                Object[][] values = new Object[numDocs][];
                for (i = 0; i < numDocs; ++i) {
                    values[i] = valueFetcher.getRow(i);
                }
                for (i = 0; i < numExpressions; ++i) {
                    RoaringBitmap nullBitmap = nullBitmaps[i];
                    if (nullBitmap == null || nullBitmap.isEmpty()) continue;
                    int finalI = i;
                    nullBitmap.forEach(j -> {
                        values[j][finalI] = null;
                    });
                }
                for (i = 0; i < numDocs; ++i) {
                    Record record = new Record(values[i]);
                    if (this._distinctTable.hasOrderBy()) {
                        this._distinctTable.addWithOrderBy(record);
                        continue;
                    }
                    if (!this._distinctTable.addWithoutOrderBy(record)) continue;
                    return true;
                }
            } else {
                for (int i = 0; i < numDocs; ++i) {
                    Record record = new Record(valueFetcher.getRow(i));
                    if (this._distinctTable.hasOrderBy()) {
                        this._distinctTable.addWithOrderBy(record);
                        continue;
                    }
                    if (!this._distinctTable.addWithoutOrderBy(record)) continue;
                    return true;
                }
            }
        } else {
            int i;
            Object[][] svValues = new Object[numExpressions][];
            Object[][][] mvValues = new Object[numExpressions][][];
            for (i = 0; i < numExpressions; ++i) {
                BlockValSet blockValueSet = valueBlock.getBlockValueSet(this._expressions.get(i));
                if (blockValueSet.isSingleValue()) {
                    svValues[i] = this.getSVValues(blockValueSet, numDocs);
                    continue;
                }
                mvValues[i] = this.getMVValues(blockValueSet, numDocs);
            }
            for (i = 0; i < numDocs; ++i) {
                Object[][] records;
                for (Object[] record : records = DistinctExecutorUtils.getRecords(svValues, mvValues, i)) {
                    if (this._distinctTable.hasOrderBy()) {
                        this._distinctTable.addWithOrderBy(new Record(record));
                        continue;
                    }
                    if (!this._distinctTable.addWithoutOrderBy(new Record(record))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Object[] getSVValues(BlockValSet blockValueSet, int numDocs) {
        RoaringBitmap nullBitmap;
        Object[] values;
        FieldSpec.DataType valueType = blockValueSet.getValueType();
        switch (valueType.getStoredType()) {
            case INT: {
                int[] intValues = blockValueSet.getIntValuesSV();
                values = new Object[numDocs];
                for (int i2 = 0; i2 < numDocs; ++i2) {
                    values[i2] = intValues[i2];
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValueSet.getLongValuesSV();
                values = new Object[numDocs];
                for (int i3 = 0; i3 < numDocs; ++i3) {
                    values[i3] = longValues[i3];
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValueSet.getFloatValuesSV();
                values = new Object[numDocs];
                for (int i4 = 0; i4 < numDocs; ++i4) {
                    values[i4] = Float.valueOf(floatValues[i4]);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValueSet.getDoubleValuesSV();
                values = new Object[numDocs];
                for (int i5 = 0; i5 < numDocs; ++i5) {
                    values[i5] = doubleValues[i5];
                }
                break;
            }
            case BIG_DECIMAL: {
                BigDecimal[] bigDecimalValues = blockValueSet.getBigDecimalValuesSV();
                values = bigDecimalValues.length == numDocs ? bigDecimalValues : Arrays.copyOf(bigDecimalValues, numDocs);
                break;
            }
            case STRING: {
                String[] stringValues = blockValueSet.getStringValuesSV();
                values = stringValues.length == numDocs ? stringValues : Arrays.copyOf(stringValues, numDocs);
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValueSet.getBytesValuesSV();
                values = new Object[numDocs];
                for (int i6 = 0; i6 < numDocs; ++i6) {
                    values[i6] = new ByteArray(bytesValues[i6]);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported value type: " + valueType + " for single-value column");
            }
        }
        if (this._nullHandlingEnabled && (nullBitmap = blockValueSet.getNullBitmap()) != null && !nullBitmap.isEmpty()) {
            nullBitmap.forEach(i -> {
                values[i] = null;
            });
        }
        return values;
    }

    private Object[][] getMVValues(BlockValSet blockValueSet, int numDocs) {
        Object[][] values;
        FieldSpec.DataType valueType = blockValueSet.getValueType();
        switch (valueType.getStoredType()) {
            case INT: {
                int[][] intValues = blockValueSet.getIntValuesMV();
                values = new Object[numDocs][];
                for (int i = 0; i < numDocs; ++i) {
                    values[i] = ArrayUtils.toObject((int[])intValues[i]);
                }
                break;
            }
            case LONG: {
                long[][] longValues = blockValueSet.getLongValuesMV();
                values = new Object[numDocs][];
                for (int i = 0; i < numDocs; ++i) {
                    values[i] = ArrayUtils.toObject((long[])longValues[i]);
                }
                break;
            }
            case FLOAT: {
                float[][] floatValues = blockValueSet.getFloatValuesMV();
                values = new Object[numDocs][];
                for (int i = 0; i < numDocs; ++i) {
                    values[i] = ArrayUtils.toObject((float[])floatValues[i]);
                }
                break;
            }
            case DOUBLE: {
                double[][] doubleValues = blockValueSet.getDoubleValuesMV();
                values = new Object[numDocs][];
                for (int i = 0; i < numDocs; ++i) {
                    values[i] = ArrayUtils.toObject((double[])doubleValues[i]);
                }
                break;
            }
            case STRING: {
                String[][] stringValues = blockValueSet.getStringValuesMV();
                values = stringValues.length == numDocs ? stringValues : (Object[][])Arrays.copyOf(stringValues, numDocs);
                break;
            }
            case BYTES: {
                byte[][][] bytesValuesMV = blockValueSet.getBytesValuesMV();
                values = new Object[numDocs][];
                for (int i = 0; i < numDocs; ++i) {
                    byte[][] bytesValues = bytesValuesMV[i];
                    values[i] = new Object[bytesValues.length];
                    for (int j = 0; j < bytesValues.length; ++j) {
                        values[i][j] = new ByteArray(bytesValues[j]);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported value type: " + valueType + " for multi-value column");
            }
        }
        return values;
    }

    @Override
    public DistinctTable getResult() {
        return this._distinctTable;
    }
}

