/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.distinct.BaseSingleColumnDistinctExecutor;
import org.apache.pinot.core.query.distinct.table.StringDistinctTable;
import org.apache.pinot.spi.data.FieldSpec;

public class StringDistinctExecutor
extends BaseSingleColumnDistinctExecutor<StringDistinctTable, String[], String[][]> {
    public StringDistinctExecutor(ExpressionContext expression, FieldSpec.DataType dataType, int limit, boolean nullHandlingEnabled, @Nullable OrderByExpressionContext orderByExpression) {
        super(expression, new StringDistinctTable(new DataSchema(new String[]{expression.toString()}, new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)dataType)}), limit, nullHandlingEnabled, orderByExpression));
    }

    @Override
    protected String[] getValuesSV(BlockValSet blockValSet) {
        return blockValSet.getStringValuesSV();
    }

    @Override
    protected String[][] getValuesMV(BlockValSet blockValSet) {
        return blockValSet.getStringValuesMV();
    }

    @Override
    protected boolean processSV(String[] values, int from, int to) {
        if (((StringDistinctTable)this._distinctTable).hasLimit()) {
            if (((StringDistinctTable)this._distinctTable).hasOrderBy()) {
                for (int i = from; i < to; ++i) {
                    ((StringDistinctTable)this._distinctTable).addWithOrderBy(values[i]);
                }
            } else {
                for (int i = from; i < to; ++i) {
                    if (!((StringDistinctTable)this._distinctTable).addWithoutOrderBy(values[i])) continue;
                    return true;
                }
            }
        } else {
            for (int i = from; i < to; ++i) {
                ((StringDistinctTable)this._distinctTable).addUnbounded(values[i]);
            }
        }
        return false;
    }

    @Override
    protected boolean processMV(String[][] values, int from, int to) {
        if (((StringDistinctTable)this._distinctTable).hasLimit()) {
            if (((StringDistinctTable)this._distinctTable).hasOrderBy()) {
                for (int i = from; i < to; ++i) {
                    for (String value : values[i]) {
                        ((StringDistinctTable)this._distinctTable).addWithOrderBy(value);
                    }
                }
            } else {
                for (int i = from; i < to; ++i) {
                    for (String value : values[i]) {
                        if (!((StringDistinctTable)this._distinctTable).addWithoutOrderBy(value)) continue;
                        return true;
                    }
                }
            }
        } else {
            for (int i = from; i < to; ++i) {
                for (String value : values[i]) {
                    ((StringDistinctTable)this._distinctTable).addUnbounded(value);
                }
            }
        }
        return false;
    }
}

