/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.table;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.common.datatable.DataTableBuilderFactory;
import org.apache.pinot.core.query.distinct.table.DistinctTable;
import org.apache.pinot.spi.trace.Tracing;
import org.apache.pinot.spi.utils.CommonConstants;
import org.roaringbitmap.RoaringBitmap;

public class BigDecimalDistinctTable
extends DistinctTable {
    private final HashSet<BigDecimal> _valueSet;
    private final OrderByExpressionContext _orderByExpression;
    private ObjectHeapPriorityQueue<BigDecimal> _priorityQueue;

    public BigDecimalDistinctTable(DataSchema dataSchema, int limit, boolean nullHandlingEnabled, @Nullable OrderByExpressionContext orderByExpression) {
        super(dataSchema, limit, nullHandlingEnabled);
        this._valueSet = Sets.newHashSetWithExpectedSize((int)Math.min(limit, 10000));
        this._orderByExpression = orderByExpression;
    }

    public BigDecimalDistinctTable(DataSchema dataSchema, int limit, boolean nullHandlingEnabled, @Nullable OrderByExpressionContext orderByExpression, DataTable dataTable) {
        super(dataSchema, limit, nullHandlingEnabled);
        RoaringBitmap nullRowIds;
        int numRows = dataTable.getNumberOfRows();
        this._valueSet = Sets.newHashSetWithExpectedSize((int)numRows);
        this._orderByExpression = orderByExpression;
        RoaringBitmap roaringBitmap = nullRowIds = nullHandlingEnabled ? dataTable.getNullRowIds(0) : null;
        if (nullRowIds == null) {
            for (int i = 0; i < numRows; ++i) {
                this._valueSet.add(dataTable.getBigDecimal(i, 0));
            }
        } else {
            assert (nullRowIds.getCardinality() == 1);
            this.addNull();
            int nullRowId = nullRowIds.first();
            if (nullRowId == 0) {
                for (int i = 1; i < numRows; ++i) {
                    this._valueSet.add(dataTable.getBigDecimal(i, 0));
                }
            } else {
                int i;
                for (i = 0; i < nullRowId; ++i) {
                    this._valueSet.add(dataTable.getBigDecimal(i, 0));
                }
                for (i = nullRowId + 1; i < numRows; ++i) {
                    this._valueSet.add(dataTable.getBigDecimal(i, 0));
                }
            }
        }
        assert (this._valueSet.size() <= limit);
    }

    @Override
    public boolean hasOrderBy() {
        return this._orderByExpression != null;
    }

    public boolean addWithoutOrderBy(BigDecimal value) {
        assert (this._valueSet.size() < this._limit);
        this._valueSet.add(value);
        return this._valueSet.size() >= this._limitWithoutNull;
    }

    public void addWithOrderBy(BigDecimal value) {
        assert (this._valueSet.size() <= this._limit);
        if (this._valueSet.size() < this._limit) {
            this._valueSet.add(value);
            return;
        }
        if (this._valueSet.contains(value)) {
            return;
        }
        if (this._priorityQueue == null) {
            Comparator comparator = this._orderByExpression.isAsc() ? Comparator.reverseOrder() : Comparator.naturalOrder();
            this._priorityQueue = new ObjectHeapPriorityQueue(this._valueSet, comparator);
        }
        BigDecimal firstValue = (BigDecimal)this._priorityQueue.first();
        if (this._priorityQueue.comparator().compare(value, firstValue) > 0) {
            this._valueSet.remove(firstValue);
            this._valueSet.add(value);
            this._priorityQueue.dequeue();
            this._priorityQueue.enqueue((Object)value);
        }
    }

    public void addUnbounded(BigDecimal value) {
        this._valueSet.add(value);
    }

    @Override
    public void mergeDistinctTable(DistinctTable distinctTable) {
        BigDecimalDistinctTable bigDecimalDistinctTable = (BigDecimalDistinctTable)distinctTable;
        if (bigDecimalDistinctTable._hasNull) {
            this.addNull();
        }
        if (this.hasLimit()) {
            if (this.hasOrderBy()) {
                for (BigDecimal value : bigDecimalDistinctTable._valueSet) {
                    this.addWithOrderBy(value);
                }
            } else {
                for (BigDecimal value : bigDecimalDistinctTable._valueSet) {
                    if (!this.addWithoutOrderBy(value)) continue;
                    return;
                }
            }
        } else {
            for (BigDecimal value : bigDecimalDistinctTable._valueSet) {
                this.addUnbounded(value);
            }
        }
    }

    @Override
    public boolean mergeDataTable(DataTable dataTable) {
        RoaringBitmap nullRowIds;
        int numRows = dataTable.getNumberOfRows();
        RoaringBitmap roaringBitmap = nullRowIds = this._nullHandlingEnabled ? dataTable.getNullRowIds(0) : null;
        if (nullRowIds == null) {
            return this.addValues(dataTable, 0, numRows);
        }
        assert (nullRowIds.getCardinality() == 1);
        this.addNull();
        int nullRowId = nullRowIds.first();
        if (nullRowId == 0) {
            return this.addValues(dataTable, 1, numRows);
        }
        return this.addValues(dataTable, 0, nullRowId) || this.addValues(dataTable, nullRowId + 1, numRows);
    }

    private boolean addValues(DataTable dataTable, int from, int to) {
        if (this.hasLimit()) {
            if (this.hasOrderBy()) {
                for (int i = from; i < to; ++i) {
                    this.addWithOrderBy(dataTable.getBigDecimal(i, 0));
                }
            } else {
                for (int i = from; i < to; ++i) {
                    if (!this.addWithoutOrderBy(dataTable.getBigDecimal(i, 0))) continue;
                    return true;
                }
            }
        } else {
            for (int i = from; i < to; ++i) {
                this.addUnbounded(dataTable.getBigDecimal(i, 0));
            }
        }
        return false;
    }

    @Override
    public int size() {
        int numValues = this._valueSet.size();
        return this._hasNull ? numValues + 1 : numValues;
    }

    @Override
    public boolean isSatisfied() {
        return this._orderByExpression == null && this._valueSet.size() >= this._limitWithoutNull;
    }

    @Override
    public List<Object[]> getRows() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(this.size());
        if (this._hasNull) {
            rows.add(new Object[]{null});
        }
        for (BigDecimal value : this._valueSet) {
            rows.add(new Object[]{value});
        }
        return rows;
    }

    @Override
    public DataTable toDataTable() throws IOException {
        DataTableBuilder dataTableBuilder = DataTableBuilderFactory.getDataTableBuilder(this._dataSchema);
        if (this._hasNull) {
            dataTableBuilder.startRow();
            dataTableBuilder.setColumn(0, CommonConstants.NullValuePlaceHolder.BIG_DECIMAL);
            dataTableBuilder.finishRow();
        }
        int numRowsAdded = 0;
        for (BigDecimal value : this._valueSet) {
            Tracing.ThreadAccountantOps.sampleAndCheckInterruptionPeriodically((int)numRowsAdded);
            dataTableBuilder.startRow();
            dataTableBuilder.setColumn(0, value);
            dataTableBuilder.finishRow();
            ++numRowsAdded;
        }
        if (this._hasNull) {
            RoaringBitmap nullBitmap = new RoaringBitmap();
            nullBitmap.add(0);
            dataTableBuilder.setNullRowIds(nullBitmap);
        }
        return dataTableBuilder.build();
    }

    @Override
    public ResultTable toResultTable() {
        return this.hasOrderBy() ? this.toResultTableWithOrderBy() : this.toResultTableWithoutOrderBy();
    }

    private ResultTable toResultTableWithOrderBy() {
        ArrayList<Object> rows;
        Object[] sortedValues;
        int numValues;
        if (this._priorityQueue != null) {
            numValues = this._priorityQueue.size();
            sortedValues = new BigDecimal[numValues];
            for (int i = numValues - 1; i >= 0; --i) {
                sortedValues[i] = (BigDecimal)this._priorityQueue.dequeue();
            }
        } else {
            sortedValues = this._valueSet.toArray(new BigDecimal[0]);
            Arrays.sort(sortedValues);
            if (!this._orderByExpression.isAsc()) {
                ArrayUtils.reverse((Object[])sortedValues);
            }
        }
        numValues = sortedValues.length;
        assert (numValues <= this._limit);
        if (this._hasNull) {
            if (numValues == this._limit) {
                rows = new ArrayList(this._limit);
                if (this._orderByExpression.isNullsLast()) {
                    BigDecimalDistinctTable.addRows((BigDecimal[])sortedValues, numValues, rows);
                } else {
                    rows.add(new Object[]{null});
                    BigDecimalDistinctTable.addRows((BigDecimal[])sortedValues, numValues - 1, rows);
                }
            } else {
                rows = new ArrayList(numValues + 1);
                if (this._orderByExpression.isNullsLast()) {
                    BigDecimalDistinctTable.addRows((BigDecimal[])sortedValues, numValues, rows);
                    rows.add(new Object[]{null});
                } else {
                    rows.add(new Object[]{null});
                    BigDecimalDistinctTable.addRows((BigDecimal[])sortedValues, numValues, rows);
                }
            }
        } else {
            rows = new ArrayList<Object[]>(numValues);
            BigDecimalDistinctTable.addRows((BigDecimal[])sortedValues, numValues, rows);
        }
        return new ResultTable(this._dataSchema, rows);
    }

    private static void addRows(BigDecimal[] values, int length, List<Object[]> rows) {
        for (int i = 0; i < length; ++i) {
            rows.add(new Object[]{values[i].toPlainString()});
        }
    }

    private ResultTable toResultTableWithoutOrderBy() {
        ArrayList<Object> rows;
        int numValues = this._valueSet.size();
        assert (numValues <= this._limit);
        if (this._hasNull && numValues < this._limit) {
            rows = new ArrayList(numValues + 1);
            BigDecimalDistinctTable.addRows(this._valueSet, rows);
            rows.add(new Object[]{null});
        } else {
            rows = new ArrayList<Object[]>(numValues);
            BigDecimalDistinctTable.addRows(this._valueSet, rows);
        }
        return new ResultTable(this._dataSchema, rows);
    }

    private static void addRows(HashSet<BigDecimal> values, List<Object[]> rows) {
        for (BigDecimal value : values) {
            rows.add(new Object[]{value.toPlainString()});
        }
    }
}

