/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.table;

import java.io.IOException;
import java.util.List;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;

public abstract class DistinctTable {
    public static final int MAX_INITIAL_CAPACITY = 10000;
    protected final DataSchema _dataSchema;
    protected final int _limit;
    protected final boolean _nullHandlingEnabled;
    protected boolean _hasNull;
    protected int _limitWithoutNull;

    public DistinctTable(DataSchema dataSchema, int limit, boolean nullHandlingEnabled) {
        this._dataSchema = dataSchema;
        this._limit = limit;
        this._nullHandlingEnabled = nullHandlingEnabled;
        this._limitWithoutNull = limit;
    }

    public DataSchema getDataSchema() {
        return this._dataSchema;
    }

    public int getLimit() {
        return this._limit;
    }

    public boolean hasLimit() {
        return this._limit != Integer.MAX_VALUE;
    }

    public boolean isNullHandlingEnabled() {
        return this._nullHandlingEnabled;
    }

    public void addNull() {
        assert (this._nullHandlingEnabled);
        this._hasNull = true;
        this._limitWithoutNull = this._limit - 1;
    }

    public boolean hasNull() {
        return this._hasNull;
    }

    public abstract boolean hasOrderBy();

    public abstract void mergeDistinctTable(DistinctTable var1);

    public abstract boolean mergeDataTable(DataTable var1);

    public abstract int size();

    public abstract boolean isSatisfied();

    public abstract List<Object[]> getRows();

    public abstract DataTable toDataTable() throws IOException;

    public abstract ResultTable toResultTable();
}

