/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.table;

import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongHeapPriorityQueue;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.common.datatable.DataTableBuilderFactory;
import org.apache.pinot.core.query.distinct.table.DistinctTable;
import org.apache.pinot.spi.trace.Tracing;
import org.roaringbitmap.RoaringBitmap;

public class LongDistinctTable
extends DistinctTable {
    private final LongOpenHashSet _valueSet;
    private final OrderByExpressionContext _orderByExpression;
    private LongHeapPriorityQueue _priorityQueue;

    public LongDistinctTable(DataSchema dataSchema, int limit, boolean nullHandlingEnabled, @Nullable OrderByExpressionContext orderByExpression) {
        super(dataSchema, limit, nullHandlingEnabled);
        this._valueSet = new LongOpenHashSet(Math.min(limit, 10000));
        this._orderByExpression = orderByExpression;
    }

    public LongDistinctTable(DataSchema dataSchema, int limit, boolean nullHandlingEnabled, @Nullable OrderByExpressionContext orderByExpression, DataTable dataTable) {
        super(dataSchema, limit, nullHandlingEnabled);
        RoaringBitmap nullRowIds;
        int numRows = dataTable.getNumberOfRows();
        this._valueSet = new LongOpenHashSet(numRows);
        this._orderByExpression = orderByExpression;
        RoaringBitmap roaringBitmap = nullRowIds = nullHandlingEnabled ? dataTable.getNullRowIds(0) : null;
        if (nullRowIds == null) {
            for (int i = 0; i < numRows; ++i) {
                this._valueSet.add(dataTable.getLong(i, 0));
            }
        } else {
            assert (nullRowIds.getCardinality() == 1);
            this.addNull();
            int nullRowId = nullRowIds.first();
            if (nullRowId == 0) {
                for (int i = 1; i < numRows; ++i) {
                    this._valueSet.add(dataTable.getLong(i, 0));
                }
            } else {
                int i;
                for (i = 0; i < nullRowId; ++i) {
                    this._valueSet.add(dataTable.getLong(i, 0));
                }
                for (i = nullRowId + 1; i < numRows; ++i) {
                    this._valueSet.add(dataTable.getLong(i, 0));
                }
            }
        }
        assert (this._valueSet.size() <= limit);
    }

    @Override
    public boolean hasOrderBy() {
        return this._orderByExpression != null;
    }

    public boolean addWithoutOrderBy(long value) {
        assert (this._valueSet.size() < this._limit);
        this._valueSet.add(value);
        return this._valueSet.size() >= this._limitWithoutNull;
    }

    public void addWithOrderBy(long value) {
        assert (this._valueSet.size() <= this._limit);
        if (this._valueSet.size() < this._limit) {
            this._valueSet.add(value);
            return;
        }
        if (this._valueSet.contains(value)) {
            return;
        }
        if (this._priorityQueue == null) {
            LongComparator comparator = this._orderByExpression.isAsc() ? (v1, v2) -> Long.compare(v2, v1) : Long::compare;
            this._priorityQueue = new LongHeapPriorityQueue((LongCollection)this._valueSet, comparator);
        }
        long firstValue = this._priorityQueue.firstLong();
        if (this._priorityQueue.comparator().compare(value, firstValue) > 0) {
            this._valueSet.remove(firstValue);
            this._valueSet.add(value);
            this._priorityQueue.dequeueLong();
            this._priorityQueue.enqueue(value);
        }
    }

    public void addUnbounded(long value) {
        this._valueSet.add(value);
    }

    @Override
    public void mergeDistinctTable(DistinctTable distinctTable) {
        LongDistinctTable longDistinctTable = (LongDistinctTable)distinctTable;
        if (longDistinctTable._hasNull) {
            this.addNull();
        }
        LongIterator longIterator = longDistinctTable._valueSet.iterator();
        if (this.hasLimit()) {
            if (this.hasOrderBy()) {
                while (longIterator.hasNext()) {
                    this.addWithOrderBy(longIterator.nextLong());
                }
            } else {
                while (longIterator.hasNext()) {
                    if (!this.addWithoutOrderBy(longIterator.nextLong())) continue;
                    return;
                }
            }
        } else {
            while (longIterator.hasNext()) {
                this.addUnbounded(longIterator.nextLong());
            }
        }
    }

    @Override
    public boolean mergeDataTable(DataTable dataTable) {
        RoaringBitmap nullRowIds;
        int numRows = dataTable.getNumberOfRows();
        RoaringBitmap roaringBitmap = nullRowIds = this._nullHandlingEnabled ? dataTable.getNullRowIds(0) : null;
        if (nullRowIds == null) {
            return this.addValues(dataTable, 0, numRows);
        }
        assert (nullRowIds.getCardinality() == 1);
        this.addNull();
        int nullRowId = nullRowIds.first();
        if (nullRowId == 0) {
            return this.addValues(dataTable, 1, numRows);
        }
        return this.addValues(dataTable, 0, nullRowId) || this.addValues(dataTable, nullRowId + 1, numRows);
    }

    private boolean addValues(DataTable dataTable, int from, int to) {
        if (this.hasLimit()) {
            if (this.hasOrderBy()) {
                for (int i = from; i < to; ++i) {
                    this.addWithOrderBy(dataTable.getLong(i, 0));
                }
            } else {
                for (int i = from; i < to; ++i) {
                    if (!this.addWithoutOrderBy(dataTable.getLong(i, 0))) continue;
                    return true;
                }
            }
        } else {
            for (int i = from; i < to; ++i) {
                this.addUnbounded(dataTable.getLong(i, 0));
            }
        }
        return false;
    }

    @Override
    public int size() {
        int numValues = this._valueSet.size();
        return this._hasNull ? numValues + 1 : numValues;
    }

    @Override
    public boolean isSatisfied() {
        return this._orderByExpression == null && this._valueSet.size() >= this._limitWithoutNull;
    }

    @Override
    public List<Object[]> getRows() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(this.size());
        if (this._hasNull) {
            rows.add(new Object[]{null});
        }
        LongIterator longIterator = this._valueSet.iterator();
        while (longIterator.hasNext()) {
            rows.add(new Object[]{longIterator.nextLong()});
        }
        return rows;
    }

    @Override
    public DataTable toDataTable() throws IOException {
        DataTableBuilder dataTableBuilder = DataTableBuilderFactory.getDataTableBuilder(this._dataSchema);
        if (this._hasNull) {
            dataTableBuilder.startRow();
            dataTableBuilder.setColumn(0, 0L);
            dataTableBuilder.finishRow();
        }
        int numRowsAdded = 0;
        LongIterator longIterator = this._valueSet.iterator();
        while (longIterator.hasNext()) {
            Tracing.ThreadAccountantOps.sampleAndCheckInterruptionPeriodically((int)numRowsAdded);
            dataTableBuilder.startRow();
            dataTableBuilder.setColumn(0, longIterator.nextLong());
            dataTableBuilder.finishRow();
            ++numRowsAdded;
        }
        if (this._hasNull) {
            RoaringBitmap nullBitmap = new RoaringBitmap();
            nullBitmap.add(0);
            dataTableBuilder.setNullRowIds(nullBitmap);
        }
        return dataTableBuilder.build();
    }

    @Override
    public ResultTable toResultTable() {
        return this.hasOrderBy() ? this.toResultTableWithOrderBy() : this.toResultTableWithoutOrderBy();
    }

    private ResultTable toResultTableWithOrderBy() {
        ArrayList<Object> rows;
        long[] sortedValues;
        int numValues;
        if (this._priorityQueue != null) {
            numValues = this._priorityQueue.size();
            sortedValues = new long[numValues];
            for (int i = numValues - 1; i >= 0; --i) {
                sortedValues[i] = this._priorityQueue.dequeueLong();
            }
        } else {
            sortedValues = this._valueSet.toLongArray();
            Arrays.sort(sortedValues);
            if (!this._orderByExpression.isAsc()) {
                ArrayUtils.reverse((long[])sortedValues);
            }
        }
        numValues = sortedValues.length;
        assert (numValues <= this._limit);
        DataSchema.ColumnDataType columnDataType = this._dataSchema.getColumnDataType(0);
        if (this._hasNull) {
            if (numValues == this._limit) {
                rows = new ArrayList(this._limit);
                if (this._orderByExpression.isNullsLast()) {
                    LongDistinctTable.addRows(columnDataType, sortedValues, numValues, rows);
                } else {
                    rows.add(new Object[]{null});
                    LongDistinctTable.addRows(columnDataType, sortedValues, numValues - 1, rows);
                }
            } else {
                rows = new ArrayList(numValues + 1);
                if (this._orderByExpression.isNullsLast()) {
                    LongDistinctTable.addRows(columnDataType, sortedValues, numValues, rows);
                    rows.add(new Object[]{null});
                } else {
                    rows.add(new Object[]{null});
                    LongDistinctTable.addRows(columnDataType, sortedValues, numValues, rows);
                }
            }
        } else {
            rows = new ArrayList<Object[]>(numValues);
            LongDistinctTable.addRows(columnDataType, sortedValues, numValues, rows);
        }
        return new ResultTable(this._dataSchema, rows);
    }

    private static void addRows(DataSchema.ColumnDataType columnDataType, long[] values, int length, List<Object[]> rows) {
        if (columnDataType == DataSchema.ColumnDataType.TIMESTAMP) {
            for (int i = 0; i < length; ++i) {
                rows.add(new Object[]{new Timestamp(values[i]).toString()});
            }
        } else {
            for (int i = 0; i < length; ++i) {
                rows.add(new Object[]{values[i]});
            }
        }
    }

    private ResultTable toResultTableWithoutOrderBy() {
        ArrayList<Object> rows;
        int numValues = this._valueSet.size();
        assert (numValues <= this._limit);
        DataSchema.ColumnDataType columnDataType = this._dataSchema.getColumnDataType(0);
        if (this._hasNull && numValues < this._limit) {
            rows = new ArrayList(numValues + 1);
            LongDistinctTable.addRows(columnDataType, this._valueSet, rows);
            rows.add(new Object[]{null});
        } else {
            rows = new ArrayList<Object[]>(numValues);
            LongDistinctTable.addRows(columnDataType, this._valueSet, rows);
        }
        return new ResultTable(this._dataSchema, rows);
    }

    private static void addRows(DataSchema.ColumnDataType columnDataType, LongOpenHashSet values, List<Object[]> rows) {
        LongIterator longIterator = values.iterator();
        if (columnDataType == DataSchema.ColumnDataType.TIMESTAMP) {
            while (longIterator.hasNext()) {
                rows.add(new Object[]{new Timestamp(longIterator.nextLong()).toString()});
            }
        } else {
            while (longIterator.hasNext()) {
                rows.add(new Object[]{longIterator.nextLong()});
            }
        }
    }
}

