/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.table;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.query.distinct.table.DistinctTable;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.roaringbitmap.RoaringBitmap;

public class MultiColumnDistinctTable
extends DistinctTable {
    private final HashSet<Record> _recordSet;
    private final List<OrderByExpressionContext> _orderByExpressions;
    private ObjectHeapPriorityQueue<Record> _priorityQueue;

    public MultiColumnDistinctTable(DataSchema dataSchema, int limit, boolean nullHandlingEnabled, @Nullable List<OrderByExpressionContext> orderByExpressions) {
        this(dataSchema, limit, nullHandlingEnabled, orderByExpressions, Math.min(limit, 10000));
    }

    public MultiColumnDistinctTable(DataSchema dataSchema, int limit, boolean nullHandlingEnabled, @Nullable List<OrderByExpressionContext> orderByExpressions, int initialSetSize) {
        super(dataSchema, limit, nullHandlingEnabled);
        this._recordSet = Sets.newHashSetWithExpectedSize((int)initialSetSize);
        this._orderByExpressions = orderByExpressions;
    }

    public MultiColumnDistinctTable(DataSchema dataSchema, int limit, boolean nullHandlingEnabled, @Nullable List<OrderByExpressionContext> orderByExpressions, DataTable dataTable) {
        super(dataSchema, limit, nullHandlingEnabled);
        int numRows = dataTable.getNumberOfRows();
        this._recordSet = Sets.newHashSetWithExpectedSize((int)numRows);
        this._orderByExpressions = orderByExpressions;
        int numColumns = dataSchema.size();
        if (nullHandlingEnabled) {
            RoaringBitmap[] nullBitmaps = new RoaringBitmap[numColumns];
            for (int coldId = 0; coldId < numColumns; ++coldId) {
                nullBitmaps[coldId] = dataTable.getNullRowIds(coldId);
            }
            for (int i = 0; i < numRows; ++i) {
                this._recordSet.add(new Record(SelectionOperatorUtils.extractRowFromDataTableWithNullHandling(dataTable, i, nullBitmaps)));
            }
        } else {
            for (int i = 0; i < numRows; ++i) {
                this._recordSet.add(new Record(SelectionOperatorUtils.extractRowFromDataTable(dataTable, i)));
            }
        }
        assert (this._recordSet.size() <= limit);
    }

    @Override
    public void addNull() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasOrderBy() {
        return this._orderByExpressions != null;
    }

    public boolean addWithoutOrderBy(Record record) {
        assert (this._recordSet.size() < this._limit);
        this._recordSet.add(record);
        return this._recordSet.size() == this._limit;
    }

    public void addWithOrderBy(Record record) {
        assert (this._recordSet.size() <= this._limit);
        if (this._recordSet.size() < this._limit) {
            this._recordSet.add(record);
            return;
        }
        if (this._recordSet.contains(record)) {
            return;
        }
        if (this._priorityQueue == null) {
            this._priorityQueue = new ObjectHeapPriorityQueue(this._recordSet, this.getComparator());
        }
        Record firstRecord = (Record)this._priorityQueue.first();
        if (this._priorityQueue.comparator().compare(record, firstRecord) > 0) {
            this._recordSet.remove(firstRecord);
            this._recordSet.add(record);
            this._priorityQueue.dequeue();
            this._priorityQueue.enqueue((Object)record);
        }
    }

    private Comparator<Record> getComparator() {
        List<String> columnNames = Arrays.asList(this._dataSchema.getColumnNames());
        int numOrderByExpressions = this._orderByExpressions.size();
        int[] orderByExpressionIndices = new int[numOrderByExpressions];
        int[] comparisonFactors = new int[numOrderByExpressions];
        int[] nullComparisonFactors = new int[numOrderByExpressions];
        for (int i = 0; i < numOrderByExpressions; ++i) {
            OrderByExpressionContext orderByExpression = this._orderByExpressions.get(i);
            orderByExpressionIndices[i] = columnNames.indexOf(orderByExpression.getExpression().toString());
            comparisonFactors[i] = orderByExpression.isAsc() ? -1 : 1;
            nullComparisonFactors[i] = orderByExpression.isNullsLast() ? -1 : 1;
        }
        if (this._nullHandlingEnabled) {
            return (r1, r2) -> {
                Object[] values1 = r1.getValues();
                Object[] values2 = r2.getValues();
                for (int i = 0; i < numOrderByExpressions; ++i) {
                    int index = orderByExpressionIndices[i];
                    Comparable value1 = (Comparable)values1[index];
                    Comparable value2 = (Comparable)values2[index];
                    if (value1 == null) {
                        if (value2 == null) continue;
                        return nullComparisonFactors[i];
                    }
                    if (value2 == null) {
                        return -nullComparisonFactors[i];
                    }
                    int result = value1.compareTo(value2) * comparisonFactors[i];
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            };
        }
        return (r1, r2) -> {
            Object[] values1 = r1.getValues();
            Object[] values2 = r2.getValues();
            for (int i = 0; i < numOrderByExpressions; ++i) {
                int index = orderByExpressionIndices[i];
                Comparable value1 = (Comparable)values1[index];
                Comparable value2 = (Comparable)values2[index];
                int result = value1.compareTo(value2) * comparisonFactors[i];
                if (result == 0) continue;
                return result;
            }
            return 0;
        };
    }

    public void addUnbounded(Record record) {
        this._recordSet.add(record);
    }

    @Override
    public void mergeDistinctTable(DistinctTable distinctTable) {
        MultiColumnDistinctTable multiColumnDistinctTable = (MultiColumnDistinctTable)distinctTable;
        if (this.hasLimit()) {
            if (this.hasOrderBy()) {
                for (Record record : multiColumnDistinctTable._recordSet) {
                    this.addWithOrderBy(record);
                }
            } else {
                for (Record record : multiColumnDistinctTable._recordSet) {
                    if (!this.addWithoutOrderBy(record)) continue;
                    return;
                }
            }
        } else {
            for (Record record : multiColumnDistinctTable._recordSet) {
                this.addUnbounded(record);
            }
        }
    }

    @Override
    public boolean mergeDataTable(DataTable dataTable) {
        int numRows = dataTable.getNumberOfRows();
        int numColumns = this._dataSchema.size();
        if (this._nullHandlingEnabled) {
            RoaringBitmap[] nullBitmaps = new RoaringBitmap[numColumns];
            for (int coldId = 0; coldId < numColumns; ++coldId) {
                nullBitmaps[coldId] = dataTable.getNullRowIds(coldId);
            }
            return this.addRecords(numRows, i -> new Record(SelectionOperatorUtils.extractRowFromDataTableWithNullHandling(dataTable, i, nullBitmaps)));
        }
        return this.addRecords(numRows, i -> new Record(SelectionOperatorUtils.extractRowFromDataTable(dataTable, i)));
    }

    private boolean addRecords(int numRows, IntFunction<Record> recordSupplier) {
        if (this.hasLimit()) {
            if (this.hasOrderBy()) {
                for (int i = 0; i < numRows; ++i) {
                    this.addWithOrderBy(recordSupplier.apply(i));
                }
            } else {
                for (int i = 0; i < numRows; ++i) {
                    if (!this.addWithoutOrderBy(recordSupplier.apply(i))) continue;
                    return true;
                }
            }
        } else {
            for (int i = 0; i < numRows; ++i) {
                this.addUnbounded(recordSupplier.apply(i));
            }
        }
        return false;
    }

    @Override
    public int size() {
        return this._recordSet.size();
    }

    @Override
    public boolean isSatisfied() {
        return this._orderByExpressions == null && this._recordSet.size() == this._limit;
    }

    @Override
    public List<Object[]> getRows() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(this._recordSet.size());
        for (Record record : this._recordSet) {
            rows.add(record.getValues());
        }
        return rows;
    }

    @Override
    public DataTable toDataTable() throws IOException {
        return SelectionOperatorUtils.getDataTableFromRows(this.getRows(), this._dataSchema, this._nullHandlingEnabled);
    }

    @Override
    public ResultTable toResultTable() {
        return this.hasOrderBy() ? this.toResultTableWithOrderBy() : this.toResultTableWithoutOrderBy();
    }

    private ResultTable toResultTableWithOrderBy() {
        Record[] sortedRecords;
        if (this._priorityQueue != null) {
            int numRecords = this._priorityQueue.size();
            sortedRecords = new Record[numRecords];
            for (int i = numRecords - 1; i >= 0; --i) {
                sortedRecords[i] = (Record)this._priorityQueue.dequeue();
            }
        } else {
            sortedRecords = this._recordSet.toArray(new Record[0]);
            Arrays.sort(sortedRecords, this.getComparator().reversed());
        }
        return this.createResultTable(Arrays.asList(sortedRecords));
    }

    private ResultTable toResultTableWithoutOrderBy() {
        return this.createResultTable(this._recordSet);
    }

    private ResultTable createResultTable(Collection<Record> records) {
        int numRecords = records.size();
        assert (numRecords <= this._limit);
        ArrayList<Object[]> rows = new ArrayList<Object[]>(numRecords);
        DataSchema.ColumnDataType[] columnDataTypes = this._dataSchema.getColumnDataTypes();
        int numColumns = columnDataTypes.length;
        for (Record record : records) {
            Object[] values = record.getValues();
            for (int i = 0; i < numColumns; ++i) {
                Object value = values[i];
                if (value == null) continue;
                values[i] = columnDataTypes[i].convertAndFormat(value);
            }
            rows.add(values);
        }
        return new ResultTable(this._dataSchema, rows);
    }
}

