/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.optimizer.filter;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.Literal;
import org.apache.pinot.core.query.optimizer.filter.BaseAndOrBooleanFilterOptimizer;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.sql.FilterKind;

public class IdenticalPredicateFilterOptimizer
extends BaseAndOrBooleanFilterOptimizer {
    @Override
    boolean canBeOptimized(Expression filterExpression, @Nullable Schema schema) {
        return filterExpression.getFunctionCall() != null;
    }

    @Override
    Expression optimizeChild(Expression filterExpression, @Nullable Schema schema) {
        Function function = filterExpression.getFunctionCall();
        FilterKind kind = FilterKind.valueOf((String)function.getOperator());
        switch (kind) {
            case EQUALS: {
                if (!this.hasIdenticalLhsAndRhs(function.getOperands())) break;
                return TRUE;
            }
            case NOT_EQUALS: {
                if (!this.hasIdenticalLhsAndRhs(function.getOperands())) break;
                return FALSE;
            }
        }
        return filterExpression;
    }

    private boolean hasIdenticalLhsAndRhs(List<Expression> operands) {
        boolean firstChildHasTwoOperands;
        boolean hasTwoChildren = operands.size() == 2;
        Expression firstChild = operands.get(0);
        if (firstChild.getFunctionCall() == null || !hasTwoChildren) {
            return false;
        }
        boolean firstChildIsMinusOperator = firstChild.getFunctionCall().getOperator().equals("minus");
        if (!firstChildIsMinusOperator) {
            return false;
        }
        boolean bl = firstChildHasTwoOperands = firstChild.getFunctionCall().getOperandsSize() == 2;
        if (!firstChildHasTwoOperands) {
            return false;
        }
        Expression minusOperandFirstChild = (Expression)firstChild.getFunctionCall().getOperands().get(0);
        Expression minusOperandSecondChild = (Expression)firstChild.getFunctionCall().getOperands().get(1);
        if (minusOperandFirstChild == null || minusOperandSecondChild == null || !minusOperandFirstChild.equals(minusOperandSecondChild)) {
            return false;
        }
        Expression secondChild = operands.get(1);
        return this.isLiteralZero(secondChild);
    }

    private boolean isLiteralZero(Expression expression) {
        Literal literal = expression.getLiteral();
        return literal != null && literal.isSetIntValue() && literal.getIntValue() == 0;
    }
}

