/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.optimizer.filter;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.context.RequestContextUtils;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.core.query.optimizer.filter.FilterOptimizer;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.sql.FilterKind;

public class MergeEqInFilterOptimizer
implements FilterOptimizer {
    @Override
    public Expression optimize(Expression filterExpression, @Nullable Schema schema) {
        return filterExpression.getType() == ExpressionType.FUNCTION ? this.optimize(filterExpression) : filterExpression;
    }

    private Expression optimize(Expression filterExpression) {
        Function function = filterExpression.getFunctionCall();
        if (function == null) {
            return filterExpression;
        }
        String operator = function.getOperator();
        if (operator.equals(FilterKind.OR.name())) {
            List children = function.getOperands();
            HashMap<Expression, Map> valuesMap = new HashMap<Expression, Map>();
            ArrayList<Expression> newChildren = new ArrayList<Expression>(children.size());
            boolean[] recreateFilter = new boolean[1];
            for (Expression expression : children) {
                Expression lhs;
                List operands;
                Function childFunction = expression.getFunctionCall();
                if (childFunction == null) {
                    newChildren.add(expression);
                    continue;
                }
                String childOperator = childFunction.getOperator();
                assert (!childOperator.equals(FilterKind.OR.name()));
                if (childOperator.equals(FilterKind.AND.name()) || childOperator.equals(FilterKind.NOT.name())) {
                    childFunction.getOperands().replaceAll(this::optimize);
                    newChildren.add(expression);
                    continue;
                }
                if (childOperator.equals(FilterKind.EQUALS.name())) {
                    operands = childFunction.getOperands();
                    lhs = (Expression)operands.get(0);
                    Expression value = (Expression)operands.get(1);
                    String stringValue = RequestContextUtils.getStringValue((Expression)value);
                    valuesMap.compute(lhs, (k, v) -> {
                        if (v == null) {
                            HashMap<String, Expression> values = new HashMap<String, Expression>();
                            values.put(stringValue, value);
                            return values;
                        }
                        v.put(stringValue, value);
                        recreateFilter[0] = true;
                        return v;
                    });
                    continue;
                }
                if (childOperator.equals(FilterKind.IN.name())) {
                    operands = childFunction.getOperands();
                    lhs = (Expression)operands.get(0);
                    valuesMap.compute(lhs, (k, v) -> {
                        if (v == null) {
                            Map<String, Expression> values = this.getInValues(operands);
                            int numUniqueValues = values.size();
                            if (numUniqueValues == 1 || numUniqueValues != operands.size() - 1) {
                                recreateFilter[0] = true;
                            }
                            return values;
                        }
                        int numOperands = operands.size();
                        for (int i = 1; i < numOperands; ++i) {
                            Expression value = (Expression)operands.get(i);
                            String stringValue = RequestContextUtils.getStringValue((Expression)value);
                            v.put(stringValue, value);
                        }
                        recreateFilter[0] = true;
                        return v;
                    });
                    continue;
                }
                newChildren.add(expression);
            }
            if (recreateFilter[0]) {
                if (newChildren.isEmpty() && valuesMap.size() == 1) {
                    Map.Entry entry = valuesMap.entrySet().iterator().next();
                    return MergeEqInFilterOptimizer.getFilterExpression((Expression)entry.getKey(), ((Map)entry.getValue()).values());
                }
                for (Map.Entry entry : valuesMap.entrySet()) {
                    newChildren.add(MergeEqInFilterOptimizer.getFilterExpression((Expression)entry.getKey(), ((Map)entry.getValue()).values()));
                }
                function.setOperands(newChildren);
                return filterExpression;
            }
            return filterExpression;
        }
        if (operator.equals(FilterKind.AND.name())) {
            function.getOperands().replaceAll(this::optimize);
            return filterExpression;
        }
        if (operator.equals(FilterKind.IN.name())) {
            List operands = function.getOperands();
            Map<String, Expression> values = this.getInValues(operands);
            int numUniqueValues = values.size();
            if (numUniqueValues == 1 || numUniqueValues != operands.size() - 1) {
                return MergeEqInFilterOptimizer.getFilterExpression((Expression)operands.get(0), values.values());
            }
            return filterExpression;
        }
        return filterExpression;
    }

    private Map<String, Expression> getInValues(List<Expression> operands) {
        int numOperands = operands.size();
        HashMap values = Maps.newHashMapWithExpectedSize((int)(numOperands - 1));
        for (int i = 1; i < numOperands; ++i) {
            Expression value = operands.get(i);
            String stringValue = RequestContextUtils.getStringValue((Expression)value);
            values.put(stringValue, value);
        }
        return values;
    }

    private static Expression getFilterExpression(Expression lhs, Collection<Expression> values) {
        int numValues = values.size();
        if (numValues == 1) {
            return RequestUtils.getFunctionExpression((String)FilterKind.EQUALS.name(), (Expression[])new Expression[]{lhs, values.iterator().next()});
        }
        ArrayList<Expression> operands = new ArrayList<Expression>(numValues + 1);
        operands.add(lhs);
        operands.addAll(values);
        return RequestUtils.getFunctionExpression((String)FilterKind.IN.name(), operands);
    }
}

