/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.optimizer.filter;

import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.Literal;
import org.apache.pinot.core.query.optimizer.filter.BaseAndOrBooleanFilterOptimizer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.sql.FilterKind;

public class NumericalFilterOptimizer
extends BaseAndOrBooleanFilterOptimizer {
    @Override
    boolean canBeOptimized(Expression filterExpression, @Nullable Schema schema) {
        ExpressionType type = filterExpression.getType();
        return type == ExpressionType.FUNCTION && schema != null;
    }

    @Override
    Expression optimizeChild(Expression filterExpression, @Nullable Schema schema) {
        Function function = filterExpression.getFunctionCall();
        FilterKind kind = FilterKind.valueOf((String)function.getOperator());
        if (!kind.isRange() && kind != FilterKind.EQUALS && kind != FilterKind.NOT_EQUALS) {
            return filterExpression;
        }
        List operands = function.getOperands();
        Expression lhs = (Expression)operands.get(0);
        Expression rhs = (Expression)operands.get(1);
        FieldSpec.DataType dataType = NumericalFilterOptimizer.getDataType(lhs, schema);
        if (dataType == null || !dataType.isNumeric() || !rhs.isSetLiteral()) {
            return filterExpression;
        }
        switch (kind) {
            case BETWEEN: {
                return NumericalFilterOptimizer.rewriteBetweenExpression(filterExpression, dataType);
            }
            case EQUALS: 
            case NOT_EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                if (kind.isRange()) {
                    return NumericalFilterOptimizer.rewriteRangeExpression(filterExpression, kind, dataType, rhs);
                }
                return NumericalFilterOptimizer.rewriteEqualsExpression(filterExpression, kind, dataType, rhs);
            }
        }
        return filterExpression;
    }

    private static Expression rewriteEqualsExpression(Expression equals, FilterKind kind, FieldSpec.DataType dataType, Expression rhs) {
        boolean result = kind == FilterKind.NOT_EQUALS;
        block0 : switch ((Literal._Fields)rhs.getLiteral().getSetField()) {
            case INT_VALUE: {
                break;
            }
            case LONG_VALUE: {
                long actual = rhs.getLiteral().getLongValue();
                switch (dataType) {
                    case INT: {
                        int converted = (int)actual;
                        if ((long)converted != actual) {
                            return NumericalFilterOptimizer.getExpressionFromBoolean(result);
                        }
                        rhs.getLiteral().setLongValue((long)converted);
                        break block0;
                    }
                    case FLOAT: {
                        float converted = actual;
                        if (BigDecimal.valueOf(actual).compareTo(BigDecimal.valueOf(converted)) != 0) {
                            return NumericalFilterOptimizer.getExpressionFromBoolean(result);
                        }
                        rhs.getLiteral().setDoubleValue((double)converted);
                        break block0;
                    }
                    case DOUBLE: {
                        double converted = actual;
                        if (BigDecimal.valueOf(actual).compareTo(BigDecimal.valueOf(converted)) != 0) {
                            return NumericalFilterOptimizer.getExpressionFromBoolean(result);
                        }
                        rhs.getLiteral().setDoubleValue(converted);
                        break block0;
                    }
                }
                break;
            }
            case DOUBLE_VALUE: {
                double actual = rhs.getLiteral().getDoubleValue();
                switch (dataType) {
                    case INT: {
                        int converted = (int)actual;
                        if ((double)converted != actual) {
                            return NumericalFilterOptimizer.getExpressionFromBoolean(result);
                        }
                        rhs.getLiteral().setLongValue((long)converted);
                        break block0;
                    }
                    case LONG: {
                        long converted = (long)actual;
                        if (BigDecimal.valueOf(actual).compareTo(BigDecimal.valueOf(converted)) != 0) {
                            return NumericalFilterOptimizer.getExpressionFromBoolean(result);
                        }
                        rhs.getLiteral().setLongValue(converted);
                        break block0;
                    }
                }
                break;
            }
        }
        return equals;
    }

    private static Expression rewriteRangeExpression(Expression range, FilterKind kind, FieldSpec.DataType dataType, Expression rhs) {
        block0 : switch ((Literal._Fields)rhs.getLiteral().getSetField()) {
            case INT_VALUE: {
                break;
            }
            case LONG_VALUE: {
                long actual = rhs.getLiteral().getLongValue();
                switch (dataType) {
                    case INT: {
                        int converted = (int)actual;
                        int comparison = Long.compare(actual, converted);
                        if (comparison > 0) {
                            return NumericalFilterOptimizer.getExpressionFromBoolean(kind == FilterKind.LESS_THAN || kind == FilterKind.LESS_THAN_OR_EQUAL);
                        }
                        if (comparison >= 0) break block0;
                        return NumericalFilterOptimizer.getExpressionFromBoolean(kind == FilterKind.GREATER_THAN || kind == FilterKind.GREATER_THAN_OR_EQUAL);
                    }
                    case FLOAT: {
                        float converted = actual;
                        int comparison = BigDecimal.valueOf(actual).compareTo(BigDecimal.valueOf(converted));
                        NumericalFilterOptimizer.rewriteRangeOperator(range, kind, comparison);
                        rhs.getLiteral().setDoubleValue((double)converted);
                        break block0;
                    }
                    case DOUBLE: {
                        double converted = actual;
                        int comparison = BigDecimal.valueOf(actual).compareTo(BigDecimal.valueOf(converted));
                        NumericalFilterOptimizer.rewriteRangeOperator(range, kind, comparison);
                        rhs.getLiteral().setDoubleValue(converted);
                        break block0;
                    }
                }
                break;
            }
            case DOUBLE_VALUE: {
                double actual = rhs.getLiteral().getDoubleValue();
                switch (dataType) {
                    case INT: {
                        int converted = (int)actual;
                        int comparison = Double.compare(actual, converted);
                        if (comparison > 0 && converted == Integer.MAX_VALUE) {
                            return NumericalFilterOptimizer.getExpressionFromBoolean(kind == FilterKind.LESS_THAN || kind == FilterKind.LESS_THAN_OR_EQUAL);
                        }
                        if (comparison < 0 && converted == Integer.MIN_VALUE) {
                            return NumericalFilterOptimizer.getExpressionFromBoolean(kind == FilterKind.GREATER_THAN || kind == FilterKind.GREATER_THAN_OR_EQUAL);
                        }
                        NumericalFilterOptimizer.rewriteRangeOperator(range, kind, comparison);
                        rhs.getLiteral().setLongValue((long)converted);
                        break block0;
                    }
                    case LONG: {
                        long converted = (long)actual;
                        int comparison = BigDecimal.valueOf(actual).compareTo(BigDecimal.valueOf(converted));
                        if (comparison > 0 && converted == Long.MAX_VALUE) {
                            return NumericalFilterOptimizer.getExpressionFromBoolean(kind == FilterKind.LESS_THAN || kind == FilterKind.LESS_THAN_OR_EQUAL);
                        }
                        if (comparison < 0 && converted == Long.MIN_VALUE) {
                            return NumericalFilterOptimizer.getExpressionFromBoolean(kind == FilterKind.GREATER_THAN || kind == FilterKind.GREATER_THAN_OR_EQUAL);
                        }
                        NumericalFilterOptimizer.rewriteRangeOperator(range, kind, comparison);
                        rhs.getLiteral().setLongValue(converted);
                        break block0;
                    }
                    case FLOAT: {
                        float converted = (float)actual;
                        if (converted == Float.POSITIVE_INFINITY) {
                            return NumericalFilterOptimizer.getExpressionFromBoolean(kind == FilterKind.LESS_THAN || kind == FilterKind.LESS_THAN_OR_EQUAL);
                        }
                        if (converted != Float.NEGATIVE_INFINITY) break block0;
                        return NumericalFilterOptimizer.getExpressionFromBoolean(kind == FilterKind.GREATER_THAN || kind == FilterKind.GREATER_THAN_OR_EQUAL);
                    }
                }
                break;
            }
        }
        return range;
    }

    private static Expression rewriteBetweenExpression(Expression between, FieldSpec.DataType dataType) {
        int comparison;
        int comparison2;
        int converted;
        long actual;
        List operands = between.getFunctionCall().getOperands();
        Expression lower = (Expression)operands.get(1);
        Expression upper = (Expression)operands.get(2);
        if (lower.isSetLiteral()) {
            block0 : switch ((Literal._Fields)lower.getLiteral().getSetField()) {
                case LONG_VALUE: {
                    actual = lower.getLiteral().getLongValue();
                    if (dataType != FieldSpec.DataType.INT) break;
                    if (actual > Integer.MAX_VALUE) {
                        return NumericalFilterOptimizer.getExpressionFromBoolean(false);
                    }
                    if (actual >= Integer.MIN_VALUE) break;
                    lower.getLiteral().setIntValue(Integer.MIN_VALUE);
                    break;
                }
                case DOUBLE_VALUE: {
                    double actual2 = lower.getLiteral().getDoubleValue();
                    switch (dataType) {
                        case INT: {
                            if (actual2 > 2.147483647E9) {
                                return NumericalFilterOptimizer.getExpressionFromBoolean(false);
                            }
                            if (actual2 < -2.147483648E9) {
                                lower.getLiteral().setIntValue(Integer.MIN_VALUE);
                                break block0;
                            }
                            converted = (int)actual2;
                            comparison2 = BigDecimal.valueOf(converted).compareTo(BigDecimal.valueOf(actual2));
                            if (comparison2 >= 0) {
                                lower.getLiteral().setIntValue(converted);
                                break block0;
                            }
                            lower.getLiteral().setIntValue(converted + 1);
                            break block0;
                        }
                        case LONG: {
                            if (actual2 > 9.223372036854776E18) {
                                return NumericalFilterOptimizer.getExpressionFromBoolean(false);
                            }
                            if (actual2 < -9.223372036854776E18) {
                                lower.getLiteral().setLongValue(Long.MIN_VALUE);
                                break block0;
                            }
                            long converted2 = (long)actual2;
                            comparison = BigDecimal.valueOf(converted2).compareTo(BigDecimal.valueOf(actual2));
                            if (comparison >= 0) {
                                lower.getLiteral().setLongValue(converted2);
                                break block0;
                            }
                            lower.getLiteral().setLongValue(converted2 + 1L);
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
        if (upper.isSetLiteral()) {
            block8 : switch ((Literal._Fields)upper.getLiteral().getSetField()) {
                case LONG_VALUE: {
                    actual = upper.getLiteral().getLongValue();
                    if (dataType != FieldSpec.DataType.INT) break;
                    if (actual < Integer.MIN_VALUE) {
                        return NumericalFilterOptimizer.getExpressionFromBoolean(false);
                    }
                    if (actual <= Integer.MAX_VALUE) break;
                    upper.getLiteral().setIntValue(Integer.MAX_VALUE);
                    break;
                }
                case DOUBLE_VALUE: {
                    double actual3 = upper.getLiteral().getDoubleValue();
                    switch (dataType) {
                        case INT: {
                            if (actual3 < -2.147483648E9) {
                                return NumericalFilterOptimizer.getExpressionFromBoolean(false);
                            }
                            if (actual3 > 2.147483647E9) {
                                upper.getLiteral().setIntValue(Integer.MAX_VALUE);
                                break block8;
                            }
                            converted = (int)actual3;
                            comparison2 = BigDecimal.valueOf(converted).compareTo(BigDecimal.valueOf(actual3));
                            if (comparison2 <= 0) {
                                upper.getLiteral().setIntValue(converted);
                                break block8;
                            }
                            upper.getLiteral().setIntValue(converted - 1);
                            break block8;
                        }
                        case LONG: {
                            if (actual3 < -9.223372036854776E18) {
                                return NumericalFilterOptimizer.getExpressionFromBoolean(false);
                            }
                            if (actual3 > 9.223372036854776E18) {
                                upper.getLiteral().setLongValue(Long.MAX_VALUE);
                                break block8;
                            }
                            long converted3 = (long)actual3;
                            comparison = BigDecimal.valueOf(converted3).compareTo(BigDecimal.valueOf(actual3));
                            if (comparison <= 0) {
                                upper.getLiteral().setLongValue(converted3);
                                break block8;
                            }
                            upper.getLiteral().setLongValue(converted3 - 1L);
                            break block8;
                        }
                    }
                    break;
                }
            }
        }
        return between;
    }

    private static void rewriteRangeOperator(Expression range, FilterKind kind, int comparison) {
        if (comparison > 0) {
            if (kind == FilterKind.GREATER_THAN || kind == FilterKind.GREATER_THAN_OR_EQUAL) {
                range.getFunctionCall().setOperator(FilterKind.GREATER_THAN.name());
            } else if (kind == FilterKind.LESS_THAN || kind == FilterKind.LESS_THAN_OR_EQUAL) {
                range.getFunctionCall().setOperator(FilterKind.LESS_THAN_OR_EQUAL.name());
            }
        } else if (comparison < 0) {
            if (kind == FilterKind.GREATER_THAN || kind == FilterKind.GREATER_THAN_OR_EQUAL) {
                range.getFunctionCall().setOperator(FilterKind.GREATER_THAN_OR_EQUAL.name());
            } else if (kind == FilterKind.LESS_THAN || kind == FilterKind.LESS_THAN_OR_EQUAL) {
                range.getFunctionCall().setOperator(FilterKind.LESS_THAN.name());
            }
        }
    }

    @Nullable
    private static FieldSpec.DataType getDataType(Expression expression, Schema schema) {
        if (expression.getType() == ExpressionType.IDENTIFIER) {
            String column = expression.getIdentifier().getName();
            FieldSpec fieldSpec = schema.getFieldSpecFor(column);
            if (fieldSpec != null && fieldSpec.isSingleValueField()) {
                return fieldSpec.getDataType();
            }
        } else if (expression.getType() == ExpressionType.FUNCTION && "cast".equalsIgnoreCase(expression.getFunctionCall().getOperator())) {
            String targetTypeLiteral = ((Expression)expression.getFunctionCall().getOperands().get(1)).getLiteral().getStringValue().toUpperCase();
            if (targetTypeLiteral.endsWith("_ARRAY")) {
                targetTypeLiteral = targetTypeLiteral.substring(0, targetTypeLiteral.length() - 6);
            }
            FieldSpec.DataType dataType = "INTEGER".equals(targetTypeLiteral) ? FieldSpec.DataType.INT : ("VARCHAR".equals(targetTypeLiteral) ? FieldSpec.DataType.STRING : FieldSpec.DataType.valueOf((String)targetTypeLiteral));
            return dataType;
        }
        return null;
    }
}

