/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.optimizer.statement;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.FunctionRegistry;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.core.query.optimizer.statement.StatementOptimizer;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.sql.FilterKind;

public class StringPredicateFilterOptimizer
implements StatementOptimizer {
    private static final String MINUS_OPERATOR_NAME = "minus";
    private static final String STRCMP_OPERATOR_NAME = "strcmp";

    @Override
    public void optimize(PinotQuery query, @Nullable TableConfig tableConfig, @Nullable Schema schema) {
        Expression expression;
        if (schema == null) {
            return;
        }
        Expression filter = query.getFilterExpression();
        if (filter != null) {
            StringPredicateFilterOptimizer.optimizeExpression(filter, schema);
        }
        if ((expression = query.getHavingExpression()) != null) {
            StringPredicateFilterOptimizer.optimizeExpression(expression, schema);
        }
    }

    private static void optimizeExpression(Expression expression, Schema schema) {
        ExpressionType type = expression.getType();
        if (type != ExpressionType.FUNCTION) {
            return;
        }
        Function function = expression.getFunctionCall();
        String operator = function.getOperator();
        List operands = function.getOperands();
        if (operator.equals(FilterKind.AND.name()) || operator.equals(FilterKind.OR.name()) || operator.equals(FilterKind.NOT.name())) {
            for (Expression operand : operands) {
                StringPredicateFilterOptimizer.optimizeExpression(operand, schema);
            }
        } else {
            StringPredicateFilterOptimizer.replaceMinusWithCompareForStrings((Expression)operands.get(0), schema);
        }
    }

    private static void replaceMinusWithCompareForStrings(Expression expression, Schema schema) {
        if (expression.getType() != ExpressionType.FUNCTION) {
            return;
        }
        Function function = expression.getFunctionCall();
        String operator = function.getOperator();
        List operands = function.getOperands();
        if (operator.equals(MINUS_OPERATOR_NAME) && operands.size() == 2 && StringPredicateFilterOptimizer.isString((Expression)operands.get(0), schema) && StringPredicateFilterOptimizer.isString((Expression)operands.get(1), schema)) {
            function.setOperator(STRCMP_OPERATOR_NAME);
        }
    }

    private static boolean isString(Expression expression, Schema schema) {
        ExpressionType expressionType = expression.getType();
        if (expressionType == ExpressionType.IDENTIFIER) {
            String column = expression.getIdentifier().getName();
            FieldSpec fieldSpec = schema.getFieldSpecFor(column);
            return fieldSpec != null && fieldSpec.getDataType() == FieldSpec.DataType.STRING;
        }
        if (expressionType == ExpressionType.FUNCTION) {
            Function function = expression.getFunctionCall();
            String canonicalName = FunctionRegistry.canonicalize((String)function.getOperator());
            FunctionInfo functionInfo = FunctionRegistry.lookupFunctionInfo((String)canonicalName, (int)function.getOperands().size());
            return functionInfo != null && functionInfo.getMethod().getReturnType() == String.class;
        }
        return false;
    }
}

