/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.postaggregation;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.FunctionInvoker;
import org.apache.pinot.common.function.FunctionRegistry;
import org.apache.pinot.common.function.FunctionUtils;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.PinotDataType;

public class PostAggregationFunction {
    private final FunctionInvoker _functionInvoker;
    private final DataSchema.ColumnDataType _resultType;
    @Nullable
    private PinotDataType[] _argumentTypes;

    public PostAggregationFunction(String functionName, DataSchema.ColumnDataType[] argumentTypes) {
        String canonicalName = FunctionRegistry.canonicalize((String)functionName);
        FunctionInfo functionInfo = FunctionRegistry.lookupFunctionInfo((String)canonicalName, (DataSchema.ColumnDataType[])argumentTypes);
        if (functionInfo == null) {
            if (FunctionRegistry.contains((String)canonicalName)) {
                throw new IllegalArgumentException("Unsupported function: " + functionName + " with argument types: " + Arrays.toString(argumentTypes));
            }
            throw new IllegalArgumentException("Unsupported function: " + functionName);
        }
        this._functionInvoker = new FunctionInvoker(functionInfo);
        DataSchema.ColumnDataType resultType = FunctionUtils.getColumnDataType((Class)this._functionInvoker.getResultClass());
        DataSchema.ColumnDataType columnDataType = this._resultType = resultType != null ? resultType : DataSchema.ColumnDataType.STRING;
        if (!this._functionInvoker.getMethod().isVarArgs()) {
            int i;
            Class[] parameterClasses = this._functionInvoker.getParameterClasses();
            PinotDataType[] parameterTypes = this._functionInvoker.getParameterTypes();
            int numArguments = argumentTypes.length;
            int numParameters = parameterClasses.length;
            Preconditions.checkArgument((numArguments == numParameters ? 1 : 0) != 0, (String)"Wrong number of arguments for method: %s, expected: %s, actual: %s", (Object)functionInfo.getMethod(), (Object)numParameters, (Object)numArguments);
            for (i = 0; i < numParameters; ++i) {
                Preconditions.checkArgument((parameterTypes[i] != null ? 1 : 0) != 0, (String)"Unsupported parameter class: %s for method: %s", (Object)parameterClasses[i], (Object)functionInfo.getMethod());
            }
            this._argumentTypes = new PinotDataType[numArguments];
            for (i = 0; i < numArguments; ++i) {
                this._argumentTypes[i] = PinotDataType.getPinotDataTypeForExecution((DataSchema.ColumnDataType)argumentTypes[i]);
            }
        }
    }

    public DataSchema.ColumnDataType getResultType() {
        return this._resultType;
    }

    public Object invoke(Object[] arguments) {
        Object result;
        if (this._functionInvoker.getMethod().isVarArgs()) {
            result = this._functionInvoker.invoke(new Object[]{arguments});
        } else {
            int numArguments = arguments.length;
            PinotDataType[] parameterTypes = this._functionInvoker.getParameterTypes();
            for (int i = 0; i < numArguments; ++i) {
                PinotDataType parameterType = parameterTypes[i];
                PinotDataType argumentType = this._argumentTypes[i];
                if (parameterType == argumentType) continue;
                arguments[i] = parameterType.convert(arguments[i], argumentType);
            }
            result = this._functionInvoker.invoke(arguments);
        }
        return this._resultType == DataSchema.ColumnDataType.STRING ? result.toString() : result;
    }
}

