/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.pruner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.predicate.EqPredicate;
import org.apache.pinot.common.request.context.predicate.InPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.core.query.prefetch.FetchPlanner;
import org.apache.pinot.core.query.prefetch.FetchPlannerRegistry;
import org.apache.pinot.core.query.pruner.ValueBasedSegmentPruner;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.util.QueryMultiThreadingUtils;
import org.apache.pinot.segment.spi.FetchContext;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;
import org.apache.pinot.segment.spi.index.reader.BloomFilterReader;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.exception.QueryCancelledException;

public class BloomFilterSegmentPruner
extends ValueBasedSegmentPruner {
    private static final int TARGET_NUM_SEGMENTS_PER_THREAD = 10;
    private FetchPlanner _fetchPlanner;

    @Override
    public void init(PinotConfiguration config) {
        super.init(config);
        this._fetchPlanner = FetchPlannerRegistry.getPlanner();
    }

    @Override
    protected boolean isApplicableToPredicate(Predicate predicate) {
        List values;
        if (predicate.getLhs().getType() != ExpressionContext.Type.IDENTIFIER) {
            return false;
        }
        Predicate.Type predicateType = predicate.getType();
        if (predicateType == Predicate.Type.EQ) {
            return true;
        }
        return predicateType == Predicate.Type.IN && (values = ((InPredicate)predicate).getValues()).size() <= this._inPredicateThreshold;
    }

    @Override
    public List<IndexSegment> prune(List<IndexSegment> segments, QueryContext query) {
        if (segments.isEmpty()) {
            return segments;
        }
        if (!query.isEnablePrefetch()) {
            return super.prune(segments, query);
        }
        return this.prefetch(segments, query, fetchContexts -> {
            int numSegments = segments.size();
            FilterContext filter = Objects.requireNonNull(query.getFilter());
            ValueBasedSegmentPruner.ValueCache cachedValues = new ValueBasedSegmentPruner.ValueCache();
            HashMap<String, DataSource> dataSourceCache = new HashMap<String, DataSource>();
            ArrayList<IndexSegment> selectedSegments = new ArrayList<IndexSegment>(numSegments);
            for (int i = 0; i < numSegments; ++i) {
                dataSourceCache.clear();
                IndexSegment segment = (IndexSegment)segments.get(i);
                if (this.pruneSegmentWithFetchContext(segment, fetchContexts[i], filter, dataSourceCache, cachedValues)) continue;
                selectedSegments.add(segment);
            }
            return selectedSegments;
        });
    }

    @Override
    public List<IndexSegment> prune(List<IndexSegment> segments, QueryContext query, @Nullable ExecutorService executorService) {
        if (segments.isEmpty()) {
            return segments;
        }
        if (executorService == null || segments.size() <= 10) {
            return this.prune(segments, query);
        }
        int numTasks = QueryMultiThreadingUtils.getNumTasks(segments.size(), 10, query.getMaxExecutionThreads());
        if (!query.isEnablePrefetch()) {
            return this.pruneInParallel(numTasks, segments, query, executorService, null);
        }
        return this.prefetch(segments, query, fetchContexts -> this.pruneInParallel(numTasks, segments, query, executorService, (FetchContext[])fetchContexts));
    }

    private List<IndexSegment> pruneInParallel(int numTasks, List<IndexSegment> segments, QueryContext queryContext, ExecutorService executorService, FetchContext[] fetchContexts) {
        int numSegments = segments.size();
        ArrayList<IndexSegment> allSelectedSegments = new ArrayList<IndexSegment>();
        QueryMultiThreadingUtils.runTasksWithDeadline(numTasks, index -> {
            FilterContext filter = Objects.requireNonNull(queryContext.getFilter());
            ValueBasedSegmentPruner.ValueCache cachedValues = new ValueBasedSegmentPruner.ValueCache();
            HashMap<String, DataSource> dataSourceCache = new HashMap<String, DataSource>();
            ArrayList<IndexSegment> selectedSegments = new ArrayList<IndexSegment>();
            for (int i = index.intValue(); i < numSegments; i += numTasks) {
                FetchContext fetchContext;
                dataSourceCache.clear();
                IndexSegment segment = (IndexSegment)segments.get(i);
                FetchContext fetchContext2 = fetchContext = fetchContexts == null ? null : fetchContexts[i];
                if (this.pruneSegmentWithFetchContext(segment, fetchContext, filter, dataSourceCache, cachedValues)) continue;
                selectedSegments.add(segment);
            }
            return selectedSegments;
        }, taskRes -> {
            if (taskRes != null) {
                allSelectedSegments.addAll((Collection<IndexSegment>)taskRes);
            }
        }, e -> {
            if (e instanceof InterruptedException) {
                throw new QueryCancelledException("Cancelled while running BloomFilterSegmentPruner", (Throwable)e);
            }
            throw new RuntimeException("Caught exception while running BloomFilterSegmentPruner", (Throwable)e);
        }, executorService, queryContext.getEndTimeMs());
        return allSelectedSegments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IndexSegment> prefetch(List<IndexSegment> segments, QueryContext query, Function<FetchContext[], List<IndexSegment>> pruneFunc) {
        FetchContext fetchContext;
        int numSegments = segments.size();
        FetchContext[] fetchContexts = new FetchContext[numSegments];
        try {
            for (int i = 0; i < numSegments; ++i) {
                IndexSegment segment = segments.get(i);
                fetchContext = this._fetchPlanner.planFetchForPruning(segment, query);
                if (fetchContext.isEmpty()) continue;
                segment.prefetch(fetchContext);
                fetchContexts[i] = fetchContext;
            }
            List<IndexSegment> list = pruneFunc.apply(fetchContexts);
            return list;
        }
        finally {
            for (int i = 0; i < numSegments; ++i) {
                fetchContext = fetchContexts[i];
                if (fetchContext == null) continue;
                segments.get(i).release(fetchContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pruneSegmentWithFetchContext(IndexSegment segment, FetchContext fetchContext, FilterContext filter, Map<String, DataSource> dataSourceCache, ValueBasedSegmentPruner.ValueCache cachedValues) {
        if (fetchContext == null) {
            return this.pruneSegment(segment, filter, dataSourceCache, cachedValues);
        }
        try {
            segment.acquire(fetchContext);
            boolean bl = this.pruneSegment(segment, filter, dataSourceCache, cachedValues);
            return bl;
        }
        finally {
            segment.release(fetchContext);
        }
    }

    @Override
    boolean pruneSegmentWithPredicate(IndexSegment segment, Predicate predicate, Map<String, DataSource> dataSourceCache, ValueBasedSegmentPruner.ValueCache cachedValues) {
        Predicate.Type predicateType = predicate.getType();
        if (predicateType == Predicate.Type.EQ) {
            return this.pruneEqPredicate(segment, (EqPredicate)predicate, dataSourceCache, cachedValues);
        }
        if (predicateType == Predicate.Type.IN) {
            return this.pruneInPredicate(segment, (InPredicate)predicate, dataSourceCache, cachedValues);
        }
        return false;
    }

    private boolean pruneEqPredicate(IndexSegment segment, EqPredicate eqPredicate, Map<String, DataSource> dataSourceCache, ValueBasedSegmentPruner.ValueCache valueCache) {
        DataSource dataSource;
        String column = eqPredicate.getLhs().getIdentifier();
        DataSource dataSource2 = dataSource = segment instanceof ImmutableSegment ? segment.getDataSource(column) : dataSourceCache.computeIfAbsent(column, arg_0 -> ((IndexSegment)segment).getDataSource(arg_0));
        assert (dataSource != null);
        DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
        ValueBasedSegmentPruner.ValueCache.CachedValue cachedValue = valueCache.get(eqPredicate, dataSourceMetadata.getDataType());
        BloomFilterReader bloomFilter = dataSource.getBloomFilter();
        return bloomFilter != null && !cachedValue.mightBeContained(bloomFilter);
    }

    private boolean pruneInPredicate(IndexSegment segment, InPredicate inPredicate, Map<String, DataSource> dataSourceCache, ValueBasedSegmentPruner.ValueCache valueCache) {
        DataSource dataSource;
        List values = inPredicate.getValues();
        if (values.size() > this._inPredicateThreshold) {
            return false;
        }
        String column = inPredicate.getLhs().getIdentifier();
        DataSource dataSource2 = dataSource = segment instanceof ImmutableSegment ? segment.getDataSource(column) : dataSourceCache.computeIfAbsent(column, arg_0 -> ((IndexSegment)segment).getDataSource(arg_0));
        assert (dataSource != null);
        DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
        List<ValueBasedSegmentPruner.ValueCache.CachedValue> cachedValues = valueCache.get(inPredicate, dataSourceMetadata.getDataType());
        BloomFilterReader bloomFilter = dataSource.getBloomFilter();
        if (bloomFilter == null) {
            return false;
        }
        for (ValueBasedSegmentPruner.ValueCache.CachedValue value : cachedValues) {
            if (!value.mightBeContained(bloomFilter)) continue;
            return false;
        }
        return true;
    }
}

