/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.pruner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.predicate.EqPredicate;
import org.apache.pinot.common.request.context.predicate.InPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.core.query.pruner.SegmentPruner;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.local.segment.index.readers.bloom.GuavaBloomFilterReaderUtils;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.BloomFilterReader;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.exception.BadQueryRequestException;

public abstract class ValueBasedSegmentPruner
implements SegmentPruner {
    public static final String IN_PREDICATE_THRESHOLD = "inpredicate.threshold";
    protected int _inPredicateThreshold;

    @Override
    public void init(PinotConfiguration config) {
        this._inPredicateThreshold = config.getProperty(IN_PREDICATE_THRESHOLD, 10);
    }

    @Override
    public boolean isApplicableTo(QueryContext query) {
        if (query.getFilter() == null) {
            return false;
        }
        return this.isApplicableToFilter(query.getFilter());
    }

    private boolean isApplicableToFilter(FilterContext filter) {
        switch (filter.getType()) {
            case AND: {
                for (FilterContext child : filter.getChildren()) {
                    if (!this.isApplicableToFilter(child)) continue;
                    return true;
                }
                return false;
            }
            case OR: {
                for (FilterContext child : filter.getChildren()) {
                    if (this.isApplicableToFilter(child)) continue;
                    return false;
                }
                return true;
            }
            case NOT: {
                return false;
            }
            case PREDICATE: {
                return this.isApplicableToPredicate(filter.getPredicate());
            }
        }
        throw new IllegalStateException();
    }

    abstract boolean isApplicableToPredicate(Predicate var1);

    @Override
    public List<IndexSegment> prune(List<IndexSegment> segments, QueryContext query) {
        if (segments.isEmpty()) {
            return segments;
        }
        FilterContext filter = Objects.requireNonNull(query.getFilter());
        ValueCache cachedValues = new ValueCache();
        HashMap<String, DataSource> dataSourceCache = new HashMap<String, DataSource>();
        ArrayList<IndexSegment> selectedSegments = new ArrayList<IndexSegment>(segments.size());
        for (IndexSegment segment : segments) {
            dataSourceCache.clear();
            if (this.pruneSegment(segment, filter, dataSourceCache, cachedValues)) continue;
            selectedSegments.add(segment);
        }
        return selectedSegments;
    }

    protected boolean pruneSegment(IndexSegment segment, FilterContext filter, Map<String, DataSource> dataSourceCache, ValueCache cachedValues) {
        switch (filter.getType()) {
            case AND: {
                for (FilterContext child : filter.getChildren()) {
                    if (!this.pruneSegment(segment, child, dataSourceCache, cachedValues)) continue;
                    return true;
                }
                return false;
            }
            case OR: {
                for (FilterContext child : filter.getChildren()) {
                    if (this.pruneSegment(segment, child, dataSourceCache, cachedValues)) continue;
                    return false;
                }
                return true;
            }
            case NOT: {
                return false;
            }
            case PREDICATE: {
                Predicate predicate = filter.getPredicate();
                if (predicate.getLhs().getType() != ExpressionContext.Type.IDENTIFIER) {
                    return false;
                }
                return this.pruneSegmentWithPredicate(segment, predicate, dataSourceCache, cachedValues);
            }
        }
        throw new IllegalStateException();
    }

    abstract boolean pruneSegmentWithPredicate(IndexSegment var1, Predicate var2, Map<String, DataSource> var3, ValueCache var4);

    protected static Comparable convertValue(String stringValue, FieldSpec.DataType dataType) {
        try {
            return dataType.convertInternal(stringValue);
        }
        catch (Exception e) {
            throw new BadQueryRequestException((Throwable)e);
        }
    }

    protected static class ValueCache {
        private final Map<Predicate, Object> _cache = new IdentityHashMap<Predicate, Object>();

        protected ValueCache() {
        }

        private CachedValue add(EqPredicate pred) {
            CachedValue val = new CachedValue(pred.getValue());
            this._cache.put((Predicate)pred, val);
            return val;
        }

        private List<CachedValue> add(InPredicate pred) {
            ArrayList<CachedValue> vals = new ArrayList<CachedValue>(pred.getValues().size());
            for (String value : pred.getValues()) {
                vals.add(new CachedValue(value));
            }
            this._cache.put((Predicate)pred, vals);
            return vals;
        }

        public CachedValue get(EqPredicate pred, FieldSpec.DataType dt) {
            CachedValue cachedValue = (CachedValue)this._cache.get(pred);
            if (cachedValue == null) {
                cachedValue = this.add(pred);
            }
            cachedValue.ensureDataType(dt);
            return cachedValue;
        }

        public List<CachedValue> get(InPredicate pred, FieldSpec.DataType dt) {
            List<CachedValue> cachedValues = (List<CachedValue>)this._cache.get(pred);
            if (cachedValues == null) {
                cachedValues = this.add(pred);
            }
            for (CachedValue cachedValue : cachedValues) {
                cachedValue.ensureDataType(dt);
            }
            return cachedValues;
        }

        public static class CachedValue {
            private final String _value;
            private boolean _hashed = false;
            private long _hash1;
            private long _hash2;
            private FieldSpec.DataType _dt;
            private Comparable _comparableValue;

            private CachedValue(String value) {
                this._value = value;
            }

            public String getValue() {
                return this._value;
            }

            public Comparable getComparableValue() {
                assert (this._dt != null);
                return this._comparableValue;
            }

            public void ensureDataType(FieldSpec.DataType dt) {
                if (dt != this._dt) {
                    this._dt = dt;
                    this._comparableValue = ValueBasedSegmentPruner.convertValue(this._value, dt);
                    this._hashed = false;
                }
            }

            public boolean mightBeContained(BloomFilterReader bloomFilter) {
                if (!this._hashed) {
                    GuavaBloomFilterReaderUtils.Hash128AsLongs hash128AsLongs = GuavaBloomFilterReaderUtils.hashAsLongs((String)this._comparableValue.toString());
                    this._hash1 = hash128AsLongs.getHash1();
                    this._hash2 = hash128AsLongs.getHash2();
                    this._hashed = true;
                }
                return bloomFilter.mightContain(this._hash1, this._hash2);
            }
        }
    }
}

