/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.util.List;
import java.util.Map;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.query.distinct.table.BigDecimalDistinctTable;
import org.apache.pinot.core.query.distinct.table.BytesDistinctTable;
import org.apache.pinot.core.query.distinct.table.DistinctTable;
import org.apache.pinot.core.query.distinct.table.DoubleDistinctTable;
import org.apache.pinot.core.query.distinct.table.FloatDistinctTable;
import org.apache.pinot.core.query.distinct.table.IntDistinctTable;
import org.apache.pinot.core.query.distinct.table.LongDistinctTable;
import org.apache.pinot.core.query.distinct.table.MultiColumnDistinctTable;
import org.apache.pinot.core.query.distinct.table.StringDistinctTable;
import org.apache.pinot.core.query.reduce.DataTableReducer;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.reduce.ReducerDataSchemaUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.spi.trace.Tracing;

public class DistinctDataTableReducer
implements DataTableReducer {
    private final QueryContext _queryContext;

    public DistinctDataTableReducer(QueryContext queryContext) {
        this._queryContext = queryContext;
    }

    @Override
    public void reduceAndSetResults(String tableName, DataSchema dataSchema, Map<ServerRoutingInstance, DataTable> dataTableMap, BrokerResponseNative brokerResponseNative, DataTableReducerContext reducerContext, BrokerMetrics brokerMetrics) {
        dataSchema = ReducerDataSchemaUtils.canonicalizeDataSchemaForDistinct(this._queryContext, dataSchema);
        int limit = this._queryContext.getLimit();
        if (dataTableMap.isEmpty() || limit == 0) {
            brokerResponseNative.setResultTable(new ResultTable(dataSchema, List.of()));
            return;
        }
        DistinctTable distinctTable = null;
        for (DataTable dataTable : dataTableMap.values()) {
            Tracing.ThreadAccountantOps.sampleAndCheckInterruption();
            if (!(distinctTable == null ? (distinctTable = this.createDistinctTable(dataSchema, dataTable)).isSatisfied() : distinctTable.mergeDataTable(dataTable))) continue;
            break;
        }
        brokerResponseNative.setResultTable(distinctTable.toResultTable());
    }

    private DistinctTable createDistinctTable(DataSchema dataSchema, DataTable dataTable) {
        int limit = this._queryContext.getLimit();
        List<OrderByExpressionContext> orderByExpressions = this._queryContext.getOrderByExpressions();
        if (dataSchema.size() == 1) {
            OrderByExpressionContext orderByExpression = orderByExpressions != null ? orderByExpressions.get(0) : null;
            DataSchema.ColumnDataType columnDataType = dataSchema.getColumnDataType(0);
            switch (columnDataType.getStoredType()) {
                case INT: {
                    return new IntDistinctTable(dataSchema, limit, this._queryContext.isNullHandlingEnabled(), orderByExpression, dataTable);
                }
                case LONG: {
                    return new LongDistinctTable(dataSchema, limit, this._queryContext.isNullHandlingEnabled(), orderByExpression, dataTable);
                }
                case FLOAT: {
                    return new FloatDistinctTable(dataSchema, limit, this._queryContext.isNullHandlingEnabled(), orderByExpression, dataTable);
                }
                case DOUBLE: {
                    return new DoubleDistinctTable(dataSchema, limit, this._queryContext.isNullHandlingEnabled(), orderByExpression, dataTable);
                }
                case BIG_DECIMAL: {
                    return new BigDecimalDistinctTable(dataSchema, limit, this._queryContext.isNullHandlingEnabled(), orderByExpression, dataTable);
                }
                case STRING: {
                    return new StringDistinctTable(dataSchema, limit, this._queryContext.isNullHandlingEnabled(), orderByExpression, dataTable);
                }
                case BYTES: {
                    return new BytesDistinctTable(dataSchema, limit, this._queryContext.isNullHandlingEnabled(), orderByExpression, dataTable);
                }
            }
            throw new IllegalStateException("Unsupported data type: " + columnDataType);
        }
        return new MultiColumnDistinctTable(dataSchema, limit, this._queryContext.isNullHandlingEnabled(), orderByExpressions, dataTable);
    }
}

