/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.config.QueryOptionsUtils;
import org.apache.pinot.core.common.ExplainPlanRowData;
import org.apache.pinot.core.common.ExplainPlanRows;
import org.apache.pinot.core.query.reduce.DataTableReducer;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextUtils;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplainPlanDataTableReducer
implements DataTableReducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExplainPlanDataTableReducer.class);
    public static final String COMBINE = "COMBINE";
    private final QueryContext _queryContext;

    ExplainPlanDataTableReducer(QueryContext queryContext) {
        this._queryContext = queryContext;
    }

    @Override
    public void reduceAndSetResults(String tableName, DataSchema dataSchema, Map<ServerRoutingInstance, DataTable> dataTableMap, BrokerResponseNative brokerResponseNative, DataTableReducerContext reducerContext, BrokerMetrics brokerMetrics) {
        Map<String, String> queryOptions;
        ArrayList<Object[]> reducedRows = new ArrayList<Object[]>();
        this.addBrokerReduceOperation(reducedRows);
        Object[] combinedRow = this.extractCombineNode(dataTableMap);
        if (combinedRow != null) {
            reducedRows.add(combinedRow);
        }
        boolean explainPlanVerbose = (queryOptions = this._queryContext.getQueryOptions()) != null && QueryOptionsUtils.isExplainPlanVerbose(queryOptions);
        List<ExplainPlanRows> explainPlanRowsList = this.extractUniqueExplainPlansAcrossServers(dataTableMap, combinedRow);
        if (!explainPlanVerbose && explainPlanRowsList.size() > 1) {
            explainPlanRowsList = this.chooseBestExplainPlanToUse(explainPlanRowsList);
        }
        for (ExplainPlanRows explainPlanRows : explainPlanRowsList) {
            String numSegmentsExplainString = String.format("PLAN_START(numSegmentsForThisPlan:%d)", explainPlanRows.getNumSegmentsMatchingThisPlan());
            Object[] numSegmentsRow = new Object[]{numSegmentsExplainString, -1, -1};
            reducedRows.add(numSegmentsRow);
            for (ExplainPlanRowData explainPlanRowData : explainPlanRows.getExplainPlanRowData()) {
                Object[] row = new Object[]{explainPlanRowData.getExplainPlanString(), explainPlanRowData.getOperatorId(), explainPlanRowData.getParentId()};
                reducedRows.add(row);
            }
        }
        ResultTable resultTable = new ResultTable(dataSchema, reducedRows);
        brokerResponseNative.setResultTable(resultTable);
    }

    private Object[] extractCombineNode(Map<ServerRoutingInstance, DataTable> dataTableMap) {
        if (dataTableMap.isEmpty()) {
            return null;
        }
        Object[] combineRow = null;
        for (Map.Entry<ServerRoutingInstance, DataTable> entry : dataTableMap.entrySet()) {
            Object[] row;
            String rowName;
            DataTable dataTable = entry.getValue();
            int numRows = dataTable.getNumberOfRows();
            if (numRows <= 0 || !(rowName = (row = SelectionOperatorUtils.extractRowFromDataTable(dataTable, 0))[0].toString()).contains(COMBINE)) continue;
            combineRow = row;
            break;
        }
        return combineRow;
    }

    private List<ExplainPlanRows> extractUniqueExplainPlansAcrossServers(Map<ServerRoutingInstance, DataTable> dataTableMap, Object[] combinedRow) {
        ArrayList<ExplainPlanRows> explainPlanRowsList = new ArrayList<ExplainPlanRows>();
        HashSet<Integer> explainPlanHashCodeSet = new HashSet<Integer>();
        for (Map.Entry<ServerRoutingInstance, DataTable> entry : dataTableMap.entrySet()) {
            DataTable dataTable = entry.getValue();
            int numRows = dataTable.getNumberOfRows();
            ExplainPlanRows explainPlanRows = null;
            for (int rowId = 0; rowId < numRows; ++rowId) {
                Object[] row = SelectionOperatorUtils.extractRowFromDataTable(dataTable, rowId);
                String rowName = row[0].toString();
                if (rowName.contains(COMBINE)) continue;
                if (rowName.contains("PLAN_START(numSegmentsForThisPlan:")) {
                    this.updateExplainPlanRowsList(explainPlanRowsList, explainPlanHashCodeSet, explainPlanRows);
                    explainPlanRows = new ExplainPlanRows();
                    String numSegmentsString = StringUtils.substringBefore((String)StringUtils.substringAfter((String)rowName, (String)"PLAN_START(numSegmentsForThisPlan:"), (String)")");
                    explainPlanRows.setNumSegmentsMatchingThisPlan(Integer.parseInt(numSegmentsString));
                    continue;
                }
                if (explainPlanRows == null) {
                    explainPlanRows = new ExplainPlanRows();
                }
                if (rowName.contains("FILTER_EMPTY")) {
                    explainPlanRows.setHasEmptyFilter(true);
                } else if (rowName.contains("FILTER_MATCH_ENTIRE_SEGMENT")) {
                    explainPlanRows.setHasMatchAllFilter(true);
                } else if (rowName.contains("ALL_SEGMENTS_PRUNED_ON_SERVER")) {
                    explainPlanRows.setHasNoMatchingSegment(true);
                }
                if (combinedRow == null && rowName.contains("ALL_SEGMENTS_PRUNED_ON_SERVER")) {
                    explainPlanRows.getExplainPlanRowData().add(new ExplainPlanRowData(rowName, 2, 1));
                    continue;
                }
                explainPlanRows.getExplainPlanRowData().add(new ExplainPlanRowData(rowName, (Integer)row[1], (Integer)row[2]));
            }
            this.updateExplainPlanRowsList(explainPlanRowsList, explainPlanHashCodeSet, explainPlanRows);
        }
        Collections.sort(explainPlanRowsList);
        return explainPlanRowsList;
    }

    private void updateExplainPlanRowsList(List<ExplainPlanRows> explainPlanRowsList, HashSet<Integer> explainPlanHashCodeSet, ExplainPlanRows explainPlanRows) {
        if (explainPlanRows != null) {
            int explainPlanRowsHashCode = explainPlanRows.hashCode();
            if (!explainPlanHashCodeSet.contains(explainPlanRowsHashCode)) {
                explainPlanRowsList.add(explainPlanRows);
                explainPlanHashCodeSet.add(explainPlanRowsHashCode);
            } else {
                boolean explainPlanMatchFound = false;
                for (ExplainPlanRows planRows : explainPlanRowsList) {
                    if (planRows.hashCode() != explainPlanRowsHashCode || !planRows.equals(explainPlanRows)) continue;
                    int numSegments = planRows.getNumSegmentsMatchingThisPlan();
                    planRows.setNumSegmentsMatchingThisPlan(numSegments += explainPlanRows.getNumSegmentsMatchingThisPlan());
                    explainPlanMatchFound = true;
                    break;
                }
                if (!explainPlanMatchFound) {
                    explainPlanRowsList.add(explainPlanRows);
                }
            }
        }
    }

    private List<ExplainPlanRows> chooseBestExplainPlanToUse(List<ExplainPlanRows> explainPlanRowsList) {
        int maxOtherDepth = -1;
        int maxEmptyFilterDepth = -1;
        int maxMatchAllFilterDepth = -1;
        int maxNoMatchingSegmentDepth = -1;
        int maxOtherIdx = -1;
        int maxEmptyFilterIdx = -1;
        int maxMatchAllFilterIdx = -1;
        int maxNoMatchingSegmentIdx = -1;
        for (int i = 0; i < explainPlanRowsList.size(); ++i) {
            ExplainPlanRows explainPlanRows = explainPlanRowsList.get(i);
            int explainPlanRowsSize = explainPlanRows.getExplainPlanRowData().size();
            if (explainPlanRows.isHasNoMatchingSegment()) {
                if (explainPlanRowsSize <= maxNoMatchingSegmentDepth) continue;
                maxNoMatchingSegmentDepth = explainPlanRowsSize;
                maxNoMatchingSegmentIdx = i;
                continue;
            }
            if (explainPlanRows.isHasEmptyFilter()) {
                if (explainPlanRowsSize <= maxEmptyFilterDepth) continue;
                maxEmptyFilterDepth = explainPlanRowsSize;
                maxEmptyFilterIdx = i;
                continue;
            }
            if (explainPlanRows.isHasMatchAllFilter()) {
                if (explainPlanRowsSize <= maxMatchAllFilterDepth) continue;
                maxMatchAllFilterDepth = explainPlanRowsSize;
                maxMatchAllFilterIdx = i;
                continue;
            }
            if (explainPlanRowsSize <= maxOtherDepth) continue;
            maxOtherDepth = explainPlanRowsSize;
            maxOtherIdx = i;
        }
        if (maxOtherIdx > -1) {
            return Collections.singletonList(explainPlanRowsList.get(maxOtherIdx));
        }
        if (maxMatchAllFilterIdx > -1) {
            return Collections.singletonList(explainPlanRowsList.get(maxMatchAllFilterIdx));
        }
        if (maxEmptyFilterIdx > -1) {
            return Collections.singletonList(explainPlanRowsList.get(maxEmptyFilterIdx));
        }
        return Collections.singletonList(explainPlanRowsList.get(maxNoMatchingSegmentIdx));
    }

    private void addBrokerReduceOperation(List<Object[]> resultRows) {
        HashSet<String> postAggregations = new HashSet<String>();
        QueryContextUtils.collectPostAggregations(this._queryContext, postAggregations);
        StringBuilder stringBuilder = new StringBuilder("BROKER_REDUCE").append('(');
        if (this._queryContext.getHavingFilter() != null) {
            stringBuilder.append("havingFilter").append(':').append(this._queryContext.getHavingFilter().toString()).append(',');
        }
        if (this._queryContext.getOrderByExpressions() != null) {
            stringBuilder.append("sort").append(':').append(this._queryContext.getOrderByExpressions().toString()).append(',');
        }
        stringBuilder.append("limit:").append(this._queryContext.getLimit());
        if (!postAggregations.isEmpty()) {
            stringBuilder.append(",postAggregations:");
            int count = 0;
            for (String func : postAggregations) {
                if (count == postAggregations.size() - 1) {
                    stringBuilder.append(func);
                } else {
                    stringBuilder.append(func).append(", ");
                }
                ++count;
            }
        }
        String brokerReduceNode = stringBuilder.append(')').toString();
        Object[] brokerReduceRow = new Object[]{brokerReduceNode, 1, 0};
        resultRows.add(brokerReduceRow);
    }
}

