/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import org.apache.pinot.core.query.reduce.AggregationDataTableReducer;
import org.apache.pinot.core.query.reduce.DataTableReducer;
import org.apache.pinot.core.query.reduce.DistinctDataTableReducer;
import org.apache.pinot.core.query.reduce.ExplainPlanDataTableReducer;
import org.apache.pinot.core.query.reduce.GroupByDataTableReducer;
import org.apache.pinot.core.query.reduce.SelectionDataTableReducer;
import org.apache.pinot.core.query.reduce.SelectionOnlyStreamingReducer;
import org.apache.pinot.core.query.reduce.StreamingReducer;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextUtils;

public final class ResultReducerFactory {
    private ResultReducerFactory() {
    }

    public static DataTableReducer getResultReducer(QueryContext queryContext) {
        if (queryContext.isExplain()) {
            return new ExplainPlanDataTableReducer(queryContext);
        }
        if (QueryContextUtils.isSelectionQuery(queryContext)) {
            return new SelectionDataTableReducer(queryContext);
        }
        if (QueryContextUtils.isAggregationQuery(queryContext)) {
            if (queryContext.getGroupByExpressions() == null) {
                return new AggregationDataTableReducer(queryContext);
            }
            return new GroupByDataTableReducer(queryContext);
        }
        assert (QueryContextUtils.isDistinctQuery(queryContext));
        return new DistinctDataTableReducer(queryContext);
    }

    public static StreamingReducer getStreamingReducer(QueryContext queryContext) {
        if (!QueryContextUtils.isSelectionQuery(queryContext) || queryContext.getOrderByExpressions() != null) {
            throw new UnsupportedOperationException("Only selection queries are supported");
        }
        return new SelectionOnlyStreamingReducer(queryContext);
    }
}

