/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.query.reduce.DataTableReducer;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorService;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.core.transport.ServerRoutingInstance;

public class SelectionDataTableReducer
implements DataTableReducer {
    private final QueryContext _queryContext;

    public SelectionDataTableReducer(QueryContext queryContext) {
        this._queryContext = queryContext;
    }

    @Override
    public void reduceAndSetResults(String tableName, DataSchema dataSchema, Map<ServerRoutingInstance, DataTable> dataTableMap, BrokerResponseNative brokerResponseNative, DataTableReducerContext reducerContext, BrokerMetrics brokerMetrics) {
        Pair<DataSchema, int[]> pair = SelectionOperatorUtils.getResultTableDataSchemaAndColumnIndices(this._queryContext, dataSchema);
        int limit = this._queryContext.getLimit();
        if (dataTableMap.isEmpty() || limit == 0) {
            brokerResponseNative.setResultTable(new ResultTable((DataSchema)pair.getLeft(), Collections.emptyList()));
            return;
        }
        if (this._queryContext.getOrderByExpressions() == null) {
            List<Object[]> reducedRows = SelectionOperatorUtils.reduceWithoutOrdering(dataTableMap.values(), limit, this._queryContext.isNullHandlingEnabled());
            brokerResponseNative.setResultTable(SelectionOperatorUtils.renderResultTableWithoutOrdering(reducedRows, (DataSchema)pair.getLeft(), (int[])pair.getRight()));
        } else {
            SelectionOperatorService selectionService = new SelectionOperatorService(this._queryContext, (DataSchema)pair.getLeft(), (int[])pair.getRight());
            selectionService.reduceWithOrdering(dataTableMap.values());
            brokerResponseNative.setResultTable(selectionService.renderResultTableWithOrdering());
        }
    }
}

