/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce.filter;

import java.math.BigDecimal;
import java.sql.Timestamp;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluatorProvider;
import org.apache.pinot.core.query.reduce.filter.RowMatcher;
import org.apache.pinot.core.query.reduce.filter.ValueExtractor;
import org.apache.pinot.spi.data.FieldSpec;

public class PredicateRowMatcher
implements RowMatcher {
    private final ValueExtractor _valueExtractor;
    private final FieldSpec.DataType _valueType;
    private final Predicate.Type _predicateType;
    @Nullable
    private final PredicateEvaluator _predicateEvaluator;
    private final boolean _nullHandlingEnabled;

    public PredicateRowMatcher(Predicate predicate, ValueExtractor valueExtractor, boolean nullHandlingEnabled) {
        this._valueExtractor = valueExtractor;
        this._valueType = this._valueExtractor.getColumnDataType().toDataType();
        this._predicateType = predicate.getType();
        this._predicateEvaluator = this._predicateType == Predicate.Type.IS_NULL || this._predicateType == Predicate.Type.IS_NOT_NULL ? null : PredicateEvaluatorProvider.getPredicateEvaluator(predicate, null, this._valueType);
        this._nullHandlingEnabled = nullHandlingEnabled;
    }

    @Override
    public boolean isMatch(Object[] row) {
        Object value = this._valueExtractor.extract(row);
        if (this._predicateType == Predicate.Type.IS_NULL) {
            return value == null;
        }
        if (this._predicateType == Predicate.Type.IS_NOT_NULL) {
            return value != null;
        }
        assert (this._predicateEvaluator != null);
        if (this._nullHandlingEnabled && value == null) {
            return false;
        }
        switch (this._valueType) {
            case INT: {
                return this._predicateEvaluator.applySV((Integer)value);
            }
            case LONG: {
                return this._predicateEvaluator.applySV((Long)value);
            }
            case FLOAT: {
                return this._predicateEvaluator.applySV(((Float)value).floatValue());
            }
            case DOUBLE: {
                return this._predicateEvaluator.applySV((Double)value);
            }
            case BIG_DECIMAL: {
                return this._predicateEvaluator.applySV((BigDecimal)value);
            }
            case BOOLEAN: {
                return this._predicateEvaluator.applySV((Boolean)value != false ? 1 : 0);
            }
            case TIMESTAMP: {
                return this._predicateEvaluator.applySV(((Timestamp)value).getTime());
            }
            case STRING: {
                return this._predicateEvaluator.applySV((String)value);
            }
            case BYTES: {
                return this._predicateEvaluator.applySV((byte[])value);
            }
        }
        throw new IllegalStateException();
    }
}

