/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.request.context.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pinot.common.request.DataSource;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.request.context.RequestContextUtils;
import org.apache.pinot.common.utils.config.QueryOptionsUtils;
import org.apache.pinot.core.query.request.context.ExplainMode;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.sql.parsers.CalciteSqlParser;

public class QueryContextConverterUtils {
    private QueryContextConverterUtils() {
    }

    public static QueryContext getQueryContext(String query) {
        return QueryContextConverterUtils.getQueryContext(CalciteSqlParser.compileToPinotQuery((String)query));
    }

    public static QueryContext getQueryContext(PinotQuery pinotQuery) {
        Function function;
        DataSource dataSource = pinotQuery.getDataSource();
        String tableName = dataSource.getTableName();
        QueryContext subquery = null;
        if (dataSource.getSubquery() != null) {
            subquery = QueryContextConverterUtils.getQueryContext(dataSource.getSubquery());
        }
        boolean distinct = false;
        List selectList = pinotQuery.getSelectList();
        if (selectList.size() == 1 && (function = ((Expression)selectList.get(0)).getFunctionCall()) != null && function.getOperator().equals("distinct")) {
            distinct = true;
            selectList = function.getOperands();
        }
        ArrayList<String> aliasList = new ArrayList<String>(selectList.size());
        ArrayList<ExpressionContext> selectExpressions = new ArrayList<ExpressionContext>(selectList.size());
        for (Expression thriftExpression : selectList) {
            Expression expressionWithoutAlias;
            Function function2 = thriftExpression.getFunctionCall();
            if (function2 != null && function2.getOperator().equals("as")) {
                List operands = function2.getOperands();
                expressionWithoutAlias = (Expression)operands.get(0);
                aliasList.add(((Expression)operands.get(1)).getIdentifier().getName());
            } else {
                expressionWithoutAlias = thriftExpression;
                aliasList.add(null);
            }
            selectExpressions.add(RequestContextUtils.getExpression((Expression)expressionWithoutAlias));
        }
        FilterContext filter = null;
        Expression filterExpression = pinotQuery.getFilterExpression();
        if (filterExpression != null && (filter = RequestContextUtils.getFilter((Expression)filterExpression)).isConstantTrue()) {
            filter = null;
        }
        ArrayList<ExpressionContext> groupByExpressions = null;
        List groupByList = pinotQuery.getGroupByList();
        if (CollectionUtils.isNotEmpty((Collection)groupByList)) {
            groupByExpressions = new ArrayList<ExpressionContext>(groupByList.size());
            for (Expression thriftExpression : groupByList) {
                groupByExpressions.add(RequestContextUtils.getExpression((Expression)thriftExpression));
            }
        }
        ArrayList<OrderByExpressionContext> orderByExpressions = null;
        List orderByList = pinotQuery.getOrderByList();
        if (CollectionUtils.isNotEmpty((Collection)orderByList)) {
            orderByExpressions = new ArrayList<OrderByExpressionContext>(orderByList.size());
            HashSet<Expression> seen = new HashSet<Expression>();
            for (Expression orderBy : orderByList) {
                Boolean isNullsLast = CalciteSqlParser.isNullsLast((Expression)orderBy);
                boolean isAsc = CalciteSqlParser.isAsc((Expression)orderBy, (Boolean)isNullsLast);
                Expression orderByFunctionsRemoved = CalciteSqlParser.removeOrderByFunctions((Expression)orderBy);
                if (!seen.add(orderByFunctionsRemoved)) continue;
                ExpressionContext expressionContext = RequestContextUtils.getExpression((Expression)orderByFunctionsRemoved);
                if (isNullsLast != null) {
                    orderByExpressions.add(new OrderByExpressionContext(expressionContext, isAsc, isNullsLast.booleanValue()));
                    continue;
                }
                orderByExpressions.add(new OrderByExpressionContext(expressionContext, isAsc));
            }
        }
        FilterContext havingFilter = null;
        Expression havingExpression = pinotQuery.getHavingExpression();
        if (havingExpression != null && (havingFilter = RequestContextUtils.getFilter((Expression)havingExpression)).isConstantTrue()) {
            havingFilter = null;
        }
        HashMap<ExpressionContext, ExpressionContext> expressionContextOverrideHints = new HashMap<ExpressionContext, ExpressionContext>();
        Map expressionOverrideHints = pinotQuery.getExpressionOverrideHints();
        if (expressionOverrideHints != null) {
            for (Map.Entry entry : expressionOverrideHints.entrySet()) {
                expressionContextOverrideHints.put(RequestContextUtils.getExpression((Expression)((Expression)entry.getKey())), RequestContextUtils.getExpression((Expression)((Expression)entry.getValue())));
            }
        }
        ExplainMode explainMode = !pinotQuery.isExplain() ? ExplainMode.NONE : (QueryContextConverterUtils.isMultiStage(pinotQuery) ? ExplainMode.NODE : ExplainMode.DESCRIPTION);
        return new QueryContext.Builder().setTableName(tableName).setSubquery(subquery).setSelectExpressions(selectExpressions).setDistinct(distinct).setAliasList(aliasList).setFilter(filter).setGroupByExpressions(groupByExpressions).setOrderByExpressions(orderByExpressions).setHavingFilter(havingFilter).setLimit(pinotQuery.getLimit()).setOffset(pinotQuery.getOffset()).setQueryOptions(pinotQuery.getQueryOptions()).setExpressionOverrideHints(expressionContextOverrideHints).setExplain(explainMode).build();
    }

    private static boolean isMultiStage(PinotQuery pinotQuery) {
        Map queryOptions = pinotQuery.getQueryOptions();
        return queryOptions != null && QueryOptionsUtils.isUseMultistageEngine((Map)queryOptions);
    }
}

