/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.scheduler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.core.query.scheduler.OutOfCapacityException;
import org.apache.pinot.core.query.scheduler.SchedulerGroup;
import org.apache.pinot.core.query.scheduler.SchedulerGroupFactory;
import org.apache.pinot.core.query.scheduler.SchedulerGroupMapper;
import org.apache.pinot.core.query.scheduler.SchedulerPriorityQueue;
import org.apache.pinot.core.query.scheduler.SchedulerQueryContext;
import org.apache.pinot.core.query.scheduler.resources.ResourceManager;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLevelPriorityQueue
implements SchedulerPriorityQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiLevelPriorityQueue.class);
    public static final String QUERY_DEADLINE_SECONDS_KEY = "query_deadline_seconds";
    public static final String MAX_PENDING_PER_GROUP_KEY = "max_pending_per_group";
    public static final String QUEUE_WAKEUP_MICROS = "queue_wakeup_micros";
    private static final int DEFAULT_WAKEUP_MICROS = 1000;
    private static int _wakeUpTimeMicros = 1000;
    private final int _maxPendingPerGroup;
    private final Map<String, SchedulerGroup> _schedulerGroups = new HashMap<String, SchedulerGroup>();
    private final Lock _queueLock = new ReentrantLock();
    private final Condition _queryReaderCondition = this._queueLock.newCondition();
    private final ResourceManager _resourceManager;
    private final SchedulerGroupMapper _groupSelector;
    private final int _queryDeadlineMillis;
    private final SchedulerGroupFactory _groupFactory;
    private final PinotConfiguration _config;

    public MultiLevelPriorityQueue(PinotConfiguration config, ResourceManager resourceManager, SchedulerGroupFactory groupFactory, SchedulerGroupMapper groupMapper) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)resourceManager);
        Preconditions.checkNotNull((Object)groupFactory);
        Preconditions.checkNotNull((Object)groupMapper);
        this._queryDeadlineMillis = config.getProperty(QUERY_DEADLINE_SECONDS_KEY, 30) * 1000;
        _wakeUpTimeMicros = config.getProperty(QUEUE_WAKEUP_MICROS, 1000);
        this._maxPendingPerGroup = config.getProperty(MAX_PENDING_PER_GROUP_KEY, 10);
        this._config = config;
        this._resourceManager = resourceManager;
        this._groupFactory = groupFactory;
        this._groupSelector = groupMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(SchedulerQueryContext query) throws OutOfCapacityException {
        Preconditions.checkNotNull((Object)query);
        this._queueLock.lock();
        String groupName = this._groupSelector.getSchedulerGroupName(query);
        try {
            SchedulerGroup groupContext = this.getOrCreateGroupContext(groupName);
            this.checkGroupHasCapacity(groupContext);
            query.setSchedulerGroupContext(groupContext);
            groupContext.addLast(query);
            this._queryReaderCondition.signal();
        }
        finally {
            this._queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public SchedulerQueryContext take() {
        this._queueLock.lock();
        try {
            SchedulerQueryContext schedulerQueryContext;
            while ((schedulerQueryContext = this.takeNextInternal()) == null) {
                try {
                    this._queryReaderCondition.await(_wakeUpTimeMicros, TimeUnit.MICROSECONDS);
                }
                catch (InterruptedException e) {
                    SchedulerQueryContext schedulerQueryContext2 = null;
                    this._queueLock.unlock();
                    return schedulerQueryContext2;
                }
            }
            SchedulerQueryContext schedulerQueryContext3 = schedulerQueryContext;
            return schedulerQueryContext3;
        }
        finally {
            this._queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SchedulerQueryContext> drain() {
        ArrayList<SchedulerQueryContext> pending = new ArrayList<SchedulerQueryContext>();
        this._queueLock.lock();
        try {
            for (Map.Entry<String, SchedulerGroup> groupEntry : this._schedulerGroups.entrySet()) {
                SchedulerGroup group = groupEntry.getValue();
                while (!group.isEmpty()) {
                    pending.add(group.removeFirst());
                }
            }
        }
        finally {
            this._queueLock.unlock();
        }
        return pending;
    }

    private SchedulerQueryContext takeNextInternal() {
        SchedulerGroup currentWinnerGroup = null;
        long startTime = System.nanoTime();
        StringBuilder sb = new StringBuilder("SchedulerInfo:");
        long deadlineEpochMillis = this.currentTimeMillis() - (long)this._queryDeadlineMillis;
        for (Map.Entry<String, SchedulerGroup> groupInfoEntry : this._schedulerGroups.entrySet()) {
            SchedulerGroup group = groupInfoEntry.getValue();
            if (LOGGER.isDebugEnabled()) {
                sb.append(group.toString());
            }
            group.trimExpired(deadlineEpochMillis);
            if (group.isEmpty() || !this._resourceManager.canSchedule(group)) continue;
            if (currentWinnerGroup == null) {
                currentWinnerGroup = group;
                continue;
            }
            int comparison = group.compareTo(currentWinnerGroup);
            if (comparison < 0) {
                if (currentWinnerGroup.totalReservedThreads() <= this._resourceManager.getTableThreadsSoftLimit() || group.totalReservedThreads() >= this._resourceManager.getTableThreadsSoftLimit()) continue;
                currentWinnerGroup = group;
                continue;
            }
            if (comparison < 0 || group.totalReservedThreads() >= this._resourceManager.getTableThreadsSoftLimit() && group.totalReservedThreads() >= currentWinnerGroup.totalReservedThreads()) continue;
            currentWinnerGroup = group;
        }
        SchedulerQueryContext query = null;
        if (currentWinnerGroup != null) {
            ServerQueryRequest queryRequest = currentWinnerGroup.peekFirst().getQueryRequest();
            if (LOGGER.isDebugEnabled()) {
                sb.append(" Winner: " + currentWinnerGroup.name() + ": [" + queryRequest.getTimerContext().getQueryArrivalTimeMs() + "," + queryRequest.getRequestId() + "," + queryRequest.getSegmentsToQuery().size() + "," + startTime + "]");
            }
            query = currentWinnerGroup.removeFirst();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sb.toString());
        }
        return query;
    }

    private void checkGroupHasCapacity(SchedulerGroup groupContext) throws OutOfCapacityException {
        if (groupContext.numPending() >= this._maxPendingPerGroup && groupContext.totalReservedThreads() >= this._resourceManager.getTableThreadsHardLimit()) {
            throw new OutOfCapacityException("SchedulerGroup " + groupContext.name() + " is out of capacity. numPending: " + groupContext.numPending() + ", maxPending: " + this._maxPendingPerGroup + ", reservedThreads: " + groupContext.totalReservedThreads() + " threadsHardLimit: " + this._resourceManager.getTableThreadsHardLimit());
        }
    }

    private SchedulerGroup getOrCreateGroupContext(String groupName) {
        SchedulerGroup groupContext = this._schedulerGroups.get(groupName);
        if (groupContext == null) {
            groupContext = this._groupFactory.create(this._config, groupName);
            this._schedulerGroups.put(groupName, groupContext);
        }
        return groupContext;
    }

    private long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @VisibleForTesting
    long getWakeupTimeMicros() {
        return _wakeUpTimeMicros;
    }
}

