/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.scheduler;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.LongAccumulator;
import javax.annotation.Nullable;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.core.query.executor.QueryExecutor;
import org.apache.pinot.core.query.scheduler.BinaryWorkloadScheduler;
import org.apache.pinot.core.query.scheduler.QueryScheduler;
import org.apache.pinot.core.query.scheduler.fcfs.BoundedFCFSScheduler;
import org.apache.pinot.core.query.scheduler.fcfs.FCFSQueryScheduler;
import org.apache.pinot.core.query.scheduler.tokenbucket.TokenPriorityScheduler;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.plugin.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuerySchedulerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuerySchedulerFactory.class);
    public static final String FCFS_ALGORITHM = "fcfs";
    public static final String TOKEN_BUCKET_ALGORITHM = "tokenbucket";
    public static final String BOUNDED_FCFS_ALGORITHM = "bounded_fcfs";
    public static final String BINARY_WORKLOAD_ALGORITHM = "binary_workload";
    public static final String ALGORITHM_NAME_CONFIG_KEY = "name";
    public static final String DEFAULT_QUERY_SCHEDULER_ALGORITHM = "fcfs";

    private QuerySchedulerFactory() {
    }

    public static QueryScheduler create(PinotConfiguration schedulerConfig, QueryExecutor queryExecutor, ServerMetrics serverMetrics, LongAccumulator latestQueryTime) {
        QueryScheduler scheduler;
        Preconditions.checkNotNull((Object)schedulerConfig);
        Preconditions.checkNotNull((Object)queryExecutor);
        String schedulerName = schedulerConfig.getProperty(ALGORITHM_NAME_CONFIG_KEY, "fcfs");
        switch (schedulerName.toLowerCase()) {
            case "fcfs": {
                scheduler = new FCFSQueryScheduler(schedulerConfig, queryExecutor, serverMetrics, latestQueryTime);
                break;
            }
            case "tokenbucket": {
                scheduler = TokenPriorityScheduler.create(schedulerConfig, queryExecutor, serverMetrics, latestQueryTime);
                break;
            }
            case "bounded_fcfs": {
                scheduler = BoundedFCFSScheduler.create(schedulerConfig, queryExecutor, serverMetrics, latestQueryTime);
                break;
            }
            case "binary_workload": {
                scheduler = new BinaryWorkloadScheduler(schedulerConfig, queryExecutor, serverMetrics, latestQueryTime);
                break;
            }
            default: {
                scheduler = QuerySchedulerFactory.getQuerySchedulerByClassName(schedulerName, schedulerConfig, queryExecutor, serverMetrics, latestQueryTime);
            }
        }
        if (scheduler != null) {
            LOGGER.info("Using {} scheduler", (Object)scheduler.name());
            return scheduler;
        }
        LOGGER.warn("Scheduler {} not found. Using default FCFS query scheduler", (Object)schedulerName);
        return new FCFSQueryScheduler(schedulerConfig, queryExecutor, serverMetrics, latestQueryTime);
    }

    @Nullable
    private static QueryScheduler getQuerySchedulerByClassName(String className, PinotConfiguration schedulerConfig, QueryExecutor queryExecutor, ServerMetrics serverMetrics, LongAccumulator latestQueryTime) {
        try {
            Constructor constructor = PluginManager.get().loadClass(className).getDeclaredConstructor(PinotConfiguration.class, QueryExecutor.class, ServerMetrics.class, LongAccumulator.class);
            constructor.setAccessible(true);
            return (QueryScheduler)constructor.newInstance(schedulerConfig, queryExecutor, serverMetrics, latestQueryTime);
        }
        catch (Exception e) {
            LOGGER.error("Failed to instantiate scheduler class by name: {}", (Object)className, (Object)e);
            return null;
        }
    }
}

