/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.scheduler;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.core.query.scheduler.OutOfCapacityException;
import org.apache.pinot.core.query.scheduler.SchedulerGroup;
import org.apache.pinot.core.query.scheduler.SchedulerQueryContext;
import org.apache.pinot.core.query.scheduler.fcfs.FCFSSchedulerGroup;
import org.apache.pinot.core.query.scheduler.resources.ResourceManager;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecondaryWorkloadQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecondaryWorkloadQueue.class);
    private static final String SECONDARY_WORKLOAD_GROUP_NAME = "Secondary";
    public static final String SECONDARY_QUEUE_QUERY_TIMEOUT = "binarywlm.secondaryQueueQueryTimeout";
    private static final int DEFAULT_SECONDARY_QUEUE_QUERY_TIMEOUT_SEC = 40;
    public static final String MAX_PENDING_SECONDARY_QUERIES = "binarywlm.maxPendingSecondaryQueries";
    private static final int DEFAULT_MAX_PENDING_SECONDARY_QUERIES = 20;
    public static final String QUEUE_WAKEUP_MS = "binarywlm.queueWakeupMs";
    private static final int DEFAULT_WAKEUP_MS = 1;
    private static int _wakeUpTimeMs;
    private final int _maxPendingPerGroup;
    private final SchedulerGroup _schedulerGroup;
    private final Lock _queueLock = new ReentrantLock();
    private final Condition _queryReaderCondition = this._queueLock.newCondition();
    private final ResourceManager _resourceManager;
    private final int _queryDeadlineMs;

    public SecondaryWorkloadQueue(PinotConfiguration config, ResourceManager resourceManager) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)resourceManager);
        this._queryDeadlineMs = config.getProperty(SECONDARY_QUEUE_QUERY_TIMEOUT, 40) * 1000;
        _wakeUpTimeMs = config.getProperty(QUEUE_WAKEUP_MS, 1);
        this._maxPendingPerGroup = config.getProperty(MAX_PENDING_SECONDARY_QUERIES, 20);
        LOGGER.info("queryDeadlineMs={}, wakeupTimeMs={},maxPendingPerGroup={}", new Object[]{this._queryDeadlineMs, _wakeUpTimeMs, this._maxPendingPerGroup});
        this._schedulerGroup = new FCFSSchedulerGroup(SECONDARY_WORKLOAD_GROUP_NAME);
        this._resourceManager = resourceManager;
    }

    public void put(SchedulerQueryContext query) throws OutOfCapacityException {
        Preconditions.checkNotNull((Object)query);
        this._queueLock.lock();
        try {
            this.checkSchedulerGroupCapacity(query);
            query.setSchedulerGroupContext(this._schedulerGroup);
            this._schedulerGroup.addLast(query);
            this._queryReaderCondition.signal();
        }
        finally {
            this._queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SchedulerQueryContext take() {
        this._queueLock.lock();
        try {
            SchedulerQueryContext schedulerQueryContext;
            while ((schedulerQueryContext = this.takeNextInternal()) == null) {
                try {
                    this._queryReaderCondition.await(_wakeUpTimeMs, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    SchedulerQueryContext schedulerQueryContext2 = null;
                    this._queueLock.unlock();
                    return schedulerQueryContext2;
                }
            }
            SchedulerQueryContext schedulerQueryContext3 = schedulerQueryContext;
            return schedulerQueryContext3;
        }
        finally {
            this._queueLock.unlock();
        }
    }

    public List<SchedulerQueryContext> drain() {
        ArrayList<SchedulerQueryContext> pending = new ArrayList<SchedulerQueryContext>();
        this._queueLock.lock();
        try {
            while (!this._schedulerGroup.isEmpty()) {
                pending.add(this._schedulerGroup.removeFirst());
            }
        }
        finally {
            this._queueLock.unlock();
        }
        return pending;
    }

    private SchedulerQueryContext takeNextInternal() {
        long startTimeMs = System.currentTimeMillis();
        long deadlineEpochMillis = startTimeMs - (long)this._queryDeadlineMs;
        this._schedulerGroup.trimExpired(deadlineEpochMillis);
        if (this._schedulerGroup.isEmpty() || !this._resourceManager.canSchedule(this._schedulerGroup)) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("SchedulerInfo:");
            sb.append(this._schedulerGroup.toString());
            ServerQueryRequest queryRequest = this._schedulerGroup.peekFirst().getQueryRequest();
            sb.append(" Group: " + this._schedulerGroup.name() + ": [" + queryRequest.getTimerContext().getQueryArrivalTimeMs() + "," + queryRequest.getRequestId() + "," + queryRequest.getSegmentsToQuery().size() + "," + startTimeMs + "]");
            LOGGER.debug(sb.toString());
        }
        return this._schedulerGroup.removeFirst();
    }

    private void checkSchedulerGroupCapacity(SchedulerQueryContext query) throws OutOfCapacityException {
        if (this._schedulerGroup.numPending() >= this._maxPendingPerGroup && this._schedulerGroup.totalReservedThreads() >= this._resourceManager.getTableThreadsHardLimit()) {
            throw new OutOfCapacityException("SchedulerGroup " + this._schedulerGroup.name() + " is out of capacity. numPending: " + this._schedulerGroup.numPending() + ", maxPending: " + this._maxPendingPerGroup + ", reservedThreads: " + this._schedulerGroup.totalReservedThreads() + " threadsHardLimit: " + this._resourceManager.getTableThreadsHardLimit());
        }
    }
}

