/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.scheduler.resources;

import com.google.common.base.Preconditions;
import java.util.concurrent.Executor;
import org.apache.pinot.common.utils.config.QueryOptionsUtils;
import org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.core.query.scheduler.SchedulerGroupAccountant;
import org.apache.pinot.core.query.scheduler.resources.BoundedAccountingExecutor;
import org.apache.pinot.core.query.scheduler.resources.QueryExecutorService;
import org.apache.pinot.core.query.scheduler.resources.ResourceLimitPolicy;
import org.apache.pinot.core.query.scheduler.resources.ResourceManager;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryWorkloadResourceManager
extends ResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinaryWorkloadResourceManager.class);
    private final ResourceLimitPolicy _secondaryWorkloadPolicy;

    public BinaryWorkloadResourceManager(PinotConfiguration config) {
        super(config);
        this._secondaryWorkloadPolicy = new ResourceLimitPolicy(config, this._numQueryWorkerThreads);
    }

    @Override
    public QueryExecutorService getExecutorService(ServerQueryRequest query, SchedulerGroupAccountant accountant) {
        if (!QueryOptionsUtils.isSecondaryWorkload(query.getQueryContext().getQueryOptions())) {
            return this.getPrimaryWorkloadExecutorService();
        }
        return this.getSecondaryWorkloadExecutorService(query, accountant);
    }

    @Override
    public int getTableThreadsHardLimit() {
        return this._secondaryWorkloadPolicy.getTableThreadsHardLimit();
    }

    @Override
    public int getTableThreadsSoftLimit() {
        return this._secondaryWorkloadPolicy.getTableThreadsSoftLimit();
    }

    private QueryExecutorService getPrimaryWorkloadExecutorService() {
        return new QueryExecutorService(){

            @Override
            public void execute(Runnable command) {
                BinaryWorkloadResourceManager.this._queryWorkers.submit(command);
            }
        };
    }

    private QueryExecutorService getSecondaryWorkloadExecutorService(ServerQueryRequest query, SchedulerGroupAccountant accountant) {
        int numSegments = query.getSegmentsToQuery().size();
        int queryThreadLimit = Math.max(1, Math.min(this._secondaryWorkloadPolicy.getMaxThreadsPerQuery(), numSegments));
        int spareThreads = this._secondaryWorkloadPolicy.getTableThreadsHardLimit() - accountant.totalReservedThreads();
        if (spareThreads <= 0) {
            LOGGER.warn("UNEXPECTED: Attempt to schedule query uses more than the configured hard limit on threads");
            spareThreads = 1;
        } else {
            spareThreads = Math.min(spareThreads, queryThreadLimit);
        }
        Preconditions.checkState((spareThreads >= 1 ? 1 : 0) != 0);
        accountant.addReservedThreads(spareThreads);
        return new BoundedAccountingExecutor((Executor)this._queryWorkers, spareThreads, accountant);
    }
}

