/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.selection;

import java.util.Collection;
import java.util.LinkedList;
import java.util.PriorityQueue;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.core.query.utils.OrderByComparatorFactory;
import org.apache.pinot.spi.trace.Tracing;
import org.roaringbitmap.RoaringBitmap;

public class SelectionOperatorService {
    private final QueryContext _queryContext;
    private final DataSchema _dataSchema;
    private final int[] _columnIndices;
    private final int _offset;
    private final int _numRowsToKeep;
    private final PriorityQueue<Object[]> _rows;

    public SelectionOperatorService(QueryContext queryContext, DataSchema dataSchema, int[] columnIndices) {
        this._queryContext = queryContext;
        this._dataSchema = dataSchema;
        this._columnIndices = columnIndices;
        this._offset = queryContext.getOffset();
        this._numRowsToKeep = this._offset + queryContext.getLimit();
        assert (queryContext.getOrderByExpressions() != null);
        this._rows = new PriorityQueue<Object[]>(Math.min(this._numRowsToKeep, 10000), OrderByComparatorFactory.getComparator(queryContext.getOrderByExpressions(), this._queryContext.isNullHandlingEnabled()).reversed());
    }

    public void reduceWithOrdering(Collection<DataTable> dataTables) {
        for (DataTable dataTable : dataTables) {
            int numRows = dataTable.getNumberOfRows();
            if (this._queryContext.isNullHandlingEnabled()) {
                RoaringBitmap[] nullBitmaps = new RoaringBitmap[dataTable.getDataSchema().size()];
                for (int colId = 0; colId < nullBitmaps.length; ++colId) {
                    nullBitmaps[colId] = dataTable.getNullRowIds(colId);
                }
                for (int rowId = 0; rowId < numRows; ++rowId) {
                    Object[] row = SelectionOperatorUtils.extractRowFromDataTable(dataTable, rowId);
                    for (int colId = 0; colId < nullBitmaps.length; ++colId) {
                        if (nullBitmaps[colId] == null || !nullBitmaps[colId].contains(rowId)) continue;
                        row[colId] = null;
                    }
                    SelectionOperatorUtils.addToPriorityQueue(row, this._rows, this._numRowsToKeep);
                    Tracing.ThreadAccountantOps.sampleAndCheckInterruptionPeriodically((int)rowId);
                }
                continue;
            }
            for (int rowId = 0; rowId < numRows; ++rowId) {
                Object[] row = SelectionOperatorUtils.extractRowFromDataTable(dataTable, rowId);
                SelectionOperatorUtils.addToPriorityQueue(row, this._rows, this._numRowsToKeep);
                Tracing.ThreadAccountantOps.sampleAndCheckInterruptionPeriodically((int)rowId);
            }
        }
    }

    public ResultTable renderResultTableWithOrdering() {
        LinkedList<Object[]> resultRows = new LinkedList<Object[]>();
        DataSchema.ColumnDataType[] columnDataTypes = this._dataSchema.getColumnDataTypes();
        int numColumns = columnDataTypes.length;
        while (this._rows.size() > this._offset) {
            Object[] row = this._rows.poll();
            assert (row != null);
            Object[] resultRow = new Object[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                Object value = row[this._columnIndices[i]];
                if (value == null) continue;
                resultRow[i] = columnDataTypes[i].convertAndFormat(value);
            }
            resultRows.addFirst(resultRow);
        }
        return new ResultTable(this._dataSchema, resultRows);
    }
}

