/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.selection;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.common.datatable.DataTableBuilderFactory;
import org.apache.pinot.core.operator.blocks.results.SelectionResultsBlock;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.trace.Tracing;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.RoaringBitmap;

public class SelectionOperatorUtils {
    public static final ExpressionContext IDENTIFIER_STAR = ExpressionContext.forIdentifier((String)"*");
    public static final int MAX_ROW_HOLDER_INITIAL_CAPACITY = 10000;

    private SelectionOperatorUtils() {
    }

    public static List<ExpressionContext> extractExpressions(QueryContext queryContext, IndexSegment indexSegment) {
        List<ExpressionContext> selectExpressions;
        HashSet<ExpressionContext> expressionSet = new HashSet<ExpressionContext>();
        ArrayList<ExpressionContext> expressions = new ArrayList<ExpressionContext>();
        List<OrderByExpressionContext> orderByExpressions = queryContext.getOrderByExpressions();
        if (orderByExpressions != null && queryContext.getLimit() > 0) {
            for (OrderByExpressionContext orderByExpression : orderByExpressions) {
                ExpressionContext expression = orderByExpression.getExpression();
                expressionSet.add(expression);
                expressions.add(expression);
            }
        }
        if ((selectExpressions = queryContext.getSelectExpressions()).size() == 1 && selectExpressions.get(0).equals((Object)IDENTIFIER_STAR)) {
            Set allColumns = indexSegment.getColumnNames();
            ArrayList<String> selectColumns = new ArrayList<String>(allColumns.size());
            for (String column : allColumns) {
                if (column.charAt(0) == '$') continue;
                selectColumns.add(column);
            }
            selectColumns.sort(null);
            for (String column : selectColumns) {
                ExpressionContext expression = ExpressionContext.forIdentifier((String)column);
                if (expressionSet.contains(expression)) continue;
                expressions.add(expression);
            }
        } else {
            for (ExpressionContext selectExpression : selectExpressions) {
                if (!expressionSet.add(selectExpression)) continue;
                expressions.add(selectExpression);
            }
        }
        return expressions;
    }

    public static List<String> getSelectionColumns(QueryContext queryContext, DataSchema dataSchema) {
        List<ExpressionContext> selectExpressions = queryContext.getSelectExpressions();
        int numSelectExpressions = selectExpressions.size();
        if (numSelectExpressions == 1 && selectExpressions.get(0).equals((Object)IDENTIFIER_STAR)) {
            String[] columnNames = dataSchema.getColumnNames();
            int numColumns = columnNames.length;
            if (numColumns == 1 && columnNames[0].equals("*")) {
                return new ArrayList<String>(Collections.singletonList("*"));
            }
            List<OrderByExpressionContext> orderByExpressions = queryContext.getOrderByExpressions();
            if (orderByExpressions == null || queryContext.getLimit() == 0) {
                return Arrays.asList(columnNames);
            }
            ArrayList<String> allColumns = new ArrayList<String>(numColumns);
            for (String column : columnNames) {
                if (column.indexOf(40) != -1) continue;
                allColumns.add(column);
            }
            allColumns.sort(null);
            return allColumns;
        }
        ArrayList<String> columns = new ArrayList<String>(numSelectExpressions);
        for (ExpressionContext selectExpression : selectExpressions) {
            columns.add(selectExpression.toString());
        }
        return columns;
    }

    public static Pair<DataSchema, int[]> getResultTableDataSchemaAndColumnIndices(QueryContext queryContext, DataSchema dataSchema) {
        List<ExpressionContext> selectExpressions = queryContext.getSelectExpressions();
        int numSelectExpressions = selectExpressions.size();
        DataSchema.ColumnDataType[] columnDataTypesInDataSchema = dataSchema.getColumnDataTypes();
        int numColumnsInDataSchema = columnDataTypesInDataSchema.length;
        List<OrderByExpressionContext> orderByExpressions = queryContext.getOrderByExpressions();
        if (orderByExpressions == null || queryContext.getLimit() == 0) {
            if (numSelectExpressions == 1 && selectExpressions.get(0).equals((Object)IDENTIFIER_STAR)) {
                int[] columnIndices = new int[numColumnsInDataSchema];
                for (int i = 0; i < numColumnsInDataSchema; ++i) {
                    columnIndices[i] = i;
                }
                return Pair.of((Object)dataSchema, (Object)columnIndices);
            }
            if (numSelectExpressions == numColumnsInDataSchema) {
                String[] columnNames = new String[numSelectExpressions];
                int[] columnIndices = new int[numSelectExpressions];
                for (int i = 0; i < numSelectExpressions; ++i) {
                    columnNames[i] = selectExpressions.get(i).toString();
                    columnIndices[i] = i;
                }
                return Pair.of((Object)new DataSchema(columnNames, columnDataTypesInDataSchema), (Object)columnIndices);
            }
            Object2IntOpenHashMap expressionIndexMap = new Object2IntOpenHashMap(numColumnsInDataSchema);
            for (ExpressionContext selectExpression : selectExpressions) {
                expressionIndexMap.putIfAbsent((Object)selectExpression, expressionIndexMap.size());
            }
            Preconditions.checkState((expressionIndexMap.size() == numColumnsInDataSchema ? 1 : 0) != 0, (String)"BUG: Expect same number of deduped columns in SELECT clause and in data schema, got %s before dedup and %s after dedup in SELECT clause, %s in data schema", (Object)numSelectExpressions, (Object)expressionIndexMap.size(), (Object)numColumnsInDataSchema);
            String[] columnNames = new String[numSelectExpressions];
            DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numSelectExpressions];
            int[] columnIndices = new int[numSelectExpressions];
            for (int i = 0; i < numSelectExpressions; ++i) {
                ExpressionContext selectExpression = selectExpressions.get(i);
                int columnIndex = expressionIndexMap.getInt((Object)selectExpression);
                columnNames[i] = selectExpression.toString();
                columnDataTypes[i] = columnDataTypesInDataSchema[columnIndex];
                columnIndices[i] = columnIndex;
            }
            return Pair.of((Object)new DataSchema(columnNames, columnDataTypes), (Object)columnIndices);
        }
        if (numSelectExpressions == 1 && selectExpressions.get(0).equals((Object)IDENTIFIER_STAR)) {
            String[] columnNamesInDataSchema = dataSchema.getColumnNames();
            ArrayList<Integer> columnIndexList = new ArrayList<Integer>(columnNamesInDataSchema.length);
            for (int i = 0; i < columnNamesInDataSchema.length; ++i) {
                if (columnNamesInDataSchema[i].indexOf(40) != -1) continue;
                columnIndexList.add(i);
            }
            columnIndexList.sort(Comparator.comparing(o -> columnNamesInDataSchema[o]));
            int numColumns = columnIndexList.size();
            String[] columnNames = new String[numColumns];
            DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numColumns];
            int[] columnIndices = new int[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                int columnIndex = (Integer)columnIndexList.get(i);
                columnNames[i] = columnNamesInDataSchema[columnIndex];
                columnDataTypes[i] = columnDataTypesInDataSchema[columnIndex];
                columnIndices[i] = columnIndex;
            }
            return Pair.of((Object)new DataSchema(columnNames, columnDataTypes), (Object)columnIndices);
        }
        Object2IntOpenHashMap expressionIndexMap = new Object2IntOpenHashMap(numColumnsInDataSchema);
        for (OrderByExpressionContext orderByExpression : orderByExpressions) {
            expressionIndexMap.put((Object)orderByExpression.getExpression(), expressionIndexMap.size());
        }
        for (ExpressionContext selectExpression : selectExpressions) {
            expressionIndexMap.putIfAbsent((Object)selectExpression, expressionIndexMap.size());
        }
        String[] columnNames = new String[numSelectExpressions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numSelectExpressions];
        int[] columnIndices = new int[numSelectExpressions];
        if (expressionIndexMap.size() == numColumnsInDataSchema) {
            for (int i = 0; i < numSelectExpressions; ++i) {
                ExpressionContext selectExpression = selectExpressions.get(i);
                int columnIndex = expressionIndexMap.getInt((Object)selectExpression);
                columnNames[i] = selectExpression.toString();
                columnDataTypes[i] = columnDataTypesInDataSchema[columnIndex];
                columnIndices[i] = columnIndex;
            }
        } else {
            for (int i = 0; i < numSelectExpressions; ++i) {
                columnNames[i] = selectExpressions.get(i).toString();
                columnDataTypes[i] = DataSchema.ColumnDataType.STRING;
                columnIndices[i] = i;
            }
        }
        return Pair.of((Object)new DataSchema(columnNames, columnDataTypes), (Object)columnIndices);
    }

    public static void mergeWithoutOrdering(SelectionResultsBlock mergedBlock, SelectionResultsBlock blockToMerge, int selectionSize) {
        List<Object[]> mergedRows = mergedBlock.getRows();
        List<Object[]> rowsToMerge = blockToMerge.getRows();
        int numRowsToMerge = Math.min(selectionSize - mergedRows.size(), rowsToMerge.size());
        if (numRowsToMerge > 0) {
            mergedRows.addAll(rowsToMerge.subList(0, numRowsToMerge));
        }
    }

    public static void mergeWithOrdering(SelectionResultsBlock mergedBlock, SelectionResultsBlock blockToMerge, int maxNumRows) {
        List<Object[]> sortedRows1 = mergedBlock.getRows();
        List<Object[]> sortedRows2 = blockToMerge.getRows();
        Comparator<? super Object[]> comparator = mergedBlock.getComparator();
        assert (comparator != null);
        int numSortedRows1 = sortedRows1.size();
        int numSortedRows2 = sortedRows2.size();
        if (numSortedRows1 == 0) {
            mergedBlock.setRows(sortedRows2);
            return;
        }
        if (numSortedRows2 == 0 || numSortedRows1 == maxNumRows && comparator.compare((Object[])sortedRows1.get(numSortedRows1 - 1), (Object[])sortedRows2.get(0)) <= 0) {
            return;
        }
        int numRowsToMerge = Math.min(numSortedRows1 + numSortedRows2, maxNumRows);
        ArrayList<Object[]> mergedRows = new ArrayList<Object[]>(numRowsToMerge);
        int i1 = 0;
        int i2 = 0;
        int numMergedRows = 0;
        while (i1 < numSortedRows1 && i2 < numSortedRows2 && numMergedRows < numRowsToMerge) {
            Object[] row2;
            Object[] row1 = sortedRows1.get(i1);
            if (comparator.compare((Object[])row1, (Object[])(row2 = sortedRows2.get(i2))) <= 0) {
                mergedRows.add(row1);
                ++i1;
            } else {
                mergedRows.add(row2);
                ++i2;
            }
            Tracing.ThreadAccountantOps.sampleAndCheckInterruptionPeriodically((int)numMergedRows++);
        }
        if (numMergedRows < numRowsToMerge) {
            if (i1 < numSortedRows1) {
                assert (i2 == numSortedRows2);
                mergedRows.addAll(sortedRows1.subList(i1, i1 + numRowsToMerge - numMergedRows));
            } else {
                assert (i1 == numSortedRows1);
                mergedRows.addAll(sortedRows2.subList(i2, i2 + numRowsToMerge - numMergedRows));
            }
        }
        mergedBlock.setRows(mergedRows);
    }

    public static DataTable getDataTableFromRows(Collection<Object[]> rows, DataSchema dataSchema, boolean nullHandlingEnabled) throws IOException {
        DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        int numColumns = storedColumnDataTypes.length;
        DataTableBuilder dataTableBuilder = DataTableBuilderFactory.getDataTableBuilder(dataSchema);
        RoaringBitmap[] nullBitmaps = null;
        if (nullHandlingEnabled) {
            nullBitmaps = new RoaringBitmap[numColumns];
            Object[] nullPlaceholders = new Object[numColumns];
            for (int colId = 0; colId < numColumns; ++colId) {
                nullBitmaps[colId] = new RoaringBitmap();
                nullPlaceholders[colId] = storedColumnDataTypes[colId].getNullPlaceholder();
            }
            int rowId = 0;
            for (Object[] row : rows) {
                for (int i = 0; i < numColumns; ++i) {
                    Object columnValue = row[i];
                    if (columnValue != null) continue;
                    row[i] = nullPlaceholders[i];
                    nullBitmaps[i].add(rowId);
                }
                ++rowId;
            }
        }
        int numRowsAdded = 0;
        for (Object[] row : rows) {
            Tracing.ThreadAccountantOps.sampleAndCheckInterruptionPeriodically((int)numRowsAdded);
            dataTableBuilder.startRow();
            block20: for (int i = 0; i < numColumns; ++i) {
                Object columnValue = row[i];
                switch (storedColumnDataTypes[i]) {
                    case INT: {
                        dataTableBuilder.setColumn(i, (Integer)columnValue);
                        continue block20;
                    }
                    case LONG: {
                        dataTableBuilder.setColumn(i, (Long)columnValue);
                        continue block20;
                    }
                    case FLOAT: {
                        dataTableBuilder.setColumn(i, ((Float)columnValue).floatValue());
                        continue block20;
                    }
                    case DOUBLE: {
                        dataTableBuilder.setColumn(i, (Double)columnValue);
                        continue block20;
                    }
                    case BIG_DECIMAL: {
                        dataTableBuilder.setColumn(i, (BigDecimal)columnValue);
                        continue block20;
                    }
                    case STRING: {
                        dataTableBuilder.setColumn(i, (String)columnValue);
                        continue block20;
                    }
                    case BYTES: {
                        dataTableBuilder.setColumn(i, (ByteArray)columnValue);
                        continue block20;
                    }
                    case MAP: {
                        dataTableBuilder.setColumn(i, (Map)columnValue);
                        continue block20;
                    }
                    case UNKNOWN: {
                        dataTableBuilder.setColumn(i, (Object)null);
                        continue block20;
                    }
                    case INT_ARRAY: {
                        dataTableBuilder.setColumn(i, (int[])columnValue);
                        continue block20;
                    }
                    case LONG_ARRAY: {
                        dataTableBuilder.setColumn(i, (long[])columnValue);
                        continue block20;
                    }
                    case FLOAT_ARRAY: {
                        dataTableBuilder.setColumn(i, (float[])columnValue);
                        continue block20;
                    }
                    case DOUBLE_ARRAY: {
                        dataTableBuilder.setColumn(i, (double[])columnValue);
                        continue block20;
                    }
                    case STRING_ARRAY: {
                        dataTableBuilder.setColumn(i, (String[])columnValue);
                        continue block20;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported data type: " + storedColumnDataTypes + " for column: " + dataSchema.getColumnName(i));
                    }
                }
            }
            dataTableBuilder.finishRow();
            ++numRowsAdded;
        }
        if (nullHandlingEnabled) {
            for (int colId = 0; colId < numColumns; ++colId) {
                dataTableBuilder.setNullRowIds(nullBitmaps[colId]);
            }
        }
        return dataTableBuilder.build();
    }

    public static Object[] extractRowFromDataTable(DataTable dataTable, int rowId) {
        DataSchema dataSchema = dataTable.getDataSchema();
        DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        int numColumns = storedColumnDataTypes.length;
        Object[] row = new Object[numColumns];
        block16: for (int i = 0; i < numColumns; ++i) {
            switch (storedColumnDataTypes[i]) {
                case INT: {
                    row[i] = dataTable.getInt(rowId, i);
                    continue block16;
                }
                case LONG: {
                    row[i] = dataTable.getLong(rowId, i);
                    continue block16;
                }
                case FLOAT: {
                    row[i] = Float.valueOf(dataTable.getFloat(rowId, i));
                    continue block16;
                }
                case DOUBLE: {
                    row[i] = dataTable.getDouble(rowId, i);
                    continue block16;
                }
                case BIG_DECIMAL: {
                    row[i] = dataTable.getBigDecimal(rowId, i);
                    continue block16;
                }
                case STRING: {
                    row[i] = dataTable.getString(rowId, i);
                    continue block16;
                }
                case BYTES: {
                    row[i] = dataTable.getBytes(rowId, i);
                    continue block16;
                }
                case MAP: {
                    row[i] = dataTable.getMap(rowId, i);
                    continue block16;
                }
                case UNKNOWN: {
                    row[i] = null;
                    continue block16;
                }
                case INT_ARRAY: {
                    row[i] = dataTable.getIntArray(rowId, i);
                    continue block16;
                }
                case LONG_ARRAY: {
                    row[i] = dataTable.getLongArray(rowId, i);
                    continue block16;
                }
                case FLOAT_ARRAY: {
                    row[i] = dataTable.getFloatArray(rowId, i);
                    continue block16;
                }
                case DOUBLE_ARRAY: {
                    row[i] = dataTable.getDoubleArray(rowId, i);
                    continue block16;
                }
                case STRING_ARRAY: {
                    row[i] = dataTable.getStringArray(rowId, i);
                    continue block16;
                }
                default: {
                    throw new IllegalStateException("Unsupported data type: " + storedColumnDataTypes[i] + " for column: " + dataSchema.getColumnName(i));
                }
            }
        }
        return row;
    }

    public static Object[] extractRowFromDataTableWithNullHandling(DataTable dataTable, int rowId, RoaringBitmap[] nullBitmaps) {
        Object[] row = SelectionOperatorUtils.extractRowFromDataTable(dataTable, rowId);
        for (int colId = 0; colId < nullBitmaps.length; ++colId) {
            if (nullBitmaps[colId] == null || !nullBitmaps[colId].contains(rowId)) continue;
            row[colId] = null;
        }
        return row;
    }

    public static List<Object[]> reduceWithoutOrdering(Collection<DataTable> dataTables, int limit, boolean nullHandlingEnabled) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(Math.min(limit, 10000));
        for (DataTable dataTable : dataTables) {
            int numColumns = dataTable.getDataSchema().size();
            int numRows = dataTable.getNumberOfRows();
            if (nullHandlingEnabled) {
                RoaringBitmap[] nullBitmaps = new RoaringBitmap[numColumns];
                for (int coldId = 0; coldId < numColumns; ++coldId) {
                    nullBitmaps[coldId] = dataTable.getNullRowIds(coldId);
                }
                for (int rowId = 0; rowId < numRows && rows.size() < limit; ++rowId) {
                    rows.add(SelectionOperatorUtils.extractRowFromDataTableWithNullHandling(dataTable, rowId, nullBitmaps));
                    Tracing.ThreadAccountantOps.sampleAndCheckInterruptionPeriodically((int)rowId);
                }
                continue;
            }
            for (int rowId = 0; rowId < numRows && rows.size() < limit; ++rowId) {
                rows.add(SelectionOperatorUtils.extractRowFromDataTable(dataTable, rowId));
                Tracing.ThreadAccountantOps.sampleAndCheckInterruptionPeriodically((int)rowId);
            }
        }
        return rows;
    }

    public static ResultTable renderResultTableWithoutOrdering(List<Object[]> rows, DataSchema dataSchema, int[] columnIndices) {
        int numRows = rows.size();
        ArrayList<Object[]> resultRows = new ArrayList<Object[]>(numRows);
        DataSchema.ColumnDataType[] columnDataTypes = dataSchema.getColumnDataTypes();
        int numColumns = columnDataTypes.length;
        for (Object[] row : rows) {
            Object[] resultRow = new Object[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                Object value = row[columnIndices[i]];
                if (value == null) continue;
                resultRow[i] = columnDataTypes[i].convertAndFormat(value);
            }
            resultRows.add(resultRow);
        }
        return new ResultTable(dataSchema, resultRows);
    }

    public static <T> void addToPriorityQueue(T value, PriorityQueue<T> queue, int maxNumValues) {
        if (queue.size() < maxNumValues) {
            queue.add(value);
        } else if (queue.comparator().compare(queue.peek(), value) < 0) {
            queue.poll();
            queue.offer(value);
        }
    }
}

