/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.aggregator;

import java.util.Map;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.SetOperationBuilder;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Union;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.segment.processing.aggregator.ValueAggregator;

public class DistinctCountThetaSketchAggregator
implements ValueAggregator {
    @Override
    public Object aggregate(Object value1, Object value2, Map<String, String> functionParameters) {
        SetOperationBuilder unionBuilder = Union.builder();
        String samplingProbabilityParam = functionParameters.get("samplingProbability");
        String nominalEntriesParam = functionParameters.get("nominalEntries");
        if (nominalEntriesParam != null) {
            unionBuilder.setNominalEntries(Integer.parseInt(nominalEntriesParam));
        } else {
            unionBuilder.setNominalEntries(16384);
        }
        if (samplingProbabilityParam != null) {
            unionBuilder.setP(Float.parseFloat(samplingProbabilityParam));
        }
        Union union = unionBuilder.buildUnion();
        Sketch first = ObjectSerDeUtils.DATA_SKETCH_THETA_SER_DE.deserialize((byte[])value1);
        Sketch second = ObjectSerDeUtils.DATA_SKETCH_THETA_SER_DE.deserialize((byte[])value2);
        CompactSketch result = union.union(first, second);
        return ObjectSerDeUtils.DATA_SKETCH_THETA_SER_DE.serialize((Sketch)result);
    }
}

