/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.aggregator;

import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.pinot.core.segment.processing.aggregator.DistinctCountCPCSketchAggregator;
import org.apache.pinot.core.segment.processing.aggregator.DistinctCountHLLAggregator;
import org.apache.pinot.core.segment.processing.aggregator.DistinctCountThetaSketchAggregator;
import org.apache.pinot.core.segment.processing.aggregator.DistinctCountULLAggregator;
import org.apache.pinot.core.segment.processing.aggregator.IntegerTupleSketchAggregator;
import org.apache.pinot.core.segment.processing.aggregator.MaxValueAggregator;
import org.apache.pinot.core.segment.processing.aggregator.MinValueAggregator;
import org.apache.pinot.core.segment.processing.aggregator.SumValueAggregator;
import org.apache.pinot.core.segment.processing.aggregator.ValueAggregator;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class ValueAggregatorFactory {
    private ValueAggregatorFactory() {
    }

    public static ValueAggregator getValueAggregator(AggregationFunctionType aggregationType, FieldSpec.DataType dataType) {
        switch (aggregationType) {
            case MIN: {
                return new MinValueAggregator(dataType);
            }
            case MAX: {
                return new MaxValueAggregator(dataType);
            }
            case SUM: {
                return new SumValueAggregator(dataType);
            }
            case DISTINCTCOUNTHLL: 
            case DISTINCTCOUNTRAWHLL: {
                return new DistinctCountHLLAggregator();
            }
            case DISTINCTCOUNTTHETASKETCH: 
            case DISTINCTCOUNTRAWTHETASKETCH: {
                return new DistinctCountThetaSketchAggregator();
            }
            case DISTINCTCOUNTTUPLESKETCH: 
            case DISTINCTCOUNTRAWINTEGERSUMTUPLESKETCH: 
            case SUMVALUESINTEGERSUMTUPLESKETCH: 
            case AVGVALUEINTEGERSUMTUPLESKETCH: {
                return new IntegerTupleSketchAggregator(IntegerSummary.Mode.Sum);
            }
            case DISTINCTCOUNTCPCSKETCH: 
            case DISTINCTCOUNTRAWCPCSKETCH: {
                return new DistinctCountCPCSketchAggregator();
            }
            case DISTINCTCOUNTULL: 
            case DISTINCTCOUNTRAWULL: {
                return new DistinctCountULLAggregator();
            }
        }
        throw new IllegalStateException("Unsupported aggregation type: " + aggregationType);
    }
}

