/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.framework;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.core.segment.processing.framework.DefaultSegmentNumRowProvider;
import org.apache.pinot.core.segment.processing.framework.SegmentNumRowProvider;
import org.apache.pinot.core.segment.processing.framework.SegmentProcessorConfig;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileManager;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileReader;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileRecordReader;
import org.apache.pinot.core.segment.processing.mapper.SegmentMapper;
import org.apache.pinot.core.segment.processing.reducer.Reducer;
import org.apache.pinot.core.segment.processing.reducer.ReducerFactory;
import org.apache.pinot.segment.local.segment.creator.RecordReaderSegmentCreationDataSource;
import org.apache.pinot.segment.local.segment.creator.TransformPipeline;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentIndexCreationDriverImpl;
import org.apache.pinot.segment.spi.creator.SegmentCreationDataSource;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.segment.spi.creator.name.SegmentNameGeneratorFactory;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderFileConfig;
import org.apache.pinot.spi.recordtransformer.RecordTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentProcessorFramework {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentProcessorFramework.class);
    private final List<RecordReaderFileConfig> _recordReaderFileConfigs;
    private final List<RecordTransformer> _customRecordTransformers;
    private final TransformPipeline _transformPipeline;
    private final SegmentProcessorConfig _segmentProcessorConfig;
    private final File _mapperOutputDir;
    private final File _reducerOutputDir;
    private final File _segmentsOutputDir;
    private final SegmentNumRowProvider _segmentNumRowProvider;
    private int _segmentSequenceId = 0;

    @Deprecated
    public SegmentProcessorFramework(List<RecordReader> recordReaders, SegmentProcessorConfig segmentProcessorConfig, File workingDir) throws IOException {
        this(segmentProcessorConfig, workingDir, SegmentProcessorFramework.convertRecordReadersToRecordReaderFileConfig(recordReaders), Collections.emptyList(), null);
    }

    public SegmentProcessorFramework(SegmentProcessorConfig segmentProcessorConfig, File workingDir, List<RecordReaderFileConfig> recordReaderFileConfigs, List<RecordTransformer> customRecordTransformers, SegmentNumRowProvider segmentNumRowProvider) throws IOException {
        this(segmentProcessorConfig, workingDir, recordReaderFileConfigs, customRecordTransformers, null, segmentNumRowProvider);
    }

    public SegmentProcessorFramework(SegmentProcessorConfig segmentProcessorConfig, File workingDir, List<RecordReaderFileConfig> recordReaderFileConfigs, TransformPipeline transformPipeline, SegmentNumRowProvider segmentNumRowProvider) throws IOException {
        this(segmentProcessorConfig, workingDir, recordReaderFileConfigs, null, transformPipeline, segmentNumRowProvider);
    }

    protected SegmentProcessorFramework(SegmentProcessorConfig segmentProcessorConfig, File workingDir, List<RecordReaderFileConfig> recordReaderFileConfigs, List<RecordTransformer> customRecordTransformers, TransformPipeline transformPipeline, SegmentNumRowProvider segmentNumRowProvider) throws IOException {
        Preconditions.checkState((!recordReaderFileConfigs.isEmpty() ? 1 : 0) != 0, (Object)"No recordReaderFileConfigs provided");
        LOGGER.info("Initializing SegmentProcessorFramework with {} record readers, config: {}, working dir: {}", new Object[]{recordReaderFileConfigs.size(), segmentProcessorConfig, workingDir.getAbsolutePath()});
        this._recordReaderFileConfigs = recordReaderFileConfigs;
        this._customRecordTransformers = customRecordTransformers;
        this._transformPipeline = transformPipeline;
        this._segmentProcessorConfig = segmentProcessorConfig;
        this._mapperOutputDir = new File(workingDir, "mapper_output");
        FileUtils.forceMkdir((File)this._mapperOutputDir);
        this._reducerOutputDir = new File(workingDir, "reducer_output");
        FileUtils.forceMkdir((File)this._reducerOutputDir);
        this._segmentsOutputDir = new File(workingDir, "segments_output");
        FileUtils.forceMkdir((File)this._segmentsOutputDir);
        this._segmentNumRowProvider = segmentNumRowProvider == null ? new DefaultSegmentNumRowProvider(segmentProcessorConfig.getSegmentConfig().getMaxNumRecordsPerSegment()) : segmentNumRowProvider;
    }

    public static List<RecordReaderFileConfig> convertRecordReadersToRecordReaderFileConfig(List<RecordReader> recordReaders) {
        Preconditions.checkState((!recordReaders.isEmpty() ? 1 : 0) != 0, (Object)"No record reader is provided");
        ArrayList<RecordReaderFileConfig> recordReaderFileConfigs = new ArrayList<RecordReaderFileConfig>();
        for (RecordReader recordReader : recordReaders) {
            recordReaderFileConfigs.add(new RecordReaderFileConfig(recordReader));
        }
        return recordReaderFileConfigs;
    }

    public List<File> process() throws Exception {
        try {
            List<File> list = this.doProcess();
            return list;
        }
        catch (Exception e) {
            FileUtils.deleteQuietly((File)this._segmentsOutputDir);
            throw e;
        }
        finally {
            FileUtils.deleteDirectory((File)this._mapperOutputDir);
            FileUtils.deleteDirectory((File)this._reducerOutputDir);
        }
    }

    private List<File> doProcess() throws Exception {
        boolean isMapperOutputSizeThresholdEnabled;
        ArrayList<File> outputSegmentDirs = new ArrayList<File>();
        int numRecordReaders = this._recordReaderFileConfigs.size();
        int nextRecordReaderIndexToBeProcessed = 0;
        int iterationCount = 1;
        Consumer<Object> observer = this._segmentProcessorConfig.getProgressObserver();
        boolean bl = isMapperOutputSizeThresholdEnabled = this._segmentProcessorConfig.getSegmentConfig().getIntermediateFileSizeThreshold() != Long.MAX_VALUE;
        while (nextRecordReaderIndexToBeProcessed < numRecordReaders) {
            SegmentMapper mapper = this.getSegmentMapper(this._recordReaderFileConfigs.subList(nextRecordReaderIndexToBeProcessed, numRecordReaders));
            if (isMapperOutputSizeThresholdEnabled) {
                String logMessage = String.format("Starting iteration %d with %d record readers. Starting index = %d, end index = %d", iterationCount, this._recordReaderFileConfigs.subList(nextRecordReaderIndexToBeProcessed, numRecordReaders).size(), nextRecordReaderIndexToBeProcessed + 1, numRecordReaders);
                LOGGER.info(logMessage);
                observer.accept(logMessage);
            }
            long mapStartTimeInMs = System.currentTimeMillis();
            Map<String, GenericRowFileManager> partitionToFileManagerMap = mapper.map();
            LOGGER.info("Finished iteration {} in {}ms", (Object)iterationCount, (Object)(System.currentTimeMillis() - mapStartTimeInMs));
            if (partitionToFileManagerMap.isEmpty()) {
                LOGGER.info("No mapper output files generated, skipping reduce phase");
                nextRecordReaderIndexToBeProcessed = this.getNextRecordReaderIndexToBeProcessed(nextRecordReaderIndexToBeProcessed);
                continue;
            }
            this.doReduce(partitionToFileManagerMap);
            outputSegmentDirs.addAll(this.generateSegment(partitionToFileManagerMap));
            int startingProcessedRecordReaderIndex = nextRecordReaderIndexToBeProcessed;
            nextRecordReaderIndexToBeProcessed = this.getNextRecordReaderIndexToBeProcessed(nextRecordReaderIndexToBeProcessed);
            if (isMapperOutputSizeThresholdEnabled) {
                int boundaryIndexToLog = nextRecordReaderIndexToBeProcessed == numRecordReaders ? nextRecordReaderIndexToBeProcessed : nextRecordReaderIndexToBeProcessed + 1;
                String logMessage = nextRecordReaderIndexToBeProcessed == numRecordReaders ? String.format("Finished processing all of %d RecordReaders", numRecordReaders) : String.format("Finished processing RecordReaders %d to %d (RecordReader %d might be partially processed) out of %d in iteration %d", startingProcessedRecordReaderIndex + 1, boundaryIndexToLog, nextRecordReaderIndexToBeProcessed + 1, numRecordReaders, iterationCount);
                observer.accept(logMessage);
                LOGGER.info(logMessage);
            }
            ++iterationCount;
        }
        return outputSegmentDirs;
    }

    protected SegmentMapper getSegmentMapper(List<RecordReaderFileConfig> recordReaderFileConfigs) {
        if (this._transformPipeline != null) {
            return new SegmentMapper(recordReaderFileConfigs, this._transformPipeline, this._segmentProcessorConfig, this._mapperOutputDir);
        }
        return new SegmentMapper(recordReaderFileConfigs, this._customRecordTransformers, this._segmentProcessorConfig, this._mapperOutputDir);
    }

    private int getNextRecordReaderIndexToBeProcessed(int currentRecordIndex) {
        for (int i = currentRecordIndex; i < this._recordReaderFileConfigs.size(); ++i) {
            RecordReaderFileConfig recordReaderFileConfig = this._recordReaderFileConfigs.get(i);
            if (recordReaderFileConfig.isRecordReaderDone()) continue;
            return i;
        }
        return this._recordReaderFileConfigs.size();
    }

    private void doReduce(Map<String, GenericRowFileManager> partitionToFileManagerMap) throws Exception {
        LOGGER.info("Beginning reduce phase on partitions: {}", partitionToFileManagerMap.keySet());
        Consumer<Object> observer = this._segmentProcessorConfig.getProgressObserver();
        int totalCount = partitionToFileManagerMap.size();
        int count = 1;
        for (Map.Entry<String, GenericRowFileManager> entry : partitionToFileManagerMap.entrySet()) {
            String partitionId = entry.getKey();
            observer.accept(String.format("Doing reduce phase on data from partition: %s (%d out of %d)", partitionId, count++, totalCount));
            GenericRowFileManager fileManager = entry.getValue();
            Reducer reducer = ReducerFactory.getReducer(partitionId, fileManager, this._segmentProcessorConfig, this._reducerOutputDir);
            entry.setValue(reducer.reduce());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> generateSegment(Map<String, GenericRowFileManager> partitionToFileManagerMap) throws Exception {
        LOGGER.info("Beginning segment creation phase on partitions: {}", partitionToFileManagerMap.keySet());
        ArrayList<File> outputSegmentDirs = new ArrayList<File>();
        TableConfig tableConfig = this._segmentProcessorConfig.getTableConfig();
        Schema schema = this._segmentProcessorConfig.getSchema();
        String segmentNamePrefix = this._segmentProcessorConfig.getSegmentConfig().getSegmentNamePrefix();
        String segmentNamePostfix = this._segmentProcessorConfig.getSegmentConfig().getSegmentNamePostfix();
        String fixedSegmentName = this._segmentProcessorConfig.getSegmentConfig().getFixedSegmentName();
        SegmentGeneratorConfig generatorConfig = new SegmentGeneratorConfig(tableConfig, schema);
        generatorConfig.setOutDir(this._segmentsOutputDir.getPath());
        Consumer<Object> observer = this._segmentProcessorConfig.getProgressObserver();
        generatorConfig.setCreationTime(String.valueOf(this._segmentProcessorConfig.getCustomCreationTime()));
        if (this._segmentProcessorConfig.getSegmentNameGenerator() != null) {
            generatorConfig.setSegmentNameGenerator(this._segmentProcessorConfig.getSegmentNameGenerator());
        } else if (tableConfig.getIndexingConfig().getSegmentNameGeneratorType() != null) {
            generatorConfig.setSegmentNameGenerator(SegmentNameGeneratorFactory.createSegmentNameGenerator((TableConfig)tableConfig, (Schema)schema, (String)segmentNamePrefix, (String)segmentNamePostfix, (String)fixedSegmentName, (boolean)false));
        } else {
            generatorConfig.setSegmentNamePrefix(segmentNamePrefix);
            generatorConfig.setSegmentNamePostfix(segmentNamePostfix);
            generatorConfig.setSegmentName(fixedSegmentName);
        }
        for (Map.Entry<String, GenericRowFileManager> entry : partitionToFileManagerMap.entrySet()) {
            String partitionId = entry.getKey();
            GenericRowFileManager fileManager = entry.getValue();
            try {
                GenericRowFileReader fileReader = fileManager.getFileReader();
                int numRows = fileReader.getNumRows();
                int numSortFields = fileReader.getNumSortFields();
                LOGGER.info("Start creating segments on partition: {}, numRows: {}, numSortFields: {}", new Object[]{partitionId, numRows, numSortFields});
                GenericRowFileRecordReader recordReader = fileReader.getRecordReader();
                int startRowId = 0;
                while (startRowId < numRows) {
                    int maxNumRecordsPerSegment = this._segmentNumRowProvider.getNumRows();
                    int endRowId = Math.min(startRowId + maxNumRecordsPerSegment, numRows);
                    LOGGER.info("Start creating segment of sequenceId: {} with row range: {} to {}", new Object[]{this._segmentSequenceId, startRowId, endRowId});
                    observer.accept(String.format("Creating segment of sequentId: %d with data from partition: %s and row range: [%d, %d) out of [0, %d)", this._segmentSequenceId, partitionId, startRowId, endRowId, numRows));
                    generatorConfig.setSequenceId(this._segmentSequenceId);
                    GenericRowFileRecordReader recordReaderForRange = recordReader.getRecordReaderForRange(startRowId, endRowId);
                    SegmentIndexCreationDriverImpl driver = new SegmentIndexCreationDriverImpl();
                    driver.init(generatorConfig, (SegmentCreationDataSource)new RecordReaderSegmentCreationDataSource((RecordReader)recordReaderForRange), TransformPipeline.getPassThroughPipeline());
                    driver.build();
                    outputSegmentDirs.add(driver.getOutputDirectory());
                    this._segmentNumRowProvider.updateSegmentInfo(driver.getSegmentStats().getTotalDocCount(), FileUtils.sizeOfDirectory((File)driver.getOutputDirectory()));
                    startRowId += maxNumRecordsPerSegment;
                    ++this._segmentSequenceId;
                }
            }
            finally {
                fileManager.cleanUp();
            }
        }
        LOGGER.info("Successfully created segments: {}", outputSegmentDirs);
        return outputSegmentDirs;
    }
}

