/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.genericrow;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.List;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowDeserializer;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileRecordReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.readers.GenericRow;

public class GenericRowFileReader
implements Closeable {
    private final int _numRows;
    private final PinotDataBuffer _offsetBuffer;
    private final PinotDataBuffer _dataBuffer;
    private final GenericRowDeserializer _deserializer;
    private final int _numSortFields;

    public GenericRowFileReader(File offsetFile, File dataFile, List<FieldSpec> fieldSpecs, boolean includeNullFields, int numSortFields) throws IOException {
        long offsetFileLength = offsetFile.length();
        this._numRows = (int)(offsetFileLength >>> 3);
        this._offsetBuffer = PinotDataBuffer.mapFile((File)offsetFile, (boolean)true, (long)0L, (long)offsetFileLength, (ByteOrder)ByteOrder.BIG_ENDIAN, (String)"GenericRow offset buffer");
        this._dataBuffer = PinotDataBuffer.mapFile((File)dataFile, (boolean)true, (long)0L, (long)dataFile.length(), (ByteOrder)PinotDataBuffer.NATIVE_ORDER, (String)"GenericRow data buffer");
        this._deserializer = new GenericRowDeserializer(this._dataBuffer, fieldSpecs, includeNullFields);
        this._numSortFields = numSortFields;
    }

    public int getNumRows() {
        return this._numRows;
    }

    public int getNumSortFields() {
        return this._numSortFields;
    }

    public void read(int rowId, GenericRow buffer) {
        long offset = this._offsetBuffer.getLong((long)rowId << 3);
        this._deserializer.deserialize(offset, buffer);
    }

    public int compare(int rowId1, int rowId2) {
        long offset1 = this._offsetBuffer.getLong((long)rowId1 << 3);
        long offset2 = this._offsetBuffer.getLong((long)rowId2 << 3);
        return this._deserializer.compare(offset1, offset2, this._numSortFields);
    }

    public GenericRowFileRecordReader getRecordReader() {
        return new GenericRowFileRecordReader(this);
    }

    @Override
    public void close() throws IOException {
        this._offsetBuffer.close();
        this._dataBuffer.close();
    }
}

