/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.lifecycle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixManager;
import org.apache.pinot.core.segment.processing.lifecycle.PinotSegmentLifecycleEventListener;
import org.apache.pinot.core.segment.processing.lifecycle.SegmentLifecycleEventDetails;
import org.apache.pinot.core.segment.processing.lifecycle.SegmentLifecycleEventListener;
import org.apache.pinot.core.segment.processing.lifecycle.SegmentLifecycleEventType;
import org.apache.pinot.spi.utils.PinotReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotSegmentLifecycleEventListenerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotSegmentLifecycleEventListenerManager.class);
    private static final PinotSegmentLifecycleEventListenerManager INSTANCE = new PinotSegmentLifecycleEventListenerManager();
    private Map<SegmentLifecycleEventType, List<PinotSegmentLifecycleEventListener>> _eventTypeToListenersMap;
    private boolean _initialized = false;

    private PinotSegmentLifecycleEventListenerManager() {
    }

    public static PinotSegmentLifecycleEventListenerManager getInstance() {
        return INSTANCE;
    }

    public synchronized void init(HelixManager helixZkManager) {
        if (this._initialized) {
            LOGGER.warn("Segment lifecycle event listener manager already initialized, skipping it");
            return;
        }
        this._eventTypeToListenersMap = new HashMap<SegmentLifecycleEventType, List<PinotSegmentLifecycleEventListener>>();
        Set classes = PinotReflectionUtils.getClassesThroughReflection((String)".*\\.plugin\\.segment\\.lifecycle\\.listener\\..*", SegmentLifecycleEventListener.class);
        for (Class clazz : classes) {
            SegmentLifecycleEventListener annotation = clazz.getAnnotation(SegmentLifecycleEventListener.class);
            if (!annotation.enabled()) continue;
            try {
                PinotSegmentLifecycleEventListener pinotSegmentLifecycleEventListener = (PinotSegmentLifecycleEventListener)clazz.newInstance();
                pinotSegmentLifecycleEventListener.init(helixZkManager);
                this._eventTypeToListenersMap.compute(pinotSegmentLifecycleEventListener.getType(), (key, list) -> {
                    if (list == null) {
                        list = new ArrayList<PinotSegmentLifecycleEventListener>();
                    }
                    list.add(pinotSegmentLifecycleEventListener);
                    return list;
                });
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while initializing segment lifecyle event listener : {}, skipping it", (Object)clazz, (Object)e);
            }
        }
        this._initialized = true;
    }

    public void notifyListeners(SegmentLifecycleEventDetails event) {
        if (!this._initialized) {
            LOGGER.warn("Segment lifecycle event listener manager not initialized, skipping it");
            return;
        }
        List<PinotSegmentLifecycleEventListener> listeners = this._eventTypeToListenersMap.get((Object)event.getType());
        if (listeners != null) {
            for (PinotSegmentLifecycleEventListener listener : listeners) {
                try {
                    listener.onEvent(event);
                }
                catch (Exception e) {
                    LOGGER.error("Segment lifecycle listener call failed : ", (Throwable)e);
                }
            }
        }
    }
}

