/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.mapper;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.core.segment.processing.framework.SegmentProcessorConfig;
import org.apache.pinot.core.segment.processing.genericrow.AdaptiveSizeBasedWriter;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileManager;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileWriter;
import org.apache.pinot.core.segment.processing.partitioner.Partitioner;
import org.apache.pinot.core.segment.processing.partitioner.PartitionerConfig;
import org.apache.pinot.core.segment.processing.partitioner.PartitionerFactory;
import org.apache.pinot.core.segment.processing.timehandler.TimeHandler;
import org.apache.pinot.core.segment.processing.timehandler.TimeHandlerFactory;
import org.apache.pinot.core.segment.processing.utils.SegmentProcessorUtils;
import org.apache.pinot.segment.local.recordtransformer.ComplexTypeTransformer;
import org.apache.pinot.segment.local.recordtransformer.CompositeTransformer;
import org.apache.pinot.segment.local.segment.creator.TransformPipeline;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderFileConfig;
import org.apache.pinot.spi.recordtransformer.RecordTransformer;
import org.apache.pinot.spi.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentMapper.class);
    private final SegmentProcessorConfig _processorConfig;
    private final File _mapperOutputDir;
    private final List<FieldSpec> _fieldSpecs;
    private final boolean _includeNullFields;
    private final int _numSortFields;
    private final TransformPipeline _transformPipeline;
    private final TimeHandler _timeHandler;
    private final Partitioner[] _partitioners;
    private final String[] _partitionsBuffer;
    private final Map<String, GenericRowFileManager> _partitionToFileManagerMap = new TreeMap<String, GenericRowFileManager>();
    private final AdaptiveSizeBasedWriter _adaptiveSizeBasedWriter;
    private final List<RecordReaderFileConfig> _recordReaderFileConfigs;

    public SegmentMapper(List<RecordReaderFileConfig> recordReaderFileConfigs, List<RecordTransformer> customRecordTransformers, SegmentProcessorConfig processorConfig, File mapperOutputDir) {
        this(recordReaderFileConfigs, new TransformPipeline((RecordTransformer)CompositeTransformer.composeAllTransformers(customRecordTransformers, (TableConfig)processorConfig.getTableConfig(), (Schema)processorConfig.getSchema()), ComplexTypeTransformer.getComplexTypeTransformer((TableConfig)processorConfig.getTableConfig())), processorConfig, mapperOutputDir);
    }

    public SegmentMapper(List<RecordReaderFileConfig> recordReaderFileConfigs, TransformPipeline transformPipeline, SegmentProcessorConfig processorConfig, File mapperOutputDir) {
        this._recordReaderFileConfigs = recordReaderFileConfigs;
        this._processorConfig = processorConfig;
        this._mapperOutputDir = mapperOutputDir;
        TableConfig tableConfig = processorConfig.getTableConfig();
        Schema schema = processorConfig.getSchema();
        Pair<List<FieldSpec>, Integer> pair = SegmentProcessorUtils.getFieldSpecs(schema, processorConfig.getMergeType(), tableConfig.getIndexingConfig().getSortedColumn());
        this._fieldSpecs = (List)pair.getLeft();
        this._numSortFields = (Integer)pair.getRight();
        this._includeNullFields = schema.isEnableColumnBasedNullHandling() || tableConfig.getIndexingConfig().isNullHandlingEnabled();
        this._transformPipeline = transformPipeline;
        this._timeHandler = TimeHandlerFactory.getTimeHandler(processorConfig);
        List<PartitionerConfig> partitionerConfigs = processorConfig.getPartitionerConfigs();
        int numPartitioners = partitionerConfigs.size();
        this._partitioners = new Partitioner[numPartitioners];
        for (int i = 0; i < numPartitioners; ++i) {
            this._partitioners[i] = PartitionerFactory.getPartitioner(partitionerConfigs.get(i));
        }
        this._partitionsBuffer = new String[numPartitioners + 1];
        LOGGER.info("Initialized mapper with {} record readers, output dir: {}, timeHandler: {}, partitioners: {}", new Object[]{this._recordReaderFileConfigs.size(), this._mapperOutputDir, this._timeHandler.getClass(), Arrays.stream(this._partitioners).map(p -> p.getClass().toString()).collect(Collectors.joining(","))});
        this._adaptiveSizeBasedWriter = new AdaptiveSizeBasedWriter(processorConfig.getSegmentConfig().getIntermediateFileSizeThreshold());
    }

    public Map<String, GenericRowFileManager> map() throws Exception {
        try {
            return this.doMap();
        }
        catch (Exception e) {
            for (GenericRowFileManager fileManager : this._partitionToFileManagerMap.values()) {
                fileManager.cleanUp();
            }
            throw e;
        }
    }

    private Map<String, GenericRowFileManager> doMap() throws Exception {
        Consumer<Object> observer = this._processorConfig.getProgressObserver();
        int count = 1;
        int totalNumRecordReaders = this._recordReaderFileConfigs.size();
        GenericRow reuse = new GenericRow();
        for (RecordReaderFileConfig recordReaderFileConfig : this._recordReaderFileConfigs) {
            boolean shouldMapperTerminate;
            RecordReader recordReader = recordReaderFileConfig.getRecordReader();
            boolean bl = shouldMapperTerminate = !this.completeMapAndTransformRow(recordReader, reuse, observer, count, totalNumRecordReaders);
            if (shouldMapperTerminate) break;
            recordReaderFileConfig.closeRecordReader();
            ++count;
        }
        for (GenericRowFileManager fileManager : this._partitionToFileManagerMap.values()) {
            fileManager.closeFileWriter();
        }
        return this._partitionToFileManagerMap;
    }

    protected boolean completeMapAndTransformRow(RecordReader recordReader, GenericRow reuse, Consumer<Object> observer, int count, int totalCount) throws Exception {
        boolean continueOnError;
        observer.accept(String.format("Doing map phase on data from RecordReader (%d out of %d)", count, totalCount));
        TransformPipeline.Result reusedResult = new TransformPipeline.Result();
        boolean bl = continueOnError = this._processorConfig.getTableConfig().getIngestionConfig() != null && this._processorConfig.getTableConfig().getIngestionConfig().isContinueOnError();
        while (recordReader.hasNext() && this._adaptiveSizeBasedWriter.canWrite()) {
            try {
                reuse = recordReader.next(reuse);
                this._transformPipeline.processRow(reuse, reusedResult);
                for (GenericRow transformedRow : reusedResult.getTransformedRows()) {
                    this.writeRecord(transformedRow);
                }
            }
            catch (Exception e) {
                if (!continueOnError) {
                    throw new RuntimeException("Caught exception while reading data", e);
                }
                LOGGER.debug("Caught exception while reading data", (Throwable)e);
                continue;
            }
            reuse.clear();
        }
        if (recordReader.hasNext() && !this._adaptiveSizeBasedWriter.canWrite()) {
            String logMessage = String.format("Stopping record readers at index: %d out of %d passed to mapper as size limit reached, bytes written = %d, bytes limit = %d", count, totalCount, this._adaptiveSizeBasedWriter.getNumBytesWritten(), this._adaptiveSizeBasedWriter.getBytesLimit());
            observer.accept(logMessage);
            LOGGER.info(logMessage);
            return false;
        }
        return true;
    }

    protected void writeRecord(GenericRow row) throws IOException {
        String timePartition = this._timeHandler.handleTime(row);
        if (timePartition == null) {
            return;
        }
        this._partitionsBuffer[0] = timePartition;
        int numPartitioners = this._partitioners.length;
        for (int i = 0; i < numPartitioners; ++i) {
            this._partitionsBuffer[i + 1] = this._partitioners[i].getPartition(row);
        }
        String partition = StringUtil.join((String)"_", (String[])this._partitionsBuffer);
        GenericRowFileManager fileManager = this._partitionToFileManagerMap.get(partition);
        if (fileManager == null) {
            File partitionOutputDir = new File(this._mapperOutputDir, partition);
            FileUtils.forceMkdir((File)partitionOutputDir);
            fileManager = new GenericRowFileManager(partitionOutputDir, this._fieldSpecs, this._includeNullFields, this._numSortFields);
            this._partitionToFileManagerMap.put(partition, fileManager);
        }
        GenericRowFileWriter fileWriter = fileManager.getFileWriter();
        this._adaptiveSizeBasedWriter.write(fileWriter, row);
    }
}

