/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.timehandler;

import javax.annotation.Nullable;
import org.apache.pinot.core.segment.processing.timehandler.TimeHandler;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.readers.GenericRow;

public class EpochTimeHandler
implements TimeHandler {
    private final String _timeColumn;
    private final FieldSpec.DataType _dataType;
    private final DateTimeFormatSpec _formatSpec;
    private final long _startTimeMs;
    private final long _endTimeMs;
    private final boolean _negateWindowFilter;
    private final long _roundBucketMs;
    private final long _partitionBucketMs;

    public EpochTimeHandler(DateTimeFieldSpec fieldSpec, long startTimeMs, long endTimeMs, boolean negateWindowFilter, long roundBucketMs, long partitionBucketMs) {
        this._timeColumn = fieldSpec.getName();
        this._dataType = fieldSpec.getDataType();
        this._formatSpec = fieldSpec.getFormatSpec();
        this._startTimeMs = startTimeMs;
        this._endTimeMs = endTimeMs;
        this._negateWindowFilter = negateWindowFilter;
        this._roundBucketMs = roundBucketMs;
        this._partitionBucketMs = partitionBucketMs;
    }

    @Override
    @Nullable
    public String handleTime(GenericRow row) {
        long timeMs = this._formatSpec.fromFormatToMillis(row.getValue(this._timeColumn).toString());
        if (this._startTimeMs > 0L) {
            boolean outsideTimeWindow;
            boolean bl = outsideTimeWindow = timeMs < this._startTimeMs || timeMs >= this._endTimeMs;
            if (outsideTimeWindow != this._negateWindowFilter) {
                return null;
            }
        }
        if (this._roundBucketMs > 0L) {
            timeMs = timeMs / this._roundBucketMs * this._roundBucketMs;
            row.putValue(this._timeColumn, this._dataType.convert(this._formatSpec.fromMillisToFormat(timeMs)));
        }
        if (this._partitionBucketMs > 0L) {
            return Long.toString(timeMs / this._partitionBucketMs);
        }
        return "0";
    }
}

