/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.startree.operator;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntImmutableList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectBooleanPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.common.utils.config.QueryOptionsUtils;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.docidsets.EmptyDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.BitmapBasedFilterOperator;
import org.apache.pinot.core.operator.filter.EmptyFilterOperator;
import org.apache.pinot.core.operator.filter.FilterOperatorUtils;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.startree.CompositePredicateEvaluator;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.startree.StarTree;
import org.apache.pinot.segment.spi.index.startree.StarTreeNode;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class StarTreeFilterOperator
extends BaseFilterOperator {
    private static final String EXPLAIN_NAME = "FILTER_STARTREE_INDEX";
    private static final int USE_SCAN_TO_TRAVERSE_NODES_THRESHOLD = 10;
    private final QueryContext _queryContext;
    private final StarTreeV2 _starTreeV2;
    private final Map<String, List<CompositePredicateEvaluator>> _predicateEvaluatorsMap;
    private final Set<String> _groupByColumns;
    private final boolean _scanStarTreeNodes;
    boolean _resultEmpty = false;

    public StarTreeFilterOperator(QueryContext queryContext, StarTreeV2 starTreeV2, Map<String, List<CompositePredicateEvaluator>> predicateEvaluatorsMap, @Nullable Set<String> groupByColumns) {
        super(0, false);
        this._queryContext = queryContext;
        this._starTreeV2 = starTreeV2;
        this._predicateEvaluatorsMap = predicateEvaluatorsMap;
        this._groupByColumns = groupByColumns != null ? groupByColumns : Collections.emptySet();
        this._scanStarTreeNodes = QueryOptionsUtils.isScanStarTreeNodes(this._queryContext.getQueryOptions());
    }

    @Override
    protected BlockDocIdSet getTrues() {
        if (this._resultEmpty) {
            return EmptyDocIdSet.getInstance();
        }
        return ((FilterBlock)this.getFilterOperator().nextBlock()).getBlockDocIdSet();
    }

    @Override
    public boolean isResultEmpty() {
        return this._resultEmpty;
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }

    private BaseFilterOperator getFilterOperator() {
        StarTreeResult starTreeResult = this.traverseStarTree();
        if (starTreeResult == null) {
            return EmptyFilterOperator.getInstance();
        }
        int numDocs = this._starTreeV2.getMetadata().getNumDocs();
        ArrayList<BaseFilterOperator> childFilterOperators = new ArrayList<BaseFilterOperator>(1 + starTreeResult._remainingPredicateColumns.size());
        childFilterOperators.add(new BitmapBasedFilterOperator(starTreeResult._matchedDocIds, false, numDocs));
        for (String remainingPredicateColumn : starTreeResult._remainingPredicateColumns) {
            List<CompositePredicateEvaluator> compositePredicateEvaluators = this._predicateEvaluatorsMap.get(remainingPredicateColumn);
            DataSource dataSource = this._starTreeV2.getDataSource(remainingPredicateColumn);
            for (CompositePredicateEvaluator compositePredicateEvaluator : compositePredicateEvaluators) {
                List<ObjectBooleanPair<PredicateEvaluator>> predicateEvaluators = compositePredicateEvaluator.getPredicateEvaluators();
                int numPredicateEvaluators = predicateEvaluators.size();
                if (numPredicateEvaluators == 1) {
                    childFilterOperators.add(this.getFilterOperator(predicateEvaluators.get(0), dataSource, numDocs));
                    continue;
                }
                ArrayList<BaseFilterOperator> orChildFilterOperators = new ArrayList<BaseFilterOperator>(numPredicateEvaluators);
                for (ObjectBooleanPair<PredicateEvaluator> childPredicateEvaluator : predicateEvaluators) {
                    orChildFilterOperators.add(this.getFilterOperator(childPredicateEvaluator, dataSource, numDocs));
                }
                childFilterOperators.add(FilterOperatorUtils.getOrFilterOperator(this._queryContext, orChildFilterOperators, numDocs));
            }
        }
        return FilterOperatorUtils.getAndFilterOperator(this._queryContext, childFilterOperators, numDocs);
    }

    private BaseFilterOperator getFilterOperator(ObjectBooleanPair<PredicateEvaluator> predicateEvaluator, DataSource dataSource, int numDocs) {
        BaseFilterOperator leafFilterOperator = FilterOperatorUtils.getLeafFilterOperator(this._queryContext, (PredicateEvaluator)predicateEvaluator.left(), dataSource, numDocs);
        if (predicateEvaluator.rightBoolean()) {
            return FilterOperatorUtils.getNotFilterOperator(this._queryContext, leafFilterOperator, numDocs);
        }
        return leafFilterOperator;
    }

    @Nullable
    private StarTreeResult traverseStarTree() {
        StarTreeNode starTreeNode;
        MutableRoaringBitmap matchingDocIds = new MutableRoaringBitmap();
        HashSet<String> globalRemainingPredicateColumns = null;
        StarTree starTree = this._starTreeV2.getStarTree();
        List dimensionNames = starTree.getDimensionNames();
        StarTreeNode starTreeRootNode = starTree.getRoot();
        boolean foundLeafNode = starTreeRootNode.isLeaf();
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        queue.add(starTreeRootNode);
        int currentDimensionId = -1;
        HashSet<String> remainingPredicateColumns = new HashSet<String>(this._predicateEvaluatorsMap.keySet());
        HashSet<String> remainingGroupByColumns = new HashSet<String>(this._groupByColumns);
        if (foundLeafNode) {
            globalRemainingPredicateColumns = new HashSet<String>(remainingPredicateColumns);
        }
        IntSet matchingDictIds = null;
        while ((starTreeNode = (StarTreeNode)queue.poll()) != null) {
            int dimensionId = starTreeNode.getDimensionId();
            if (dimensionId > currentDimensionId) {
                String dimension = (String)dimensionNames.get(dimensionId);
                remainingPredicateColumns.remove(dimension);
                remainingGroupByColumns.remove(dimension);
                if (foundLeafNode && globalRemainingPredicateColumns == null) {
                    globalRemainingPredicateColumns = new HashSet<String>(remainingPredicateColumns);
                }
                matchingDictIds = null;
                currentDimensionId = dimensionId;
            }
            if (remainingPredicateColumns.isEmpty() && remainingGroupByColumns.isEmpty()) {
                matchingDocIds.add(starTreeNode.getAggregatedDocId());
                continue;
            }
            if (starTreeNode.isLeaf()) {
                matchingDocIds.add((long)starTreeNode.getStartDocId(), (long)starTreeNode.getEndDocId());
                continue;
            }
            String childDimension = (String)dimensionNames.get(dimensionId + 1);
            StarTreeNode starNode = null;
            if (!(globalRemainingPredicateColumns != null && globalRemainingPredicateColumns.contains(childDimension) || remainingGroupByColumns.contains(childDimension))) {
                starNode = starTreeNode.getChildForDimensionValue(-1);
            }
            if (remainingPredicateColumns.contains(childDimension)) {
                int numChildren;
                if (matchingDictIds == null && (matchingDictIds = this.getMatchingDictIds(this._predicateEvaluatorsMap.get(childDimension))).isEmpty()) {
                    return null;
                }
                int numMatchingDictIds = matchingDictIds.size();
                if (numMatchingDictIds * 10 > (numChildren = starTreeNode.getNumChildren()) || this._scanStarTreeNodes) {
                    Iterator childrenIterator = starTreeNode.getChildrenIterator();
                    if (starNode != null && numMatchingDictIds >= numChildren - 1) {
                        ArrayList<StarTreeNode> matchingChildNodes = new ArrayList<StarTreeNode>();
                        boolean findLeafChildNode = false;
                        while (childrenIterator.hasNext()) {
                            StarTreeNode childNode = (StarTreeNode)childrenIterator.next();
                            if (!matchingDictIds.contains(childNode.getDimensionValue())) continue;
                            matchingChildNodes.add(childNode);
                            findLeafChildNode |= childNode.isLeaf();
                        }
                        if (matchingChildNodes.size() == numChildren - 1) {
                            queue.add(starNode);
                            foundLeafNode |= starNode.isLeaf();
                            continue;
                        }
                        queue.addAll(matchingChildNodes);
                        foundLeafNode |= findLeafChildNode;
                        continue;
                    }
                    while (childrenIterator.hasNext()) {
                        StarTreeNode childNode = (StarTreeNode)childrenIterator.next();
                        if (!matchingDictIds.contains(childNode.getDimensionValue())) continue;
                        queue.add(childNode);
                        foundLeafNode |= childNode.isLeaf();
                    }
                    continue;
                }
                IntIterator iterator = matchingDictIds.iterator();
                while (iterator.hasNext()) {
                    int matchingDictId = iterator.nextInt();
                    StarTreeNode childNode = starTreeNode.getChildForDimensionValue(matchingDictId);
                    if (childNode == null) continue;
                    queue.add(childNode);
                    foundLeafNode |= childNode.isLeaf();
                }
                continue;
            }
            if (starNode != null) {
                queue.add(starNode);
                foundLeafNode |= starNode.isLeaf();
                continue;
            }
            Iterator childrenIterator = starTreeNode.getChildrenIterator();
            while (childrenIterator.hasNext()) {
                StarTreeNode childNode = (StarTreeNode)childrenIterator.next();
                if (childNode.getDimensionValue() == -1) continue;
                queue.add(childNode);
                foundLeafNode |= childNode.isLeaf();
            }
        }
        return new StarTreeResult((ImmutableRoaringBitmap)matchingDocIds, globalRemainingPredicateColumns != null ? globalRemainingPredicateColumns : Collections.emptySet());
    }

    private IntSet getMatchingDictIds(List<CompositePredicateEvaluator> compositePredicateEvaluators) {
        int numCompositePredicateEvaluators = compositePredicateEvaluators.size();
        if (numCompositePredicateEvaluators == 1) {
            return this.getMatchingDictIds(compositePredicateEvaluators.get(0));
        }
        compositePredicateEvaluators.sort(new Comparator<CompositePredicateEvaluator>(){

            @Override
            public int compare(CompositePredicateEvaluator o1, CompositePredicateEvaluator o2) {
                return this.getPriority(o1) - this.getPriority(o2);
            }

            int getPriority(CompositePredicateEvaluator compositePredicateEvaluator) {
                List<ObjectBooleanPair<PredicateEvaluator>> predicateEvaluators = compositePredicateEvaluator.getPredicateEvaluators();
                if (predicateEvaluators.size() == 1) {
                    ObjectBooleanPair<PredicateEvaluator> predicateEvaluator = predicateEvaluators.get(0);
                    boolean negated = predicateEvaluator.rightBoolean();
                    switch (((PredicateEvaluator)predicateEvaluator.left()).getPredicateType()) {
                        case EQ: {
                            return negated ? 5 : 1;
                        }
                        case IN: {
                            return negated ? 4 : 2;
                        }
                        case RANGE: {
                            return 3;
                        }
                        case NOT_IN: {
                            return negated ? 2 : 4;
                        }
                        case NOT_EQ: {
                            return negated ? 1 : 5;
                        }
                    }
                    throw new IllegalStateException();
                }
                return 6;
            }
        });
        IntSet matchingDictIds = this.getMatchingDictIds(compositePredicateEvaluators.get(0));
        for (int i = 1; i < numCompositePredicateEvaluators; ++i) {
            if (matchingDictIds.isEmpty()) {
                return matchingDictIds;
            }
            CompositePredicateEvaluator compositePredicateEvaluator = compositePredicateEvaluators.get(i);
            IntIterator iterator = matchingDictIds.iterator();
            while (iterator.hasNext()) {
                if (compositePredicateEvaluator.apply(iterator.nextInt())) continue;
                iterator.remove();
            }
        }
        return matchingDictIds;
    }

    private IntSet getMatchingDictIds(CompositePredicateEvaluator compositePredicateEvaluator) {
        List<ObjectBooleanPair<PredicateEvaluator>> predicateEvaluators = compositePredicateEvaluator.getPredicateEvaluators();
        if (predicateEvaluators.size() == 1) {
            ObjectBooleanPair<PredicateEvaluator> predicateEvaluator = predicateEvaluators.get(0);
            if (predicateEvaluator.rightBoolean()) {
                return new IntOpenHashSet(((PredicateEvaluator)predicateEvaluator.left()).getNonMatchingDictIds());
            }
            return new IntOpenHashSet(((PredicateEvaluator)predicateEvaluator.left()).getMatchingDictIds());
        }
        IntOpenHashSet matchingDictIds = new IntOpenHashSet();
        for (ObjectBooleanPair<PredicateEvaluator> predicateEvaluator : predicateEvaluators) {
            if (predicateEvaluator.rightBoolean()) {
                matchingDictIds.addAll((IntCollection)new IntImmutableList(((PredicateEvaluator)predicateEvaluator.left()).getNonMatchingDictIds()));
                continue;
            }
            matchingDictIds.addAll((IntCollection)new IntImmutableList(((PredicateEvaluator)predicateEvaluator.left()).getMatchingDictIds()));
        }
        return matchingDictIds;
    }

    private static class StarTreeResult {
        final ImmutableRoaringBitmap _matchedDocIds;
        final Set<String> _remainingPredicateColumns;

        StarTreeResult(ImmutableRoaringBitmap matchedDocIds, Set<String> remainingPredicateColumns) {
            this._matchedDocIds = matchedDocIds;
            this._remainingPredicateColumns = remainingPredicateColumns;
        }
    }
}

