/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport;

import com.google.common.annotations.VisibleForTesting;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocatorMetric;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.config.NettyConfig;
import org.apache.pinot.common.config.TlsConfig;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.core.transport.ChannelHandlerFactory;
import org.apache.pinot.core.util.OsCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryServer.class);
    private final int _port;
    private final TlsConfig _tlsConfig;
    private final EventLoopGroup _bossGroup;
    private final EventLoopGroup _workerGroup;
    private final Class<? extends ServerSocketChannel> _channelClass;
    private final ChannelHandler _instanceRequestHandler;
    private ServerSocketChannel _channel;

    public QueryServer(int port, NettyConfig nettyConfig, ChannelHandler instanceRequestHandler) {
        this(port, nettyConfig, null, instanceRequestHandler);
    }

    public QueryServer(int port, NettyConfig nettyConfig, TlsConfig tlsConfig, ChannelHandler instanceRequestHandler) {
        this._port = port;
        this._tlsConfig = tlsConfig;
        this._instanceRequestHandler = instanceRequestHandler;
        boolean enableNativeTransports = nettyConfig != null && nettyConfig.isNativeTransportsEnabled();
        OsCheck.OSType operatingSystemType = OsCheck.getOperatingSystemType();
        if (enableNativeTransports && operatingSystemType == OsCheck.OSType.Linux && Epoll.isAvailable()) {
            this._bossGroup = new EpollEventLoopGroup();
            this._workerGroup = new EpollEventLoopGroup();
            this._channelClass = EpollServerSocketChannel.class;
            LOGGER.info("Using Epoll event loop");
        } else if (enableNativeTransports && operatingSystemType == OsCheck.OSType.MacOS && KQueue.isAvailable()) {
            this._bossGroup = new KQueueEventLoopGroup();
            this._workerGroup = new KQueueEventLoopGroup();
            this._channelClass = KQueueServerSocketChannel.class;
            LOGGER.info("Using KQueue event loop");
        } else {
            this._bossGroup = new NioEventLoopGroup();
            this._workerGroup = new NioEventLoopGroup();
            this._channelClass = NioServerSocketChannel.class;
            StringBuilder log = new StringBuilder("Using NIO event loop");
            if (operatingSystemType == OsCheck.OSType.Linux && enableNativeTransports) {
                log.append(", as Epoll is not available: ").append(Epoll.unavailabilityCause());
            } else if (operatingSystemType == OsCheck.OSType.MacOS && enableNativeTransports) {
                log.append(", as KQueue is not available: ").append(KQueue.unavailabilityCause());
            }
            LOGGER.info(log.toString());
        }
    }

    public void start() {
        try {
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            PooledByteBufAllocator bufAllocator = PooledByteBufAllocator.DEFAULT;
            PooledByteBufAllocatorMetric metric = bufAllocator.metric();
            ServerMetrics metrics = ServerMetrics.get();
            metrics.setOrUpdateGlobalGauge((AbstractMetrics.Gauge)ServerGauge.NETTY_POOLED_USED_DIRECT_MEMORY, () -> ((PooledByteBufAllocatorMetric)metric).usedDirectMemory());
            metrics.setOrUpdateGlobalGauge((AbstractMetrics.Gauge)ServerGauge.NETTY_POOLED_USED_HEAP_MEMORY, () -> ((PooledByteBufAllocatorMetric)metric).usedHeapMemory());
            metrics.setOrUpdateGlobalGauge((AbstractMetrics.Gauge)ServerGauge.NETTY_POOLED_ARENAS_DIRECT, () -> ((PooledByteBufAllocatorMetric)metric).numDirectArenas());
            metrics.setOrUpdateGlobalGauge((AbstractMetrics.Gauge)ServerGauge.NETTY_POOLED_ARENAS_HEAP, () -> ((PooledByteBufAllocatorMetric)metric).numHeapArenas());
            metrics.setOrUpdateGlobalGauge((AbstractMetrics.Gauge)ServerGauge.NETTY_POOLED_CACHE_SIZE_SMALL, () -> ((PooledByteBufAllocatorMetric)metric).smallCacheSize());
            metrics.setOrUpdateGlobalGauge((AbstractMetrics.Gauge)ServerGauge.NETTY_POOLED_CACHE_SIZE_NORMAL, () -> ((PooledByteBufAllocatorMetric)metric).normalCacheSize());
            metrics.setOrUpdateGlobalGauge((AbstractMetrics.Gauge)ServerGauge.NETTY_POOLED_THREADLOCALCACHE, () -> ((PooledByteBufAllocatorMetric)metric).numThreadLocalCaches());
            metrics.setOrUpdateGlobalGauge((AbstractMetrics.Gauge)ServerGauge.NETTY_POOLED_CHUNK_SIZE, () -> ((PooledByteBufAllocatorMetric)metric).chunkSize());
            this._channel = (ServerSocketChannel)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(this._bossGroup, this._workerGroup).channel(this._channelClass)).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).option(ChannelOption.ALLOCATOR, (Object)bufAllocator)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    if (QueryServer.this._tlsConfig != null) {
                        ch.pipeline().addLast("ssl", ChannelHandlerFactory.getServerTlsHandler(QueryServer.this._tlsConfig, ch));
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{ChannelHandlerFactory.getLengthFieldBasedFrameDecoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{ChannelHandlerFactory.getLengthFieldPrepender()});
                    ch.pipeline().addLast(new ChannelHandler[]{QueryServer.this._instanceRequestHandler});
                }
            }).bind(this._port).sync().channel();
        }
        catch (Exception e) {
            this._workerGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            this._bossGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            throw new RuntimeException(e);
        }
    }

    public void shutDown() {
        try {
            this._channel.close().sync();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this._workerGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            this._bossGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        }
    }

    @VisibleForTesting
    ServerSocketChannel getChannel() {
        return this._channel;
    }
}

