/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport.grpc;

import io.grpc.Attributes;
import io.grpc.BindableService;
import io.grpc.Grpc;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerTransportFilter;
import io.grpc.Status;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import nl.altindag.ssl.SSLFactory;
import org.apache.pinot.common.config.GrpcConfig;
import org.apache.pinot.common.config.TlsConfig;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.metrics.ServerTimer;
import org.apache.pinot.common.proto.PinotQueryServerGrpc;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.utils.tls.PinotInsecureMode;
import org.apache.pinot.common.utils.tls.RenewableTlsUtils;
import org.apache.pinot.core.operator.blocks.InstanceResponseBlock;
import org.apache.pinot.core.operator.streaming.StreamingResponseUtils;
import org.apache.pinot.core.query.executor.QueryExecutor;
import org.apache.pinot.core.query.logger.ServerQueryLogger;
import org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.core.query.scheduler.resources.ResourceManager;
import org.apache.pinot.core.transport.grpc.GrpcResultsBlockStreamer;
import org.apache.pinot.server.access.AccessControl;
import org.apache.pinot.server.access.GrpcRequesterIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcQueryServer
extends PinotQueryServerGrpc.PinotQueryServerImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcQueryServer.class);
    private static final Map<Integer, SslContext> SERVER_SSL_CONTEXTS_CACHE = new ConcurrentHashMap<Integer, SslContext>();
    private final QueryExecutor _queryExecutor;
    private final ServerMetrics _serverMetrics;
    private final Server _server;
    private final ExecutorService _executorService;
    private final AccessControl _accessControl;
    private final ServerQueryLogger _queryLogger = ServerQueryLogger.getInstance();

    public GrpcQueryServer(int port, GrpcConfig config, TlsConfig tlsConfig, QueryExecutor queryExecutor, ServerMetrics serverMetrics, AccessControl accessControl) {
        this._executorService = Executors.newFixedThreadPool(config.isQueryWorkerThreadsSet() ? config.getQueryWorkerThreads() : ResourceManager.DEFAULT_QUERY_WORKER_THREADS);
        this._queryExecutor = queryExecutor;
        this._serverMetrics = serverMetrics;
        if (tlsConfig != null) {
            try {
                this._server = ((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forPort((int)port).sslContext(GrpcQueryServer.buildGrpcSslContext(tlsConfig)).maxInboundMessageSize(config.getMaxInboundMessageSizeBytes()).addService((BindableService)this)).addTransportFilter((ServerTransportFilter)new GrpcQueryTransportFilter())).build();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to start secure grpcQueryServer", e);
            }
        } else {
            this._server = ServerBuilder.forPort((int)port).addService((BindableService)this).addTransportFilter((ServerTransportFilter)new GrpcQueryTransportFilter()).build();
        }
        this._accessControl = accessControl;
        LOGGER.info("Initialized GrpcQueryServer on port: {} with numWorkerThreads: {}", (Object)port, (Object)ResourceManager.DEFAULT_QUERY_WORKER_THREADS);
    }

    public static SslContext buildGrpcSslContext(TlsConfig tlsConfig) throws IllegalArgumentException {
        LOGGER.info("Building gRPC server SSL context");
        if (tlsConfig.getKeyStorePath() == null) {
            throw new IllegalArgumentException("Must provide key store path for secured gRPC server");
        }
        return SERVER_SSL_CONTEXTS_CACHE.computeIfAbsent(tlsConfig.hashCode(), tlsConfigHashCode -> {
            try {
                SSLFactory sslFactory = RenewableTlsUtils.createSSLFactoryAndEnableAutoRenewalWhenUsingFileStores((TlsConfig)tlsConfig, PinotInsecureMode::isPinotInInsecureMode);
                SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((KeyManagerFactory)((KeyManagerFactory)sslFactory.getKeyManagerFactory().get())).sslProvider(SslProvider.valueOf((String)tlsConfig.getSslProvider()));
                sslFactory.getTrustManagerFactory().ifPresent(arg_0 -> ((SslContextBuilder)sslContextBuilder).trustManager(arg_0));
                if (tlsConfig.isClientAuthEnabled()) {
                    sslContextBuilder.clientAuth(ClientAuth.REQUIRE);
                }
                return GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder).build();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to build gRPC server SSL context", e);
            }
        });
    }

    public void start() {
        LOGGER.info("Starting GrpcQueryServer");
        try {
            this._server.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        LOGGER.info("Shutting down GrpcQueryServer");
        try {
            this._server.shutdown().awaitTermination();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void submit(Server.ServerRequest request, StreamObserver<Server.ServerResponse> responseObserver) {
        Server.ServerResponse serverResponse;
        InstanceResponseBlock instanceResponse;
        ServerQueryRequest queryRequest;
        long startTime = System.nanoTime();
        this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.GRPC_QUERIES, 1L);
        this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.GRPC_BYTES_RECEIVED, (long)request.getSerializedSize());
        try {
            queryRequest = new ServerQueryRequest(request, this._serverMetrics);
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while deserializing the request: {}", (Object)request, (Object)e);
            this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.REQUEST_DESERIALIZATION_EXCEPTIONS, 1L);
            responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("Bad request").withCause((Throwable)e).asException());
            return;
        }
        GrpcRequesterIdentity requestIdentity = new GrpcRequesterIdentity(request.getMetadataMap());
        if (!this._accessControl.hasDataAccess(requestIdentity, queryRequest.getTableNameWithType())) {
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException(String.format("No access to table %s while processing request %d: %s from broker: %s", queryRequest.getTableNameWithType(), queryRequest.getRequestId(), queryRequest.getQueryContext(), queryRequest.getBrokerId()));
            String exceptionMsg = String.format("Table not found: %s", queryRequest.getTableNameWithType());
            LOGGER.error(exceptionMsg, (Throwable)unsupportedOperationException);
            this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.NO_TABLE_ACCESS, 1L);
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(exceptionMsg).withCause((Throwable)unsupportedOperationException).asException());
            return;
        }
        try {
            LOGGER.info("Executing gRPC query request {}: {} received from broker: {}", new Object[]{queryRequest.getRequestId(), queryRequest.getQueryContext(), queryRequest.getBrokerId()});
            instanceResponse = this._queryExecutor.execute(queryRequest, this._executorService, new GrpcResultsBlockStreamer(responseObserver, this._serverMetrics));
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while processing request {}: {} from broker: {}", new Object[]{queryRequest.getRequestId(), queryRequest.getQueryContext(), queryRequest.getBrokerId(), e});
            this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.UNCAUGHT_EXCEPTIONS, 1L);
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)e).asException());
            return;
        }
        try {
            DataTable dataTable = instanceResponse.toDataTable();
            serverResponse = queryRequest.isEnableStreaming() ? StreamingResponseUtils.getMetadataResponse(dataTable) : StreamingResponseUtils.getNonStreamingResponse(dataTable);
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while serializing response for request {}: {} from broker: {}", new Object[]{queryRequest.getRequestId(), queryRequest.getQueryContext(), queryRequest.getBrokerId(), e});
            this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.RESPONSE_SERIALIZATION_EXCEPTIONS, 1L);
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)e).asException());
            return;
        }
        responseObserver.onNext((Object)serverResponse);
        this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.GRPC_BYTES_SENT, (long)serverResponse.getSerializedSize());
        responseObserver.onCompleted();
        this._serverMetrics.addTimedTableValue(queryRequest.getTableNameWithType(), (AbstractMetrics.Timer)ServerTimer.GRPC_QUERY_EXECUTION_MS, System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        if (this._queryLogger != null) {
            this._queryLogger.logQuery(queryRequest, instanceResponse, "GrpcQueryServer");
        }
    }

    private class GrpcQueryTransportFilter
    extends ServerTransportFilter {
        private GrpcQueryTransportFilter() {
        }

        public Attributes transportReady(Attributes transportAttrs) {
            LOGGER.info("gRPC transportReady: REMOTE_ADDR {}", transportAttrs != null ? transportAttrs.get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR) : "null");
            GrpcQueryServer.this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.GRPC_TRANSPORT_READY, 1L);
            return super.transportReady(transportAttrs);
        }

        public void transportTerminated(Attributes transportAttrs) {
            if (transportAttrs != null) {
                LOGGER.info("gRPC transportTerminated: REMOTE_ADDR {}", transportAttrs.get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR));
                GrpcQueryServer.this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.GRPC_TRANSPORT_TERMINATED, 1L);
            }
        }
    }
}

