/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport.grpc;

import io.grpc.stub.StreamObserver;
import java.io.IOException;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.operator.streaming.StreamingResponseUtils;
import org.apache.pinot.core.query.executor.ResultsBlockStreamer;

public class GrpcResultsBlockStreamer
implements ResultsBlockStreamer {
    private final StreamObserver<Server.ServerResponse> _streamObserver;
    private final ServerMetrics _serverMetrics;

    public GrpcResultsBlockStreamer(StreamObserver<Server.ServerResponse> streamObserver, ServerMetrics serverMetrics) {
        this._streamObserver = streamObserver;
        this._serverMetrics = serverMetrics;
    }

    @Override
    public void send(BaseResultsBlock block) throws IOException {
        Server.ServerResponse response = StreamingResponseUtils.getDataResponse(block.getDataTable());
        this._streamObserver.onNext((Object)response);
        this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.GRPC_BYTES_SENT, (long)response.getSerializedSize());
    }
}

