/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.datablock.DataBlock;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.CommonConstants;
import org.apache.pinot.spi.utils.MapUtils;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;

public final class DataBlockExtractUtils {
    private DataBlockExtractUtils() {
    }

    public static List<Object[]> extractRows(DataBlock dataBlock) {
        DataSchema dataSchema = dataBlock.getDataSchema();
        DataSchema.ColumnDataType[] storedTypes = dataSchema.getStoredColumnDataTypes();
        int numColumns = storedTypes.length;
        RoaringBitmap[] nullBitmaps = new RoaringBitmap[numColumns];
        for (int colId = 0; colId < numColumns; ++colId) {
            nullBitmaps[colId] = dataBlock.getNullRowIds(colId);
        }
        int numRows = dataBlock.getNumberOfRows();
        ArrayList<Object[]> rows = new ArrayList<Object[]>(numRows);
        for (int rowId = 0; rowId < numRows; ++rowId) {
            Object[] row = new Object[numColumns];
            for (int colId = 0; colId < numColumns; ++colId) {
                RoaringBitmap nullBitmap = nullBitmaps[colId];
                if (nullBitmap != null && nullBitmap.contains(rowId)) continue;
                row[colId] = DataBlockExtractUtils.extractValue(dataBlock, storedTypes[colId], rowId, colId);
            }
            rows.add(row);
        }
        return rows;
    }

    private static Object extractValue(DataBlock dataBlock, DataSchema.ColumnDataType storedType, int rowId, int colId) {
        switch (storedType) {
            case INT: {
                return dataBlock.getInt(rowId, colId);
            }
            case LONG: {
                return dataBlock.getLong(rowId, colId);
            }
            case FLOAT: {
                return Float.valueOf(dataBlock.getFloat(rowId, colId));
            }
            case DOUBLE: {
                return dataBlock.getDouble(rowId, colId);
            }
            case BIG_DECIMAL: {
                return dataBlock.getBigDecimal(rowId, colId);
            }
            case STRING: {
                return dataBlock.getString(rowId, colId);
            }
            case BYTES: {
                return dataBlock.getBytes(rowId, colId);
            }
            case MAP: {
                return MapUtils.deserializeMap((byte[])dataBlock.getBytes(rowId, colId).getBytes());
            }
            case INT_ARRAY: {
                return dataBlock.getIntArray(rowId, colId);
            }
            case LONG_ARRAY: {
                return dataBlock.getLongArray(rowId, colId);
            }
            case FLOAT_ARRAY: {
                return dataBlock.getFloatArray(rowId, colId);
            }
            case DOUBLE_ARRAY: {
                return dataBlock.getDoubleArray(rowId, colId);
            }
            case STRING_ARRAY: {
                return dataBlock.getStringArray(rowId, colId);
            }
            case OBJECT: {
                return ObjectSerDeUtils.deserialize(dataBlock.getCustomObject(rowId, colId));
            }
        }
        throw new IllegalStateException("Unsupported stored type: " + storedType + " for column: " + dataBlock.getDataSchema().getColumnName(colId));
    }

    public static Object[][] extractKeys(DataBlock dataBlock, int[] keyIds) {
        DataSchema dataSchema = dataBlock.getDataSchema();
        int numKeys = keyIds.length;
        DataSchema.ColumnDataType[] storedTypes = new DataSchema.ColumnDataType[numKeys];
        RoaringBitmap[] nullBitmaps = new RoaringBitmap[numKeys];
        for (int colId = 0; colId < numKeys; ++colId) {
            storedTypes[colId] = dataSchema.getColumnDataType(keyIds[colId]).getStoredType();
            nullBitmaps[colId] = dataBlock.getNullRowIds(keyIds[colId]);
        }
        int numRows = dataBlock.getNumberOfRows();
        Object[][] keys = new Object[numRows][];
        for (int rowId = 0; rowId < numRows; ++rowId) {
            Object[] values = new Object[numKeys];
            for (int colId = 0; colId < numKeys; ++colId) {
                RoaringBitmap nullBitmap = nullBitmaps[colId];
                if (nullBitmap != null && nullBitmap.contains(rowId)) continue;
                values[colId] = DataBlockExtractUtils.extractValue(dataBlock, storedTypes[colId], rowId, keyIds[colId]);
            }
            keys[rowId] = values;
        }
        return keys;
    }

    public static Object[][] extractKeys(DataBlock dataBlock, int[] keyIds, int numMatchedRows, RoaringBitmap matchedBitmap) {
        DataSchema dataSchema = dataBlock.getDataSchema();
        int numKeys = keyIds.length;
        DataSchema.ColumnDataType[] storedTypes = new DataSchema.ColumnDataType[numKeys];
        RoaringBitmap[] nullBitmaps = new RoaringBitmap[numKeys];
        for (int colId = 0; colId < numKeys; ++colId) {
            storedTypes[colId] = dataSchema.getColumnDataType(keyIds[colId]).getStoredType();
            nullBitmaps[colId] = dataBlock.getNullRowIds(keyIds[colId]);
        }
        Object[][] keys = new Object[numMatchedRows][];
        PeekableIntIterator iterator = matchedBitmap.getIntIterator();
        for (int matchedRowId = 0; matchedRowId < numMatchedRows; ++matchedRowId) {
            int rowId = iterator.next();
            Object[] values = new Object[numKeys];
            for (int colId = 0; colId < numKeys; ++colId) {
                RoaringBitmap nullBitmap = nullBitmaps[colId];
                if (nullBitmap != null && nullBitmap.contains(rowId)) continue;
                values[colId] = DataBlockExtractUtils.extractValue(dataBlock, storedTypes[colId], rowId, keyIds[colId]);
            }
            keys[matchedRowId] = values;
        }
        return keys;
    }

    public static Object[] extractColumn(DataBlock dataBlock, int colId) {
        DataSchema dataSchema = dataBlock.getDataSchema();
        DataSchema.ColumnDataType storedType = dataSchema.getColumnDataType(colId).getStoredType();
        RoaringBitmap nullBitmap = dataBlock.getNullRowIds(colId);
        int numRows = dataBlock.getNumberOfRows();
        Object[] values = new Object[numRows];
        if (nullBitmap == null) {
            for (int rowId = 0; rowId < numRows; ++rowId) {
                values[rowId] = DataBlockExtractUtils.extractValue(dataBlock, storedType, rowId, colId);
            }
        } else {
            for (int rowId = 0; rowId < numRows; ++rowId) {
                if (nullBitmap.contains(rowId)) continue;
                values[rowId] = DataBlockExtractUtils.extractValue(dataBlock, storedType, rowId, colId);
            }
        }
        return values;
    }

    public static Object[] extractColumn(DataBlock dataBlock, int colId, int numMatchedRows, RoaringBitmap matchedBitmap) {
        DataSchema dataSchema = dataBlock.getDataSchema();
        DataSchema.ColumnDataType storedType = dataSchema.getColumnDataType(colId).getStoredType();
        RoaringBitmap nullBitmap = dataBlock.getNullRowIds(colId);
        Object[] values = new Object[numMatchedRows];
        PeekableIntIterator iterator = matchedBitmap.getIntIterator();
        if (nullBitmap == null) {
            for (int matchedRowId = 0; matchedRowId < numMatchedRows; ++matchedRowId) {
                int rowId = iterator.next();
                values[matchedRowId] = DataBlockExtractUtils.extractValue(dataBlock, storedType, rowId, colId);
            }
        } else {
            for (int matchedRowId = 0; matchedRowId < numMatchedRows; ++matchedRowId) {
                int rowId = iterator.next();
                if (nullBitmap.contains(rowId)) continue;
                values[matchedRowId] = DataBlockExtractUtils.extractValue(dataBlock, storedType, rowId, colId);
            }
        }
        return values;
    }

    public static int[] extractIntColumn(FieldSpec.DataType storedType, DataBlock dataBlock, int colId, @Nullable RoaringBitmap nullBitmap) {
        int[] values;
        block26: {
            int numRows;
            block25: {
                numRows = dataBlock.getNumberOfRows();
                values = new int[numRows];
                if (numRows == 0 || storedType == FieldSpec.DataType.UNKNOWN) {
                    return values;
                }
                if (nullBitmap != null) break block25;
                switch (storedType) {
                    case INT: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = dataBlock.getInt(rowId, colId);
                        }
                        break block26;
                    }
                    case LONG: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = (int)dataBlock.getLong(rowId, colId);
                        }
                        break block26;
                    }
                    case FLOAT: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = (int)dataBlock.getFloat(rowId, colId);
                        }
                        break block26;
                    }
                    case DOUBLE: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = (int)dataBlock.getDouble(rowId, colId);
                        }
                        break block26;
                    }
                    case BIG_DECIMAL: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = dataBlock.getBigDecimal(rowId, colId).intValue();
                        }
                        break block26;
                    }
                    default: {
                        throw new IllegalStateException("Cannot extract int values for column: " + dataBlock.getDataSchema().getColumnName(colId) + " with stored type: " + storedType);
                    }
                }
            }
            switch (storedType) {
                case INT: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        if (nullBitmap.contains(rowId)) continue;
                        values[rowId] = dataBlock.getInt(rowId, colId);
                    }
                    break;
                }
                case LONG: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        if (nullBitmap.contains(rowId)) continue;
                        values[rowId] = (int)dataBlock.getLong(rowId, colId);
                    }
                    break;
                }
                case FLOAT: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        if (nullBitmap.contains(rowId)) continue;
                        values[rowId] = (int)dataBlock.getFloat(rowId, colId);
                    }
                    break;
                }
                case DOUBLE: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        if (nullBitmap.contains(rowId)) continue;
                        values[rowId] = (int)dataBlock.getDouble(rowId, colId);
                    }
                    break;
                }
                case BIG_DECIMAL: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        if (nullBitmap.contains(rowId)) continue;
                        values[rowId] = dataBlock.getBigDecimal(rowId, colId).intValue();
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot extract int values for column: " + dataBlock.getDataSchema().getColumnName(colId) + " with stored type: " + storedType);
                }
            }
        }
        return values;
    }

    public static long[] extractLongColumn(FieldSpec.DataType storedType, DataBlock dataBlock, int colId, @Nullable RoaringBitmap nullBitmap) {
        long[] values;
        block26: {
            int numRows;
            block25: {
                numRows = dataBlock.getNumberOfRows();
                values = new long[numRows];
                if (numRows == 0 || storedType == FieldSpec.DataType.UNKNOWN) {
                    return values;
                }
                if (nullBitmap != null) break block25;
                switch (storedType) {
                    case INT: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = dataBlock.getInt(rowId, colId);
                        }
                        break block26;
                    }
                    case LONG: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = dataBlock.getLong(rowId, colId);
                        }
                        break block26;
                    }
                    case FLOAT: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = (long)dataBlock.getFloat(rowId, colId);
                        }
                        break block26;
                    }
                    case DOUBLE: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = (long)dataBlock.getDouble(rowId, colId);
                        }
                        break block26;
                    }
                    case BIG_DECIMAL: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = dataBlock.getBigDecimal(rowId, colId).longValue();
                        }
                        break block26;
                    }
                    default: {
                        throw new IllegalStateException("Cannot extract long values for column: " + dataBlock.getDataSchema().getColumnName(colId) + " with stored type: " + storedType);
                    }
                }
            }
            switch (storedType) {
                case INT: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        if (nullBitmap.contains(rowId)) continue;
                        values[rowId] = dataBlock.getInt(rowId, colId);
                    }
                    break;
                }
                case LONG: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        if (nullBitmap.contains(rowId)) continue;
                        values[rowId] = dataBlock.getLong(rowId, colId);
                    }
                    break;
                }
                case FLOAT: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        if (nullBitmap.contains(rowId)) continue;
                        values[rowId] = (long)dataBlock.getFloat(rowId, colId);
                    }
                    break;
                }
                case DOUBLE: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        if (nullBitmap.contains(rowId)) continue;
                        values[rowId] = (long)dataBlock.getDouble(rowId, colId);
                    }
                    break;
                }
                case BIG_DECIMAL: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        if (nullBitmap.contains(rowId)) continue;
                        values[rowId] = dataBlock.getBigDecimal(rowId, colId).longValue();
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot extract long values for column: " + dataBlock.getDataSchema().getColumnName(colId) + " with stored type: " + storedType);
                }
            }
        }
        return values;
    }

    public static float[] extractFloatColumn(FieldSpec.DataType storedType, DataBlock dataBlock, int colId, @Nullable RoaringBitmap nullBitmap) {
        float[] values;
        block26: {
            int numRows;
            block25: {
                numRows = dataBlock.getNumberOfRows();
                values = new float[numRows];
                if (numRows == 0 || storedType == FieldSpec.DataType.UNKNOWN) {
                    return values;
                }
                if (nullBitmap != null) break block25;
                switch (storedType) {
                    case INT: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = dataBlock.getInt(rowId, colId);
                        }
                        break block26;
                    }
                    case LONG: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = dataBlock.getLong(rowId, colId);
                        }
                        break block26;
                    }
                    case FLOAT: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = dataBlock.getFloat(rowId, colId);
                        }
                        break block26;
                    }
                    case DOUBLE: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = (float)dataBlock.getDouble(rowId, colId);
                        }
                        break block26;
                    }
                    case BIG_DECIMAL: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = dataBlock.getBigDecimal(rowId, colId).floatValue();
                        }
                        break block26;
                    }
                    default: {
                        throw new IllegalStateException("Cannot extract float values for column: " + dataBlock.getDataSchema().getColumnName(colId) + " with stored type: " + storedType);
                    }
                }
            }
            switch (storedType) {
                case INT: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        if (nullBitmap.contains(rowId)) continue;
                        values[rowId] = dataBlock.getInt(rowId, colId);
                    }
                    break;
                }
                case LONG: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        if (nullBitmap.contains(rowId)) continue;
                        values[rowId] = dataBlock.getLong(rowId, colId);
                    }
                    break;
                }
                case FLOAT: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        if (nullBitmap.contains(rowId)) continue;
                        values[rowId] = dataBlock.getFloat(rowId, colId);
                    }
                    break;
                }
                case DOUBLE: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        if (nullBitmap.contains(rowId)) continue;
                        values[rowId] = (float)dataBlock.getDouble(rowId, colId);
                    }
                    break;
                }
                case BIG_DECIMAL: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        if (nullBitmap.contains(rowId)) continue;
                        values[rowId] = dataBlock.getBigDecimal(rowId, colId).floatValue();
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot extract float values for column: " + dataBlock.getDataSchema().getColumnName(colId) + " with stored type: " + storedType);
                }
            }
        }
        return values;
    }

    public static double[] extractDoubleColumn(FieldSpec.DataType storedType, DataBlock dataBlock, int colId, @Nullable RoaringBitmap nullBitmap) {
        double[] values;
        block26: {
            int numRows;
            block25: {
                numRows = dataBlock.getNumberOfRows();
                values = new double[numRows];
                if (numRows == 0 || storedType == FieldSpec.DataType.UNKNOWN) {
                    return values;
                }
                if (nullBitmap != null) break block25;
                switch (storedType) {
                    case INT: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = dataBlock.getInt(rowId, colId);
                        }
                        break block26;
                    }
                    case LONG: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = dataBlock.getLong(rowId, colId);
                        }
                        break block26;
                    }
                    case FLOAT: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = dataBlock.getFloat(rowId, colId);
                        }
                        break block26;
                    }
                    case DOUBLE: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = dataBlock.getDouble(rowId, colId);
                        }
                        break block26;
                    }
                    case BIG_DECIMAL: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = dataBlock.getBigDecimal(rowId, colId).doubleValue();
                        }
                        break block26;
                    }
                    default: {
                        throw new IllegalStateException("Cannot extract double values for column: " + dataBlock.getDataSchema().getColumnName(colId) + " with stored type: " + storedType);
                    }
                }
            }
            switch (storedType) {
                case INT: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        if (nullBitmap.contains(rowId)) continue;
                        values[rowId] = dataBlock.getInt(rowId, colId);
                    }
                    break;
                }
                case LONG: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        if (nullBitmap.contains(rowId)) continue;
                        values[rowId] = dataBlock.getLong(rowId, colId);
                    }
                    break;
                }
                case FLOAT: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        if (nullBitmap.contains(rowId)) continue;
                        values[rowId] = dataBlock.getFloat(rowId, colId);
                    }
                    break;
                }
                case DOUBLE: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        if (nullBitmap.contains(rowId)) continue;
                        values[rowId] = dataBlock.getDouble(rowId, colId);
                    }
                    break;
                }
                case BIG_DECIMAL: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        if (nullBitmap.contains(rowId)) continue;
                        values[rowId] = dataBlock.getBigDecimal(rowId, colId).doubleValue();
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot extract double values for column: " + dataBlock.getDataSchema().getColumnName(colId) + " with stored type: " + storedType);
                }
            }
        }
        return values;
    }

    public static BigDecimal[] extractBigDecimalColumn(FieldSpec.DataType storedType, DataBlock dataBlock, int colId, @Nullable RoaringBitmap nullBitmap) {
        Object[] values;
        block27: {
            int numRows;
            block26: {
                numRows = dataBlock.getNumberOfRows();
                values = new BigDecimal[numRows];
                if (numRows == 0) {
                    return values;
                }
                if (storedType == FieldSpec.DataType.UNKNOWN) {
                    Arrays.fill(values, CommonConstants.NullValuePlaceHolder.BIG_DECIMAL);
                    return values;
                }
                if (nullBitmap != null) break block26;
                switch (storedType) {
                    case INT: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = BigDecimal.valueOf(dataBlock.getInt(rowId, colId));
                        }
                        break block27;
                    }
                    case LONG: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = BigDecimal.valueOf(dataBlock.getLong(rowId, colId));
                        }
                        break block27;
                    }
                    case FLOAT: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = BigDecimal.valueOf(dataBlock.getFloat(rowId, colId));
                        }
                        break block27;
                    }
                    case DOUBLE: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = BigDecimal.valueOf(dataBlock.getDouble(rowId, colId));
                        }
                        break block27;
                    }
                    case BIG_DECIMAL: {
                        for (int rowId = 0; rowId < numRows; ++rowId) {
                            values[rowId] = dataBlock.getBigDecimal(rowId, colId);
                        }
                        break block27;
                    }
                    default: {
                        throw new IllegalStateException("Cannot extract BigDecimal values for column: " + dataBlock.getDataSchema().getColumnName(colId) + " with stored type: " + storedType);
                    }
                }
            }
            switch (storedType) {
                case INT: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        values[rowId] = !nullBitmap.contains(rowId) ? BigDecimal.valueOf(dataBlock.getInt(rowId, colId)) : CommonConstants.NullValuePlaceHolder.BIG_DECIMAL;
                    }
                    break;
                }
                case LONG: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        values[rowId] = !nullBitmap.contains(rowId) ? BigDecimal.valueOf(dataBlock.getLong(rowId, colId)) : CommonConstants.NullValuePlaceHolder.BIG_DECIMAL;
                    }
                    break;
                }
                case FLOAT: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        values[rowId] = !nullBitmap.contains(rowId) ? new BigDecimal(Float.toString(dataBlock.getFloat(rowId, colId))) : CommonConstants.NullValuePlaceHolder.BIG_DECIMAL;
                    }
                    break;
                }
                case DOUBLE: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        values[rowId] = !nullBitmap.contains(rowId) ? new BigDecimal(Double.toString(dataBlock.getDouble(rowId, colId))) : CommonConstants.NullValuePlaceHolder.BIG_DECIMAL;
                    }
                    break;
                }
                case BIG_DECIMAL: {
                    for (int rowId = 0; rowId < numRows; ++rowId) {
                        values[rowId] = !nullBitmap.contains(rowId) ? dataBlock.getBigDecimal(rowId, colId) : CommonConstants.NullValuePlaceHolder.BIG_DECIMAL;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot extract BigDecimal values for column: " + dataBlock.getDataSchema().getColumnName(colId) + " with stored type: " + storedType);
                }
            }
        }
        return values;
    }

    public static String[] extractStringColumn(FieldSpec.DataType storedType, DataBlock dataBlock, int colId, @Nullable RoaringBitmap nullBitmap) {
        int numRows = dataBlock.getNumberOfRows();
        Object[] values = new String[numRows];
        if (numRows == 0) {
            return values;
        }
        if (storedType == FieldSpec.DataType.UNKNOWN) {
            Arrays.fill(values, "");
            return values;
        }
        Preconditions.checkState((storedType == FieldSpec.DataType.STRING ? 1 : 0) != 0, (String)"Cannot extract String values for column: %s with stored type: %s", (Object)dataBlock.getDataSchema().getColumnName(colId), (Object)storedType);
        if (nullBitmap == null) {
            for (int rowId = 0; rowId < numRows; ++rowId) {
                values[rowId] = dataBlock.getString(rowId, colId);
            }
        } else {
            for (int rowId = 0; rowId < numRows; ++rowId) {
                values[rowId] = !nullBitmap.contains(rowId) ? dataBlock.getString(rowId, colId) : "";
            }
        }
        return values;
    }

    public static byte[][] extractBytesColumn(FieldSpec.DataType storedType, DataBlock dataBlock, int colId, @Nullable RoaringBitmap nullBitmap) {
        int numRows = dataBlock.getNumberOfRows();
        byte[][] values = new byte[numRows][];
        if (numRows == 0) {
            return values;
        }
        if (storedType == FieldSpec.DataType.UNKNOWN) {
            Arrays.fill((Object[])values, CommonConstants.NullValuePlaceHolder.BYTES);
            return values;
        }
        Preconditions.checkState((storedType == FieldSpec.DataType.BYTES ? 1 : 0) != 0, (String)"Cannot extract byte[] values for column: %s with stored type: %s", (Object)dataBlock.getDataSchema().getColumnName(colId), (Object)storedType);
        if (nullBitmap == null) {
            for (int rowId = 0; rowId < numRows; ++rowId) {
                values[rowId] = dataBlock.getBytes(rowId, colId).getBytes();
            }
        } else {
            for (int rowId = 0; rowId < numRows; ++rowId) {
                values[rowId] = !nullBitmap.contains(rowId) ? dataBlock.getBytes(rowId, colId).getBytes() : CommonConstants.NullValuePlaceHolder.BYTES;
            }
        }
        return values;
    }

    public static int[] extractIntColumn(FieldSpec.DataType storedType, DataBlock dataBlock, int colId, int numMatchedRows, RoaringBitmap matchedBitmap, @Nullable RoaringBitmap matchedNullBitmap) {
        int[] values = new int[numMatchedRows];
        if (numMatchedRows == 0 || storedType == FieldSpec.DataType.UNKNOWN) {
            return values;
        }
        PeekableIntIterator iterator = matchedBitmap.getIntIterator();
        block7: for (int matchedRowId = 0; matchedRowId < numMatchedRows; ++matchedRowId) {
            int rowId = iterator.next();
            if (matchedNullBitmap != null && matchedNullBitmap.contains(matchedRowId)) continue;
            switch (storedType) {
                case INT: {
                    values[matchedRowId] = dataBlock.getInt(rowId, colId);
                    continue block7;
                }
                case LONG: {
                    values[matchedRowId] = (int)dataBlock.getLong(rowId, colId);
                    continue block7;
                }
                case FLOAT: {
                    values[matchedRowId] = (int)dataBlock.getFloat(rowId, colId);
                    continue block7;
                }
                case DOUBLE: {
                    values[matchedRowId] = (int)dataBlock.getDouble(rowId, colId);
                    continue block7;
                }
                case BIG_DECIMAL: {
                    values[matchedRowId] = dataBlock.getBigDecimal(rowId, colId).intValue();
                    continue block7;
                }
                default: {
                    throw new IllegalStateException("Cannot extract int values for column: " + dataBlock.getDataSchema().getColumnName(colId) + " with stored type: " + storedType);
                }
            }
        }
        return values;
    }

    public static long[] extractLongColumn(FieldSpec.DataType storedType, DataBlock dataBlock, int colId, int numMatchedRows, RoaringBitmap matchedBitmap, @Nullable RoaringBitmap matchedNullBitmap) {
        long[] values = new long[numMatchedRows];
        if (numMatchedRows == 0 || storedType == FieldSpec.DataType.UNKNOWN) {
            return values;
        }
        PeekableIntIterator iterator = matchedBitmap.getIntIterator();
        block7: for (int matchedRowId = 0; matchedRowId < numMatchedRows; ++matchedRowId) {
            int rowId = iterator.next();
            if (matchedNullBitmap != null && matchedNullBitmap.contains(matchedRowId)) continue;
            switch (storedType) {
                case INT: {
                    values[matchedRowId] = dataBlock.getInt(rowId, colId);
                    continue block7;
                }
                case LONG: {
                    values[matchedRowId] = dataBlock.getLong(rowId, colId);
                    continue block7;
                }
                case FLOAT: {
                    values[matchedRowId] = (long)dataBlock.getFloat(rowId, colId);
                    continue block7;
                }
                case DOUBLE: {
                    values[matchedRowId] = (long)dataBlock.getDouble(rowId, colId);
                    continue block7;
                }
                case BIG_DECIMAL: {
                    values[matchedRowId] = dataBlock.getBigDecimal(rowId, colId).longValue();
                    continue block7;
                }
                default: {
                    throw new IllegalStateException("Cannot extract long values for column: " + dataBlock.getDataSchema().getColumnName(colId) + " with stored type: " + storedType);
                }
            }
        }
        return values;
    }

    public static float[] extractFloatColumn(FieldSpec.DataType storedType, DataBlock dataBlock, int colId, int numMatchedRows, RoaringBitmap matchedBitmap, @Nullable RoaringBitmap matchedNullBitmap) {
        float[] values = new float[numMatchedRows];
        if (numMatchedRows == 0 || storedType == FieldSpec.DataType.UNKNOWN) {
            return values;
        }
        PeekableIntIterator iterator = matchedBitmap.getIntIterator();
        block7: for (int matchedRowId = 0; matchedRowId < numMatchedRows; ++matchedRowId) {
            int rowId = iterator.next();
            if (matchedNullBitmap != null && matchedNullBitmap.contains(matchedRowId)) continue;
            switch (storedType) {
                case INT: {
                    values[matchedRowId] = dataBlock.getInt(rowId, colId);
                    continue block7;
                }
                case LONG: {
                    values[matchedRowId] = dataBlock.getLong(rowId, colId);
                    continue block7;
                }
                case FLOAT: {
                    values[matchedRowId] = dataBlock.getFloat(rowId, colId);
                    continue block7;
                }
                case DOUBLE: {
                    values[matchedRowId] = (float)dataBlock.getDouble(rowId, colId);
                    continue block7;
                }
                case BIG_DECIMAL: {
                    values[matchedRowId] = dataBlock.getBigDecimal(rowId, colId).floatValue();
                    continue block7;
                }
                default: {
                    throw new IllegalStateException("Cannot extract float values for column: " + dataBlock.getDataSchema().getColumnName(colId) + " with stored type: " + storedType);
                }
            }
        }
        return values;
    }

    public static double[] extractDoubleColumn(FieldSpec.DataType storedType, DataBlock dataBlock, int colId, int numMatchedRows, RoaringBitmap matchedBitmap, @Nullable RoaringBitmap matchedNullBitmap) {
        double[] values = new double[numMatchedRows];
        if (numMatchedRows == 0 || storedType == FieldSpec.DataType.UNKNOWN) {
            return values;
        }
        PeekableIntIterator iterator = matchedBitmap.getIntIterator();
        block7: for (int matchedRowId = 0; matchedRowId < numMatchedRows; ++matchedRowId) {
            int rowId = iterator.next();
            if (matchedNullBitmap != null && matchedNullBitmap.contains(matchedRowId)) continue;
            switch (storedType) {
                case INT: {
                    values[matchedRowId] = dataBlock.getInt(rowId, colId);
                    continue block7;
                }
                case LONG: {
                    values[matchedRowId] = dataBlock.getLong(rowId, colId);
                    continue block7;
                }
                case FLOAT: {
                    values[matchedRowId] = dataBlock.getFloat(rowId, colId);
                    continue block7;
                }
                case DOUBLE: {
                    values[matchedRowId] = dataBlock.getDouble(rowId, colId);
                    continue block7;
                }
                case BIG_DECIMAL: {
                    values[matchedRowId] = dataBlock.getBigDecimal(rowId, colId).doubleValue();
                    continue block7;
                }
                default: {
                    throw new IllegalStateException("Cannot extract double values for column: " + dataBlock.getDataSchema().getColumnName(colId) + " with stored type: " + storedType);
                }
            }
        }
        return values;
    }

    public static BigDecimal[] extractBigDecimalColumn(FieldSpec.DataType storedType, DataBlock dataBlock, int colId, int numMatchedRows, RoaringBitmap matchedBitmap, @Nullable RoaringBitmap matchedNullBitmap) {
        Object[] values = new BigDecimal[numMatchedRows];
        if (numMatchedRows == 0) {
            return values;
        }
        if (storedType == FieldSpec.DataType.UNKNOWN) {
            Arrays.fill(values, CommonConstants.NullValuePlaceHolder.BIG_DECIMAL);
            return values;
        }
        PeekableIntIterator iterator = matchedBitmap.getIntIterator();
        block7: for (int matchedRowId = 0; matchedRowId < numMatchedRows; ++matchedRowId) {
            int rowId = iterator.next();
            if (matchedNullBitmap != null && matchedNullBitmap.contains(matchedRowId)) {
                values[matchedRowId] = CommonConstants.NullValuePlaceHolder.BIG_DECIMAL;
                continue;
            }
            switch (storedType) {
                case INT: {
                    values[matchedRowId] = BigDecimal.valueOf(dataBlock.getInt(rowId, colId));
                    continue block7;
                }
                case LONG: {
                    values[matchedRowId] = BigDecimal.valueOf(dataBlock.getLong(rowId, colId));
                    continue block7;
                }
                case FLOAT: {
                    values[matchedRowId] = BigDecimal.valueOf(dataBlock.getFloat(rowId, colId));
                    continue block7;
                }
                case DOUBLE: {
                    values[matchedRowId] = BigDecimal.valueOf(dataBlock.getDouble(rowId, colId));
                    continue block7;
                }
                case BIG_DECIMAL: {
                    values[matchedRowId] = dataBlock.getBigDecimal(rowId, colId);
                    continue block7;
                }
                default: {
                    throw new IllegalStateException("Cannot extract BigDecimal values for column: " + dataBlock.getDataSchema().getColumnName(colId) + " with stored type: " + storedType);
                }
            }
        }
        return values;
    }

    public static String[] extractStringColumn(FieldSpec.DataType storedType, DataBlock dataBlock, int colId, int numMatchedRows, RoaringBitmap matchedBitmap, @Nullable RoaringBitmap matchedNullBitmap) {
        Object[] values = new String[numMatchedRows];
        if (numMatchedRows == 0) {
            return values;
        }
        if (storedType == FieldSpec.DataType.UNKNOWN) {
            Arrays.fill(values, "");
            return values;
        }
        Preconditions.checkState((storedType == FieldSpec.DataType.STRING ? 1 : 0) != 0, (String)"Cannot extract String values for column: %s with stored type: %s", (Object)dataBlock.getDataSchema().getColumnName(colId), (Object)storedType);
        PeekableIntIterator iterator = matchedBitmap.getIntIterator();
        for (int matchedRowId = 0; matchedRowId < numMatchedRows; ++matchedRowId) {
            int rowId = iterator.next();
            boolean isNull = matchedNullBitmap != null && matchedNullBitmap.contains(matchedRowId);
            values[matchedRowId] = !isNull ? dataBlock.getString(rowId, colId) : "";
        }
        return values;
    }

    public static byte[][] extractBytesColumn(FieldSpec.DataType storedType, DataBlock dataBlock, int colId, int numMatchedRows, RoaringBitmap matchedBitmap, @Nullable RoaringBitmap matchedNullBitmap) {
        byte[][] values = new byte[numMatchedRows][];
        if (numMatchedRows == 0) {
            return values;
        }
        if (storedType == FieldSpec.DataType.UNKNOWN) {
            Arrays.fill((Object[])values, CommonConstants.NullValuePlaceHolder.BYTES);
            return values;
        }
        Preconditions.checkState((storedType == FieldSpec.DataType.BYTES ? 1 : 0) != 0, (String)"Cannot extract byte[] values for column: %s with stored type: %s", (Object)dataBlock.getDataSchema().getColumnName(colId), (Object)storedType);
        PeekableIntIterator iterator = matchedBitmap.getIntIterator();
        for (int matchedRowId = 0; matchedRowId < numMatchedRows; ++matchedRowId) {
            int rowId = iterator.next();
            boolean isNull = matchedNullBitmap != null && matchedNullBitmap.contains(matchedRowId);
            values[matchedRowId] = !isNull ? dataBlock.getBytes(rowId, colId).getBytes() : CommonConstants.NullValuePlaceHolder.BYTES;
        }
        return values;
    }
}

