/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.query.request.context.QueryContext;

public class GapfillUtils {
    private static final String GAP_FILL = "gapfill";
    private static final String AS = "as";
    private static final String FILL = "fill";
    private static final String TIME_SERIES_ON = "timeserieson";
    private static final int STARTING_INDEX_OF_OPTIONAL_ARGS_FOR_PRE_AGGREGATE_GAP_FILL = 5;

    private GapfillUtils() {
    }

    public static ExpressionContext stripGapfill(ExpressionContext expression) {
        if (expression.getType() != ExpressionContext.Type.FUNCTION) {
            return expression;
        }
        FunctionContext function = expression.getFunction();
        String functionName = function.getFunctionName();
        if (functionName.equals(FILL) || functionName.equals(GAP_FILL)) {
            return (ExpressionContext)function.getArguments().get(0);
        }
        return expression;
    }

    public static boolean isFill(ExpressionContext expressionContext) {
        if (expressionContext.getType() != ExpressionContext.Type.FUNCTION) {
            return false;
        }
        return FILL.equals(expressionContext.getFunction().getFunctionName());
    }

    public static boolean isTimeSeriesOn(ExpressionContext expressionContext) {
        if (expressionContext.getType() != ExpressionContext.Type.FUNCTION) {
            return false;
        }
        return TIME_SERIES_ON.equals(expressionContext.getFunction().getFunctionName());
    }

    public static Serializable getDefaultValue(DataSchema.ColumnDataType dataType) {
        switch (dataType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case TIMESTAMP: {
                return dataType.convertAndFormat((Object)0);
            }
            case STRING: 
            case JSON: 
            case BYTES: {
                return "";
            }
            case INT_ARRAY: {
                return new int[0];
            }
            case LONG_ARRAY: {
                return new long[0];
            }
            case FLOAT_ARRAY: {
                return new float[0];
            }
            case DOUBLE_ARRAY: {
                return new double[0];
            }
            case STRING_ARRAY: 
            case TIMESTAMP_ARRAY: {
                return new String[0];
            }
            case BOOLEAN_ARRAY: {
                return new boolean[0];
            }
            case BYTES_ARRAY: {
                return new byte[0][0];
            }
        }
        throw new IllegalStateException("Cannot provide the default value for the type: " + dataType);
    }

    public static boolean isGapfill(ExpressionContext expressionContext) {
        if (expressionContext.getType() != ExpressionContext.Type.FUNCTION) {
            return false;
        }
        return GAP_FILL.equals(expressionContext.getFunction().getFunctionName());
    }

    private static boolean isGapfill(QueryContext queryContext) {
        for (ExpressionContext expressionContext : queryContext.getSelectExpressions()) {
            if (!GapfillUtils.isGapfill(expressionContext)) continue;
            return true;
        }
        return false;
    }

    public static GapfillType getGapfillType(QueryContext queryContext) {
        GapfillType gapfillType = null;
        if (queryContext.getSubquery() == null) {
            if (GapfillUtils.isGapfill(queryContext)) {
                Preconditions.checkArgument((queryContext.getAggregationFunctions() == null ? 1 : 0) != 0, (Object)"Aggregation and Gapfill can not be in the same sql statement.");
                gapfillType = GapfillType.GAP_FILL;
            }
        } else if (GapfillUtils.isGapfill(queryContext)) {
            Preconditions.checkArgument((queryContext.getSubquery().getAggregationFunctions() != null ? 1 : 0) != 0, (Object)"Select and Gapfill should be in the same sql statement.");
            Preconditions.checkArgument((queryContext.getSubquery().getSubquery() == null ? 1 : 0) != 0, (Object)"There is no three levels nesting sql when the outer query is gapfill.");
            gapfillType = GapfillType.AGGREGATE_GAP_FILL;
        } else if (GapfillUtils.isGapfill(queryContext.getSubquery())) {
            if (queryContext.getAggregationFunctions() == null) {
                gapfillType = GapfillType.GAP_FILL_SELECT;
            } else if (queryContext.getSubquery().getSubquery() == null) {
                gapfillType = GapfillType.GAP_FILL_AGGREGATE;
            } else {
                Preconditions.checkArgument((queryContext.getSubquery().getSubquery().getAggregationFunctions() != null ? 1 : 0) != 0, (Object)"Select cannot happen before gapfill.");
                gapfillType = GapfillType.AGGREGATE_GAP_FILL_AGGREGATE;
            }
        }
        if (gapfillType == null) {
            return gapfillType;
        }
        ExpressionContext gapFillSelection = GapfillUtils.getGapfillExpressionContext(queryContext, gapfillType);
        Preconditions.checkArgument((gapFillSelection != null && gapFillSelection.getFunction() != null ? 1 : 0) != 0, (Object)"Gapfill Expression should be function.");
        List args = gapFillSelection.getFunction().getArguments();
        Preconditions.checkArgument((args.size() > 5 ? 1 : 0) != 0, (Object)"Gapfill does not have correct number of arguments.");
        Preconditions.checkArgument((((ExpressionContext)args.get(1)).getLiteral() != null ? 1 : 0) != 0, (Object)"The second argument of Gapfill should be TimeFormatter.");
        Preconditions.checkArgument((((ExpressionContext)args.get(2)).getLiteral() != null ? 1 : 0) != 0, (Object)"The third argument of Gapfill should be start time.");
        Preconditions.checkArgument((((ExpressionContext)args.get(3)).getLiteral() != null ? 1 : 0) != 0, (Object)"The fourth argument of Gapfill should be end time.");
        Preconditions.checkArgument((((ExpressionContext)args.get(4)).getLiteral() != null ? 1 : 0) != 0, (Object)"The fifth argument of Gapfill should be time bucket size.");
        ExpressionContext timeseriesOn = GapfillUtils.getTimeSeriesOnExpressionContext(gapFillSelection);
        Preconditions.checkArgument((timeseriesOn != null ? 1 : 0) != 0, (Object)"The TimeSeriesOn expressions should be specified.");
        if (queryContext.getAggregationFunctions() == null) {
            return gapfillType;
        }
        List<ExpressionContext> groupbyExpressions = queryContext.getGroupByExpressions();
        Preconditions.checkArgument((groupbyExpressions != null ? 1 : 0) != 0, (Object)"No GroupBy Clause.");
        List<ExpressionContext> innerSelections = queryContext.getSubquery().getSelectExpressions();
        String timeBucketCol = null;
        List<String> strAlias = queryContext.getSubquery().getAliasList();
        for (int i = 0; i < innerSelections.size(); ++i) {
            ExpressionContext innerSelection = innerSelections.get(i);
            if (!GapfillUtils.isGapfill(innerSelection)) continue;
            if (strAlias.get(i) != null) {
                timeBucketCol = strAlias.get(i);
                break;
            }
            timeBucketCol = ((ExpressionContext)innerSelection.getFunction().getArguments().get(0)).toString();
            break;
        }
        Preconditions.checkArgument((timeBucketCol != null ? 1 : 0) != 0, (Object)"No Group By timebucket.");
        boolean findTimeBucket = false;
        for (ExpressionContext groupbyExp : groupbyExpressions) {
            if (!timeBucketCol.equals(groupbyExp.toString())) continue;
            findTimeBucket = true;
            break;
        }
        Preconditions.checkArgument((boolean)findTimeBucket, (Object)"No Group By timebucket.");
        return gapfillType;
    }

    private static ExpressionContext findGapfillExpressionContext(QueryContext queryContext) {
        for (ExpressionContext expressionContext : queryContext.getSelectExpressions()) {
            if (!GapfillUtils.isGapfill(expressionContext)) continue;
            return expressionContext;
        }
        return null;
    }

    public static ExpressionContext getGapfillExpressionContext(QueryContext queryContext, GapfillType gapfillType) {
        if (gapfillType == GapfillType.AGGREGATE_GAP_FILL || gapfillType == GapfillType.GAP_FILL) {
            return GapfillUtils.findGapfillExpressionContext(queryContext);
        }
        if (gapfillType == GapfillType.GAP_FILL_AGGREGATE || gapfillType == GapfillType.AGGREGATE_GAP_FILL_AGGREGATE || gapfillType == GapfillType.GAP_FILL_SELECT) {
            return GapfillUtils.findGapfillExpressionContext(queryContext.getSubquery());
        }
        return null;
    }

    public static int findTimeBucketColumnIndex(QueryContext queryContext, GapfillType gapfillType) {
        if (gapfillType == GapfillType.GAP_FILL_AGGREGATE || gapfillType == GapfillType.GAP_FILL_SELECT || gapfillType == GapfillType.AGGREGATE_GAP_FILL_AGGREGATE) {
            queryContext = queryContext.getSubquery();
        }
        List<ExpressionContext> expressionContexts = queryContext.getSelectExpressions();
        for (int i = 0; i < expressionContexts.size(); ++i) {
            if (!GapfillUtils.isGapfill(expressionContexts.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static ExpressionContext getTimeSeriesOnExpressionContext(ExpressionContext gapFillSelection) {
        List args = gapFillSelection.getFunction().getArguments();
        for (int i = 5; i < args.size(); ++i) {
            if (!GapfillUtils.isTimeSeriesOn((ExpressionContext)args.get(i))) continue;
            return (ExpressionContext)args.get(i);
        }
        return null;
    }

    public static Map<String, ExpressionContext> getFillExpressions(ExpressionContext gapFillSelection) {
        HashMap<String, ExpressionContext> fillExpressions = new HashMap<String, ExpressionContext>();
        List args = gapFillSelection.getFunction().getArguments();
        for (int i = 5; i < args.size(); ++i) {
            if (!GapfillUtils.isFill((ExpressionContext)args.get(i))) continue;
            ExpressionContext fillExpression = (ExpressionContext)args.get(i);
            fillExpressions.put(((ExpressionContext)fillExpression.getFunction().getArguments().get(0)).getIdentifier(), fillExpression);
        }
        return fillExpressions;
    }

    public static PinotQuery stripGapfill(PinotQuery pinotQuery) {
        List orderByList;
        if (pinotQuery.getDataSource() == null || pinotQuery.getDataSource().getSubquery() == null && !GapfillUtils.hasGapfill(pinotQuery)) {
            return pinotQuery;
        }
        Map queryOptions = pinotQuery.getQueryOptions();
        while (pinotQuery.getDataSource().getSubquery() != null) {
            pinotQuery = pinotQuery.getDataSource().getSubquery();
        }
        PinotQuery strippedPinotQuery = new PinotQuery(pinotQuery);
        List selectList = strippedPinotQuery.getSelectList();
        for (int i = 0; i < selectList.size(); ++i) {
            Expression select = (Expression)selectList.get(i);
            if (select.getType() != ExpressionType.FUNCTION) continue;
            if (GAP_FILL.equals(select.getFunctionCall().getOperator())) {
                selectList.set(i, (Expression)select.getFunctionCall().getOperands().get(0));
                break;
            }
            if (!AS.equals(select.getFunctionCall().getOperator()) || ((Expression)select.getFunctionCall().getOperands().get(0)).getType() != ExpressionType.FUNCTION || !GAP_FILL.equals(((Expression)select.getFunctionCall().getOperands().get(0)).getFunctionCall().getOperator())) continue;
            select.getFunctionCall().getOperands().set(0, (Expression)((Expression)select.getFunctionCall().getOperands().get(0)).getFunctionCall().getOperands().get(0));
            break;
        }
        if ((orderByList = strippedPinotQuery.getOrderByList()) != null) {
            for (Expression orderBy : orderByList) {
                if (orderBy.getType() != ExpressionType.FUNCTION || ((Expression)orderBy.getFunctionCall().getOperands().get(0)).getType() != ExpressionType.FUNCTION || !GAP_FILL.equals(((Expression)orderBy.getFunctionCall().getOperands().get(0)).getFunctionCall().getOperator())) continue;
                orderBy.getFunctionCall().getOperands().set(0, (Expression)((Expression)orderBy.getFunctionCall().getOperands().get(0)).getFunctionCall().getOperands().get(0));
                break;
            }
        }
        strippedPinotQuery.setQueryOptions(queryOptions);
        return strippedPinotQuery;
    }

    private static boolean hasGapfill(PinotQuery pinotQuery) {
        for (Expression select : pinotQuery.getSelectList()) {
            if (select.getType() != ExpressionType.FUNCTION) continue;
            if (GAP_FILL.equals(select.getFunctionCall().getOperator())) {
                return true;
            }
            if (!AS.equals(select.getFunctionCall().getOperator()) || ((Expression)select.getFunctionCall().getOperands().get(0)).getType() != ExpressionType.FUNCTION || !GAP_FILL.equals(((Expression)select.getFunctionCall().getOperands().get(0)).getFunctionCall().getOperator())) continue;
            return true;
        }
        return false;
    }

    public static enum FillType {
        FILL_DEFAULT_VALUE,
        FILL_PREVIOUS_VALUE;

    }

    public static enum GapfillType {
        GAP_FILL,
        GAP_FILL_SELECT,
        GAP_FILL_AGGREGATE,
        AGGREGATE_GAP_FILL,
        AGGREGATE_GAP_FILL_AGGREGATE;

    }
}

