/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util;

import com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.core.data.table.ConcurrentIndexedTable;
import org.apache.pinot.core.data.table.IndexedTable;
import org.apache.pinot.core.data.table.SimpleIndexedTable;
import org.apache.pinot.core.data.table.UnboundedConcurrentIndexedTable;
import org.apache.pinot.core.operator.blocks.results.GroupByResultsBlock;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.request.context.QueryContext;

public final class GroupByUtils {
    public static final int DEFAULT_MIN_NUM_GROUPS = 5000;
    public static final int MAX_TRIM_THRESHOLD = 1000000000;

    private GroupByUtils() {
    }

    public static int getTableCapacity(int limit) {
        return GroupByUtils.getTableCapacity(limit, 5000);
    }

    public static int getTableCapacity(int limit, int minNumGroups) {
        long capacityByLimit = (long)limit * 5L;
        return capacityByLimit > Integer.MAX_VALUE ? Integer.MAX_VALUE : Math.max((int)capacityByLimit, minNumGroups);
    }

    @VisibleForTesting
    static int getIndexedTableTrimThreshold(int trimSize, int trimThreshold) {
        if (trimThreshold <= 0 || trimThreshold > 1000000000 || trimSize > 500000000) {
            return Integer.MAX_VALUE;
        }
        return Math.max(trimThreshold, 2 * trimSize);
    }

    @VisibleForTesting
    static int getIndexedTableInitialCapacity(int maxRowsToKeep, int minNumGroups, int minCapacity) {
        int upperBound = HashUtil.getHashMapCapacity((int)maxRowsToKeep);
        if (minCapacity > upperBound) {
            return upperBound;
        }
        int lowerBound = HashUtil.getHashMapCapacity((int)minNumGroups);
        if (lowerBound > upperBound) {
            return upperBound;
        }
        return Math.max(minCapacity, lowerBound);
    }

    public static IndexedTable createIndexedTableForCombineOperator(GroupByResultsBlock resultsBlock, QueryContext queryContext, int numThreads) {
        int trimSize;
        DataSchema dataSchema = resultsBlock.getDataSchema();
        int numGroups = resultsBlock.getNumGroups();
        int limit = queryContext.getLimit();
        boolean hasOrderBy = queryContext.getOrderByExpressions() != null;
        boolean hasHaving = queryContext.getHavingFilter() != null;
        int minTrimSize = queryContext.getMinServerGroupTrimSize();
        int minInitialIndexedTableCapacity = queryContext.getMinInitialIndexedTableCapacity();
        int n = trimSize = minTrimSize > 0 ? GroupByUtils.getTableCapacity(limit, minTrimSize) : Integer.MAX_VALUE;
        if (!hasOrderBy) {
            int resultSize = hasHaving ? trimSize : limit;
            int initialCapacity = GroupByUtils.getIndexedTableInitialCapacity(resultSize, numGroups, minInitialIndexedTableCapacity);
            return GroupByUtils.getTrimDisabledIndexedTable(dataSchema, false, queryContext, resultSize, initialCapacity, numThreads);
        }
        int resultSize = queryContext.isServerReturnFinalResult() && !hasHaving ? limit : trimSize;
        int trimThreshold = GroupByUtils.getIndexedTableTrimThreshold(trimSize, queryContext.getGroupTrimThreshold());
        int initialCapacity = GroupByUtils.getIndexedTableInitialCapacity(trimThreshold, numGroups, minInitialIndexedTableCapacity);
        if (trimThreshold == Integer.MAX_VALUE) {
            return GroupByUtils.getTrimDisabledIndexedTable(dataSchema, false, queryContext, resultSize, initialCapacity, numThreads);
        }
        return GroupByUtils.getTrimEnabledIndexedTable(dataSchema, false, queryContext, resultSize, trimSize, trimThreshold, initialCapacity, numThreads);
    }

    public static IndexedTable createIndexedTableForDataTableReducer(DataTable dataTable, QueryContext queryContext, DataTableReducerContext reducerContext, int numThreads) {
        int resultSize;
        DataSchema dataSchema = dataTable.getDataSchema();
        int numGroups = dataTable.getNumberOfRows();
        int limit = queryContext.getLimit();
        boolean hasOrderBy = queryContext.getOrderByExpressions() != null;
        boolean hasHaving = queryContext.getHavingFilter() != null;
        boolean hasFinalInput = queryContext.isServerReturnFinalResult() || queryContext.isServerReturnFinalResultKeyUnpartitioned();
        int minTrimSize = reducerContext.getMinGroupTrimSize();
        int minInitialIndexedTableCapacity = reducerContext.getMinInitialIndexedTableCapacity();
        int trimSize = minTrimSize > 0 ? GroupByUtils.getTableCapacity(limit, minTrimSize) : Integer.MAX_VALUE;
        int n = resultSize = hasHaving ? trimSize : limit;
        if (!hasOrderBy) {
            int initialCapacity = GroupByUtils.getIndexedTableInitialCapacity(resultSize, numGroups, minInitialIndexedTableCapacity);
            return GroupByUtils.getTrimDisabledIndexedTable(dataSchema, hasFinalInput, queryContext, resultSize, initialCapacity, numThreads);
        }
        int trimThreshold = GroupByUtils.getIndexedTableTrimThreshold(trimSize, reducerContext.getGroupByTrimThreshold());
        int initialCapacity = GroupByUtils.getIndexedTableInitialCapacity(trimThreshold, numGroups, minInitialIndexedTableCapacity);
        if (trimThreshold == Integer.MAX_VALUE) {
            return GroupByUtils.getTrimDisabledIndexedTable(dataSchema, hasFinalInput, queryContext, resultSize, initialCapacity, numThreads);
        }
        return GroupByUtils.getTrimEnabledIndexedTable(dataSchema, hasFinalInput, queryContext, resultSize, trimSize, trimThreshold, initialCapacity, numThreads);
    }

    private static IndexedTable getTrimDisabledIndexedTable(DataSchema dataSchema, boolean hasFinalInput, QueryContext queryContext, int resultSize, int initialCapacity, int numThreads) {
        if (numThreads == 1) {
            return new SimpleIndexedTable(dataSchema, hasFinalInput, queryContext, resultSize, Integer.MAX_VALUE, Integer.MAX_VALUE, initialCapacity);
        }
        return new UnboundedConcurrentIndexedTable(dataSchema, hasFinalInput, queryContext, resultSize, initialCapacity);
    }

    private static IndexedTable getTrimEnabledIndexedTable(DataSchema dataSchema, boolean hasFinalInput, QueryContext queryContext, int resultSize, int trimSize, int trimThreshold, int initialCapacity, int numThreads) {
        assert (trimThreshold != Integer.MAX_VALUE);
        if (numThreads == 1) {
            return new SimpleIndexedTable(dataSchema, hasFinalInput, queryContext, resultSize, trimSize, trimThreshold, initialCapacity);
        }
        return new ConcurrentIndexedTable(dataSchema, hasFinalInput, queryContext, resultSize, trimSize, trimThreshold, initialCapacity);
    }
}

