/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util;

import org.apache.pinot.core.util.NumericException;

public class NumberUtils {
    public static final NumericException NULL_EXCEPTION = new NumericException("Can't parse null string");
    public static final NumericException EXP_EXCEPTION = new NumericException("Wrong exponent");
    private static final long[] POWERS_OF_10 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};

    private NumberUtils() {
    }

    public static long parseLong(CharSequence cs) throws NumericException {
        if (cs == null) {
            throw NULL_EXCEPTION;
        }
        return NumberUtils.parseLong(cs, 0, cs.length());
    }

    public static long parseLong(CharSequence cs, int start, int end) throws NumericException {
        if (cs == null) {
            throw NULL_EXCEPTION;
        }
        boolean negative = false;
        int i = start;
        long limit = -9223372036854775807L;
        if (end > start) {
            char firstChar = cs.charAt(start);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw NumericException.INSTANCE;
                }
                if (end == start + 1) {
                    throw NumericException.INSTANCE;
                }
                ++i;
            }
            long multmin = limit / 10L;
            long result = 0L;
            while (i < end) {
                char c;
                if ((c = cs.charAt(i++)) < '0' || c > '9' || result < multmin) {
                    throw NumericException.INSTANCE;
                }
                int digit = c - 48;
                if ((result *= 10L) < limit + (long)digit) {
                    throw NumericException.INSTANCE;
                }
                result -= (long)digit;
            }
            return negative ? result : -result;
        }
        throw NumericException.INSTANCE;
    }

    public static long parseJsonLong(CharSequence cs) throws NumericException {
        if (cs == null) {
            throw NULL_EXCEPTION;
        }
        boolean negative = false;
        int i = 0;
        int len = cs.length();
        long limit = -9223372036854775807L;
        if (len > 0) {
            char c;
            boolean dotFound = false;
            boolean exponentFound = false;
            char firstChar = cs.charAt(0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw NumericException.INSTANCE;
                }
                if (len == 1) {
                    throw NumericException.INSTANCE;
                }
                ++i;
            }
            long multmin = limit / 10L;
            long result = 0L;
            while (i < len) {
                if ((c = cs.charAt(i++)) < '0' || c > '9' || result < multmin) {
                    if (c == '.') {
                        dotFound = true;
                        break;
                    }
                    if (c == 'e' || c == 'E') {
                        exponentFound = true;
                        break;
                    }
                    throw NumericException.INSTANCE;
                }
                int digit = c - 48;
                if ((result *= 10L) < limit + (long)digit) {
                    throw NumericException.INSTANCE;
                }
                result -= (long)digit;
            }
            if (dotFound) {
                while (i < len) {
                    if ((c = cs.charAt(i++)) >= '0' && c <= '9') continue;
                    if ((c | 0x20) == 101) {
                        exponentFound = true;
                        break;
                    }
                    throw NumericException.INSTANCE;
                }
            }
            if (exponentFound) {
                long exp;
                if (dotFound) {
                    try {
                        return (long)Double.parseDouble(cs.toString());
                    }
                    catch (NumberFormatException ne) {
                        throw NumericException.INSTANCE;
                    }
                }
                try {
                    exp = NumberUtils.parseLong(cs, i, len);
                }
                catch (NumericException nfe) {
                    throw EXP_EXCEPTION;
                }
                if (exp < 0L || exp > (long)POWERS_OF_10.length) {
                    throw EXP_EXCEPTION;
                }
                return (negative ? result : -result) * POWERS_OF_10[(int)exp];
            }
            return negative ? result : -result;
        }
        throw NumericException.INSTANCE;
    }
}

